/*
 * Decompiled with CFR 0.152.
 */
package DarkMatter.api.additional;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import necesse.engine.commands.CommandLog;
import necesse.entity.mobs.PlayerMob;

public class DarkMatterSpeedSettingHandler {
    public String getSettingName() {
        return "dmr_speed_multiplier";
    }

    public String getDescription() {
        return "Set DarkMatter projectile speed multiplier";
    }

    public String getCurrentValue(PlayerMob player) {
        try {
            Class<?> stateManagerClass = Class.forName("DarkMatter.Core.DarkMatterStateManager");
            Method getInstanceMethod = stateManagerClass.getMethod("getInstance", new Class[0]);
            Object stateManager = getInstanceMethod.invoke(null, new Object[0]);
            Method getSpeedMethod = stateManagerClass.getMethod("getSpeedMultiplier", new Class[0]);
            float speed = ((Float)getSpeedMethod.invoke(stateManager, new Object[0])).floatValue();
            return String.format("%.1f", Float.valueOf(speed));
        }
        catch (Exception exception) {
            return "1.0";
        }
    }

    public void applySetting(PlayerMob player, String value, CommandLog logs) {
        try {
            float multiplier;
            if (value.equals("reset")) {
                multiplier = 1.0f;
            } else {
                multiplier = Float.parseFloat(value);
                if (multiplier < 0.1f) {
                    multiplier = 0.1f;
                }
                if (multiplier > 10.0f) {
                    multiplier = 10.0f;
                }
            }
            Class<?> stateManagerClass = Class.forName("DarkMatter.Core.DarkMatterStateManager");
            Method getInstanceMethod = stateManagerClass.getMethod("getInstance", new Class[0]);
            Object stateManager = getInstanceMethod.invoke(null, new Object[0]);
            Method setSpeedMethod = stateManagerClass.getMethod("setSpeedMultiplier", Float.TYPE);
            setSpeedMethod.invoke(stateManager, Float.valueOf(multiplier));
            logs.add("[SUCCESS] Projectile speed multiplier set to: " + multiplier + "x");
        }
        catch (NumberFormatException e) {
            logs.add("[ERROR] Invalid speed value: " + value);
            logs.add("[INFO] Use numbers like 0.5, 1.0, 2.0 or 'reset' for default");
        }
        catch (Exception e) {
            logs.add("[ERROR] Failed to set speed multiplier: " + e.getMessage());
        }
    }

    public List<String> getAutoCompleteSuggestions() {
        return Arrays.asList("reset", "0.1", "0.25", "0.5", "0.75", "1.0", "1.5", "2.0", "3.0", "5.0", "10.0");
    }

    public String getCategory() {
        return "DarkMatter";
    }
}

