/*
 * Decompiled with CFR 0.152.
 */
package DarkMatter.api.additional;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import necesse.engine.commands.CommandLog;
import necesse.entity.mobs.PlayerMob;

public class DarkMatterModifierSettingHandler {
    private final String modifierType;

    public DarkMatterModifierSettingHandler(String modifierType) {
        this.modifierType = modifierType;
    }

    public String getSettingName() {
        return "dmr_" + this.modifierType + "_modifier";
    }

    public String getDescription() {
        return "Toggle " + this.modifierType + " boost modifier for DarkMatter projectiles";
    }

    public String getCurrentValue(PlayerMob player) {
        try {
            Class<?> stateManagerClass = Class.forName("DarkMatter.Core.DarkMatterStateManager");
            Method getInstanceMethod = stateManagerClass.getMethod("getInstance", new Class[0]);
            Object stateManager = getInstanceMethod.invoke(null, new Object[0]);
            Method hasModifierMethod = stateManagerClass.getMethod("has" + this.capitalize(this.modifierType) + "Modifier", new Class[0]);
            boolean active = (Boolean)hasModifierMethod.invoke(stateManager, new Object[0]);
            return active ? "ENABLED" : "disabled";
        }
        catch (Exception exception) {
            return "disabled";
        }
    }

    public void applySetting(PlayerMob player, String value, CommandLog logs) {
        try {
            String current;
            boolean newState = value.equals("toggle") ? !(current = this.getCurrentValue(player)).equals("ENABLED") : Boolean.parseBoolean(value);
            Class<?> stateManagerClass = Class.forName("DarkMatter.Core.DarkMatterStateManager");
            Method getInstanceMethod = stateManagerClass.getMethod("getInstance", new Class[0]);
            Object stateManager = getInstanceMethod.invoke(null, new Object[0]);
            Method setModifierMethod = stateManagerClass.getMethod("set" + this.capitalize(this.modifierType) + "Modifier", Boolean.TYPE);
            setModifierMethod.invoke(stateManager, newState);
            logs.add("[SUCCESS] " + this.capitalize(this.modifierType) + " modifier " + (newState ? "ENABLED" : "disabled"));
        }
        catch (Exception e) {
            logs.add("[ERROR] Failed to toggle " + this.modifierType + " modifier: " + e.getMessage());
        }
    }

    public List<String> getAutoCompleteSuggestions() {
        return Arrays.asList("toggle", "true", "false", "on", "off");
    }

    public String getCategory() {
        return "DarkMatter";
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

