/*
 * Decompiled with CFR 0.152.
 */
package DarkMatter.api;

import DarkMatter.Core.DarkMatterStateManager;
import DarkMatter.Network.PacketProjectileTypeSync;
import java.util.Arrays;
import java.util.List;
import necesse.engine.commands.CommandLog;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.PlayerMob;

public class DarkMatterProjectileSettingsHandler {
    public String getSettingName() {
        return "dmr_projectile";
    }

    public String getDescription() {
        return "Configure Dark Matter Rifle projectile type and behavior";
    }

    public String getCategory() {
        return "Weapons";
    }

    public void applySetting(PlayerMob player, String value, CommandLog logs) {
        try {
            if (player == null) {
                logs.add("[ERROR] No player found - make sure you're in a world with a player character");
                return;
            }
            DarkMatterStateManager stateManager = DarkMatterStateManager.getInstance();
            ServerClient networkClient = null;
            if (!player.getLevel().isServer()) {
                this.handleClientSideSetting(player, value, logs);
                if (this.isProjectileTypeChange(value)) {
                    this.sendProjectileTypeToServer(player, value);
                }
                return;
            }
            networkClient = player.getServerClient();
            if (networkClient == null) {
                logs.add("[ERROR] Cannot access player settings - no network client found");
                return;
            }
            switch (value.toLowerCase()) {
                case "normal": {
                    stateManager.setPlayerProjectileType((NetworkClient)networkClient, "normal");
                    logs.add("[SUCCESS] Projectile type set to: normal");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "normal");
                    break;
                }
                case "bomb": {
                    stateManager.setPlayerProjectileType((NetworkClient)networkClient, "bomb");
                    logs.add("[SUCCESS] Projectile type set to: bomb");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "bomb");
                    break;
                }
                case "tree": {
                    stateManager.setPlayerProjectileType((NetworkClient)networkClient, "tree");
                    logs.add("[SUCCESS] Projectile type set to: tree");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "tree");
                    break;
                }
                case "piercing": {
                    stateManager.setPlayerProjectileType((NetworkClient)networkClient, "piercing");
                    logs.add("[SUCCESS] Projectile type set to: piercing");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "piercing");
                    break;
                }
                case "homing": {
                    stateManager.setPlayerProjectileType((NetworkClient)networkClient, "homing");
                    logs.add("[SUCCESS] Projectile type set to: homing");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "homing");
                    break;
                }
                case "ricochet": {
                    stateManager.setPlayerProjectileType((NetworkClient)networkClient, "ricochet");
                    logs.add("[SUCCESS] Projectile type set to: ricochet");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "ricochet");
                    break;
                }
                case "laser": {
                    stateManager.setPlayerProjectileType((NetworkClient)networkClient, "laser");
                    logs.add("[SUCCESS] Projectile type set to: laser");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "laser");
                    break;
                }
                case "multi": {
                    stateManager.setPlayerProjectileType((NetworkClient)networkClient, "multi");
                    logs.add("[SUCCESS] Projectile type set to: multi");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "multi");
                    break;
                }
                case "damage_boost": {
                    boolean currentDamage = stateManager.getPlayerDamageBoost((NetworkClient)networkClient);
                    stateManager.setPlayerDamageBoost((NetworkClient)networkClient, !currentDamage);
                    logs.add("[SUCCESS] Damage boost " + (!currentDamage ? "enabled" : "disabled"));
                    break;
                }
                case "speed_boost": {
                    boolean currentSpeed = stateManager.getPlayerSpeedBoost((NetworkClient)networkClient);
                    stateManager.setPlayerSpeedBoost((NetworkClient)networkClient, !currentSpeed);
                    logs.add("[SUCCESS] Speed boost " + (!currentSpeed ? "enabled" : "disabled"));
                    break;
                }
                case "range_boost": {
                    boolean currentRange = stateManager.getPlayerRangeBoost((NetworkClient)networkClient);
                    stateManager.setPlayerRangeBoost((NetworkClient)networkClient, !currentRange);
                    logs.add("[SUCCESS] Range boost " + (!currentRange ? "enabled" : "disabled"));
                    break;
                }
                case "reset": {
                    stateManager.resetPlayerProjectileSettings((NetworkClient)networkClient);
                    logs.add("[SUCCESS] All projectile settings reset to defaults");
                    this.syncProjectileTypeToClient((NetworkClient)networkClient, "normal");
                    break;
                }
                case "list": {
                    this.showCurrentSettings(stateManager, (NetworkClient)networkClient, logs);
                    break;
                }
                default: {
                    logs.add("[ERROR] Invalid projectile setting: " + value);
                    logs.add("[INFO] Valid projectile types:");
                    logs.add("  'normal' - Standard piercing projectiles");
                    logs.add("  'bomb' - Explosive projectiles");
                    logs.add("  'tree' - Tree-breaking projectiles");
                    logs.add("  'piercing' - Enhanced piercing");
                    logs.add("  'homing' - Target-seeking projectiles");
                    logs.add("  'ricochet' - Bouncing projectiles");
                    logs.add("  'laser' - Instant-hit laser projectiles");
                    logs.add("  'multi' - Multiple projectile spread");
                    logs.add("[INFO] Valid stat modifiers:");
                    logs.add("  'damage_boost' - Increase projectile damage");
                    logs.add("  'speed_boost' - Increase projectile speed");
                    logs.add("  'range_boost' - Increase projectile range");
                    logs.add("[INFO] Other commands:");
                    logs.add("  'reset' - Reset all projectile settings");
                    logs.add("  'list' - Show current projectile settings");
                    break;
                }
            }
        }
        catch (Exception e) {
            logs.add("[ERROR] Failed to modify projectile settings: " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public String getCurrentValue(PlayerMob player) {
        try {
            if (player == null) {
                return "[ERROR: No player found]";
            }
            DarkMatterStateManager stateManager = DarkMatterStateManager.getInstance();
            StringBuilder status = new StringBuilder();
            if (player.getLevel().isServer()) {
                ServerClient networkClient = player.getServerClient();
                if (networkClient == null) {
                    return "[ERROR: No network client found]";
                }
                String projectileType = stateManager.getPlayerProjectileType((NetworkClient)networkClient);
                boolean damageBoost = stateManager.getPlayerDamageBoost((NetworkClient)networkClient);
                boolean speedBoost = stateManager.getPlayerSpeedBoost((NetworkClient)networkClient);
                boolean rangeBoost = stateManager.getPlayerRangeBoost((NetworkClient)networkClient);
                status.append("Type: ").append(projectileType);
                if (damageBoost || speedBoost || rangeBoost) {
                    status.append(" | Modifiers: ");
                    if (damageBoost) {
                        status.append("damage ");
                    }
                    if (speedBoost) {
                        status.append("speed ");
                    }
                    if (rangeBoost) {
                        status.append("range ");
                    }
                }
            } else {
                String projectileType = stateManager.getClientProjectileType();
                status.append("Type: ").append(projectileType);
                status.append(" | Modifiers: server-side only");
            }
            return status.toString().trim();
        }
        catch (Exception e) {
            return "[ERROR: " + e.getClass().getSimpleName() + " - " + e.getMessage() + " ]";
        }
    }

    public List<String> getAutoCompleteSuggestions() {
        return Arrays.asList("normal", "bomb", "tree", "piercing", "homing", "ricochet", "laser", "multi", "damage_boost", "speed_boost", "range_boost", "reset", "list");
    }

    private void showCurrentSettings(DarkMatterStateManager stateManager, NetworkClient networkClient, CommandLog logs) {
        try {
            String projectileType = stateManager.getPlayerProjectileType(networkClient);
            boolean damageBoost = stateManager.getPlayerDamageBoost(networkClient);
            boolean speedBoost = stateManager.getPlayerSpeedBoost(networkClient);
            boolean rangeBoost = stateManager.getPlayerRangeBoost(networkClient);
            logs.add("[INFO] Current projectile settings:");
            logs.add("  Type: " + projectileType);
            logs.add("  Modifiers: damage=" + damageBoost + ", speed=" + speedBoost + ", range=" + rangeBoost);
        }
        catch (Exception e) {
            logs.add("[ERROR] Failed to read current settings: " + e.getMessage());
        }
    }

    private void handleClientSideSetting(PlayerMob player, String value, CommandLog logs) {
        try {
            DarkMatterStateManager stateManager = DarkMatterStateManager.getInstance();
            switch (value.toLowerCase()) {
                case "normal": {
                    stateManager.setClientProjectileType("normal");
                    logs.add("[SUCCESS] Projectile type set to: normal");
                    break;
                }
                case "bomb": {
                    stateManager.setClientProjectileType("bomb");
                    logs.add("[SUCCESS] Projectile type set to: bomb");
                    break;
                }
                case "tree": {
                    stateManager.setClientProjectileType("tree");
                    logs.add("[SUCCESS] Projectile type set to: tree");
                    break;
                }
                case "piercing": {
                    stateManager.setClientProjectileType("piercing");
                    logs.add("[SUCCESS] Projectile type set to: piercing");
                    break;
                }
                case "homing": {
                    stateManager.setClientProjectileType("homing");
                    logs.add("[SUCCESS] Projectile type set to: homing");
                    break;
                }
                case "ricochet": {
                    stateManager.setClientProjectileType("ricochet");
                    logs.add("[SUCCESS] Projectile type set to: ricochet");
                    break;
                }
                case "laser": {
                    stateManager.setClientProjectileType("laser");
                    logs.add("[SUCCESS] Projectile type set to: laser");
                    break;
                }
                case "multi": {
                    stateManager.setClientProjectileType("multi");
                    logs.add("[SUCCESS] Projectile type set to: multi");
                    break;
                }
                case "damage_boost": 
                case "speed_boost": 
                case "range_boost": {
                    logs.add("[INFO] Stat modifiers are server-side only - use on multiplayer server");
                    break;
                }
                case "reset": {
                    stateManager.setClientProjectileType("normal");
                    logs.add("[SUCCESS] Projectile type reset to: normal");
                    break;
                }
                case "list": {
                    String currentType = stateManager.getClientProjectileType();
                    logs.add("[INFO] Current projectile type: " + currentType);
                    logs.add("[INFO] Stat modifiers: server-side only");
                    break;
                }
                default: {
                    logs.add("[ERROR] Invalid projectile setting: " + value);
                    logs.add("[INFO] Valid projectile types:");
                    logs.add("  'normal' - Standard piercing projectiles");
                    logs.add("  'bomb' - Explosive projectiles");
                    logs.add("  'tree' - Tree-breaking projectiles");
                    logs.add("  'piercing' - Enhanced piercing");
                    logs.add("  'homing' - Target-seeking projectiles");
                    logs.add("  'ricochet' - Bouncing projectiles");
                    logs.add("  'laser' - Instant-hit laser projectiles");
                    logs.add("  'multi' - Multiple projectile spread");
                    logs.add("[INFO] Note: Stat modifiers are server-side only");
                    break;
                }
            }
        }
        catch (Exception e) {
            logs.add("[ERROR] Failed to modify client-side projectile settings: " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    private boolean isProjectileTypeChange(String value) {
        String lowerValue = value.toLowerCase();
        return lowerValue.equals("normal") || lowerValue.equals("bomb") || lowerValue.equals("tree") || lowerValue.equals("piercing") || lowerValue.equals("homing") || lowerValue.equals("ricochet") || lowerValue.equals("laser") || lowerValue.equals("multi") || lowerValue.equals("reset");
    }

    private void sendProjectileTypeToServer(PlayerMob player, String value) {
        try {
            Client client = player.getLevel().getClient();
            if (client != null) {
                String projectileType = "normal";
                projectileType = value.equalsIgnoreCase("reset") ? "normal" : value.toLowerCase();
                PacketProjectileTypeSync packet = new PacketProjectileTypeSync(projectileType);
                client.network.sendPacket((Packet)packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void syncProjectileTypeToClient(NetworkClient networkClient, String projectileType) {
        try {
            if (networkClient instanceof ServerClient) {
                ServerClient serverClient = (ServerClient)networkClient;
                PacketProjectileTypeSync packet = new PacketProjectileTypeSync(projectileType);
                serverClient.sendPacket((Packet)packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

