/*
 * Decompiled with CFR 0.152.
 */
package DarkMatter.Core;

import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.explosionEvent.BombExplosionEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.RicochetableProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class DarkMatterTreeProjectile
extends Projectile
implements RicochetableProjectile {
    public DarkMatterTreeProjectile() {
    }

    public DarkMatterTreeProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        this();
        this.setLevel(owner.getLevel());
        this.applyData(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
        this.height = 8.5f;
        this.heightBasedOnDistance = true;
        this.setWidth(8.0f);
        this.speed = 120.0f;
        this.piercing = 0;
        this.setDistance(750);
        this.canBreakObjects = true;
        this.isSolid = true;
    }

    public void onHit(Mob mob, LevelObjectHit object, float x, float y, boolean fromPacket, ServerClient packetSubmitter) {
        if (object != null) {
            boolean isTree = this.isTreeObject(object);
            if (isTree) {
                BombExplosionEvent explosion = new BombExplosionEvent(x, y, 30, this.getDamage(), true, false, 5.0f, this.getOwner());
                this.getLevel().entityManager.addLevelEvent((LevelEvent)explosion);
                this.remove();
            } else {
                super.onHit(mob, object, x, y, fromPacket, packetSubmitter);
            }
        } else if (mob != null) {
            super.onHit(mob, object, x, y, fromPacket, packetSubmitter);
        }
        this.playHitSound(x, y);
        if (this.isClient()) {
            this.spawnWallHitParticles(x, y);
        }
    }

    private boolean isTreeObject(LevelObjectHit object) {
        String objectID = object.getObject().getStringID();
        String className = object.getObject().getClass().getName();
        return objectID.contains("tree") || objectID.contains("Tree") || className.contains("Tree") || className.contains("tree");
    }

    public boolean canHit(Mob mob) {
        return true;
    }

    public void attackThrough(LevelObjectHit object) {
        super.attackThrough(object);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y);
            float rotationAngle = this.getAngle();
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(rotationAngle, this.texture.getWidth() / 2, 0).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
        }
    }

    public Trail getTrail() {
        Trail trail = super.getTrail();
        return trail;
    }

    protected void playHitSound(float x, float y) {
        SoundManager.playSound((GameSound)GameResources.bowhit, (SoundEffect)SoundEffect.effect((float)x, (float)y));
    }
}

