/*
 * Decompiled with CFR 0.152.
 */
package DarkMatter.Core;

import java.util.HashMap;
import java.util.Map;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class DarkMatterStateManager {
    private static DarkMatterStateManager instance;
    private Map<String, Boolean> playerBombModeMap = new HashMap<String, Boolean>();
    private Map<String, String> playerProjectileTypeMap = new HashMap<String, String>();
    private Map<String, Boolean> playerDamageBoostMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> playerSpeedBoostMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> playerRangeBoostMap = new HashMap<String, Boolean>();
    private String clientProjectileType = "normal";

    private DarkMatterStateManager() {
    }

    public static DarkMatterStateManager getInstance() {
        if (instance == null) {
            instance = new DarkMatterStateManager();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void setPlayerBombMode(NetworkClient serverClient, boolean bombMode) {
        if (serverClient != null) {
            String playerAuth = this.getPlayerAuthKey(serverClient);
            this.playerBombModeMap.put(playerAuth, bombMode);
        }
    }

    public boolean getPlayerBombMode(NetworkClient serverClient) {
        if (serverClient == null) {
            return false;
        }
        String playerAuth = this.getPlayerAuthKey(serverClient);
        return this.playerBombModeMap.getOrDefault(playerAuth, false);
    }

    public void clearPlayerBombMode(NetworkClient serverClient) {
        if (serverClient != null) {
            String playerAuth = this.getPlayerAuthKey(serverClient);
            this.playerBombModeMap.remove(playerAuth);
        }
    }

    public void setPlayerProjectileType(NetworkClient networkClient, String projectileType) {
        if (networkClient != null) {
            String playerAuth = this.getPlayerAuthKey(networkClient);
            this.playerProjectileTypeMap.put(playerAuth, projectileType);
        }
    }

    public String getPlayerProjectileType(NetworkClient networkClient) {
        if (networkClient == null) {
            return "normal";
        }
        String playerAuth = this.getPlayerAuthKey(networkClient);
        return this.playerProjectileTypeMap.getOrDefault(playerAuth, "normal");
    }

    public void setPlayerDamageBoost(NetworkClient networkClient, boolean damageBoost) {
        if (networkClient != null) {
            String playerAuth = this.getPlayerAuthKey(networkClient);
            this.playerDamageBoostMap.put(playerAuth, damageBoost);
        }
    }

    public boolean getPlayerDamageBoost(NetworkClient networkClient) {
        if (networkClient == null) {
            return false;
        }
        String playerAuth = this.getPlayerAuthKey(networkClient);
        return this.playerDamageBoostMap.getOrDefault(playerAuth, false);
    }

    public void setPlayerSpeedBoost(NetworkClient networkClient, boolean speedBoost) {
        if (networkClient != null) {
            String playerAuth = this.getPlayerAuthKey(networkClient);
            this.playerSpeedBoostMap.put(playerAuth, speedBoost);
        }
    }

    public boolean getPlayerSpeedBoost(NetworkClient networkClient) {
        if (networkClient == null) {
            return false;
        }
        String playerAuth = this.getPlayerAuthKey(networkClient);
        return this.playerSpeedBoostMap.getOrDefault(playerAuth, false);
    }

    public void setPlayerRangeBoost(NetworkClient networkClient, boolean rangeBoost) {
        if (networkClient != null) {
            String playerAuth = this.getPlayerAuthKey(networkClient);
            this.playerRangeBoostMap.put(playerAuth, rangeBoost);
        }
    }

    public boolean getPlayerRangeBoost(NetworkClient networkClient) {
        if (networkClient == null) {
            return false;
        }
        String playerAuth = this.getPlayerAuthKey(networkClient);
        return this.playerRangeBoostMap.getOrDefault(playerAuth, false);
    }

    public void resetPlayerProjectileSettings(NetworkClient networkClient) {
        if (networkClient != null) {
            String playerAuth = this.getPlayerAuthKey(networkClient);
            this.playerProjectileTypeMap.remove(playerAuth);
            this.playerDamageBoostMap.remove(playerAuth);
            this.playerSpeedBoostMap.remove(playerAuth);
            this.playerRangeBoostMap.remove(playerAuth);
        }
    }

    public void setClientProjectileType(String projectileType) {
        this.clientProjectileType = projectileType;
    }

    public String getClientProjectileType() {
        return this.clientProjectileType;
    }

    public String getCurrentProjectileType(boolean isServer) {
        if (isServer) {
            return "normal";
        }
        return this.clientProjectileType;
    }

    public void syncProjectileTypeToClients(Server server, String projectileType) {
        if (server != null) {
            // empty if block
        }
    }

    public void syncProjectileTypeToClient(ServerClient serverClient, String projectileType) {
        if (serverClient != null) {
            // empty if block
        }
    }

    private String getPlayerAuthKey(NetworkClient networkClient) {
        if (networkClient == null) {
            return "unknown";
        }
        return String.valueOf(networkClient.authentication);
    }
}

