/*
 * Decompiled with CFR 0.152.
 */
package DarkMatter.Core;

import DarkMatter.Core.DarkMatterBombProjectile;
import DarkMatter.Core.DarkMatterHomingProjectile;
import DarkMatter.Core.DarkMatterLaserProjectile;
import DarkMatter.Core.DarkMatterNormalProjectile;
import DarkMatter.Core.DarkMatterPiercingProjectile;
import DarkMatter.Core.DarkMatterRicochetProjectile;
import DarkMatter.Core.DarkMatterStateManager;
import DarkMatter.Core.DarkMatterTreeProjectile;
import DarkMatter.DarkMatter;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import necesse.engine.localization.Localization;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.server.ServerClient;
import necesse.engine.sound.SoundSettings;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.AmmoUserMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.ItemStatTipList;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.Level;

public class DarkMatterProjectileToolItem
extends GunProjectileToolItem {
    public static LinkedHashSet<String> NORMAL_AMMO_TYPES = new LinkedHashSet<String>(Arrays.asList("DarkMatter"));
    public LinkedHashSet<String> ammoTypes;
    public int moveDist;
    public boolean controlledRange;
    public int controlledMinRange;
    public int controlledInaccuracy;
    public float ammoConsumeChance;

    public DarkMatterProjectileToolItem(String ammoStringID, int enchantCost, OneOfLootItems lootTableCategory) {
        this(new LinkedHashSet<String>(Collections.singletonList(ammoStringID)), enchantCost, lootTableCategory);
    }

    public DarkMatterProjectileToolItem(LinkedHashSet<String> ammoTypes, int enchantCost, OneOfLootItems lootTableCategory) {
        super(ammoTypes, enchantCost, lootTableCategory);
        this.attackXOffset = 2;
        this.attackYOffset = 9;
        this.attackRange.setBaseValue(750);
    }

    public DarkMatterProjectileToolItem(int enchantCost, OneOfLootItems lootTableCategory) {
        super(NORMAL_AMMO_TYPES, enchantCost, lootTableCategory);
        this.attackXOffset = 2;
        this.attackYOffset = 9;
        this.attackRange.setBaseValue(750);
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
        if (inInventory) {
            int ammoAmount = this.getAvailableAmmo((AmmoUserMob)perspective);
            if (ammoAmount > 99999) {
                ammoAmount = 99999;
            }
            String amountString = String.valueOf(ammoAmount);
            int width = FontManager.bit.getWidthCeil(amountString, tipFontOptions);
            FontManager.bit.drawString((float)(x + 28 - width), (float)(y + 16), amountString, tipFontOptions);
        }
    }

    public void addStatTooltips(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, ItemAttackerMob perspective, boolean forceAdd) {
        this.addAttackDamageTip(list, currentItem, lastItem, (Attacker)perspective, forceAdd);
        this.addAttackSpeedTip(list, currentItem, lastItem, perspective);
        this.addResilienceGainTip(list, currentItem, lastItem, (Mob)perspective, forceAdd);
        this.addCritChanceTip(list, currentItem, lastItem, (Attacker)perspective, forceAdd);
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"guntip"));
    }

    public Point getControllerAttackLevelPos(Level level, float aimDirX, float aimDirY, PlayerMob player, InventoryItem item) {
        if (this.controlledRange) {
            int range = this.getAttackRange(item);
            return new Point((int)(player.x + aimDirX * (float)range), (int)(player.y + aimDirY * (float)range));
        }
        return super.getControllerAttackLevelPos(level, aimDirX, aimDirY, player, item);
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        ServerClient serverClient;
        PlayerMob player;
        int range;
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        boolean bombMode = false;
        if (attackerMob instanceof PlayerMob && (player = (PlayerMob)attackerMob).getLevel().isServer() && (serverClient = player.getServerClient()) != null) {
            bombMode = DarkMatterStateManager.getInstance().getPlayerBombMode((NetworkClient)serverClient);
        }
        String projectileType = "normal";
        if (attackerMob instanceof PlayerMob) {
            PlayerMob player2 = (PlayerMob)attackerMob;
            if (player2.getLevel().isServer()) {
                ServerClient serverClient2 = player2.getServerClient();
                if (serverClient2 != null) {
                    projectileType = DarkMatterStateManager.getInstance().getPlayerProjectileType((NetworkClient)serverClient2);
                }
            } else {
                projectileType = DarkMatterStateManager.getInstance().getClientProjectileType();
            }
        }
        if (bombMode) {
            Projectile piercingProjectile = this.getProjectile(item, bullet, attackerMob.x + 11.0f, attackerMob.y + -7.0f, x, y, range, attackerMob);
            piercingProjectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            piercingProjectile.dropItem = dropItem;
            piercingProjectile.getUniqueID(new GameRandom((long)seed));
            attackerMob.addAndSendAttackerProjectile(piercingProjectile, this.moveDist);
            Projectile treeProjectile = this.getTreeProjectile(attackerMob.x + 11.0f, attackerMob.y + -7.0f, x, y, bullet.modVelocity((float)this.getProjectileVelocity(item, (Mob)attackerMob)), range, bullet.modDamage(this.getAttackDamage(item)), bullet.modKnockback(this.getKnockback(item, (Attacker)attackerMob)), attackerMob);
            treeProjectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            treeProjectile.dropItem = dropItem;
            treeProjectile.getUniqueID(new GameRandom((long)(seed + 1)));
            attackerMob.addAndSendAttackerProjectile(treeProjectile, this.moveDist);
        } else {
            Projectile projectile = this.getProjectile(item, bullet, attackerMob.x + 11.0f, attackerMob.y + -7.0f, x, y, range, attackerMob);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            projectile.dropItem = dropItem;
            projectile.getUniqueID(new GameRandom((long)seed));
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
        }
    }

    public Projectile getProjectile(InventoryItem item, BulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        ServerClient serverClient;
        PlayerMob player;
        float velocity = bulletItem.modVelocity((float)this.getProjectileVelocity(item, (Mob)attackerMob));
        range = bulletItem.modRange(range);
        GameDamage damage = bulletItem.modDamage(this.getAttackDamage(item));
        int knockback = bulletItem.modKnockback(this.getKnockback(item, (Attacker)attackerMob));
        if (attackerMob instanceof PlayerMob && (player = (PlayerMob)attackerMob).getLevel().isServer() && (serverClient = player.getServerClient()) != null) {
            DarkMatterStateManager stateManager = DarkMatterStateManager.getInstance();
            if (stateManager.getPlayerDamageBoost((NetworkClient)serverClient)) {
                damage = new GameDamage(damage.type, damage.damage * 1.5f, damage.armorPen, damage.baseCritChance, damage.playerDamageMultiplier, damage.finalDamageMultiplier);
            }
            if (stateManager.getPlayerSpeedBoost((NetworkClient)serverClient)) {
                velocity *= 1.3f;
            }
            if (stateManager.getPlayerRangeBoost((NetworkClient)serverClient)) {
                range = (int)((float)range * 1.4f);
            }
        }
        String projectileType = "normal";
        if (attackerMob instanceof PlayerMob) {
            PlayerMob player2 = (PlayerMob)attackerMob;
            if (player2.getLevel().isServer()) {
                ServerClient serverClient2 = player2.getServerClient();
                if (serverClient2 != null) {
                    projectileType = DarkMatterStateManager.getInstance().getPlayerProjectileType((NetworkClient)serverClient2);
                }
            } else {
                projectileType = DarkMatterStateManager.getInstance().getClientProjectileType();
            }
        }
        switch (projectileType) {
            case "bomb": {
                return this.getBombProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
            }
            case "tree": {
                return this.getTreeProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
            }
            case "piercing": {
                return this.getPiercingProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
            }
            case "homing": {
                return this.getHomingProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
            }
            case "ricochet": {
                return this.getRicochetProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
            }
            case "laser": {
                return this.getLaserProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
            }
            case "multi": {
                return this.getMultiProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
            }
        }
        return this.getNormalProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
    }

    public Projectile getNormalProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        return new DarkMatterNormalProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
    }

    public Projectile getBombProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        return new DarkMatterBombProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
    }

    public Projectile getTreeProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        return new DarkMatterTreeProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
    }

    public Projectile getPiercingProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        return new DarkMatterPiercingProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
    }

    public Projectile getHomingProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        return new DarkMatterHomingProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
    }

    public Projectile getRicochetProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        return new DarkMatterRicochetProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
    }

    public Projectile getLaserProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        return new DarkMatterLaserProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
    }

    public Projectile getMultiProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        DarkMatterNormalProjectile mainProjectile = new DarkMatterNormalProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
        float spreadAngle = 15.0f;
        DarkMatterNormalProjectile leftProjectile = new DarkMatterNormalProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
        leftProjectile.setAngle(mainProjectile.getAngle() - spreadAngle);
        DarkMatterNormalProjectile rightProjectile = new DarkMatterNormalProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
        rightProjectile.setAngle(mainProjectile.getAngle() + spreadAngle);
        attackerMob.addAndSendAttackerProjectile((Projectile)leftProjectile, this.moveDist);
        attackerMob.addAndSendAttackerProjectile((Projectile)rightProjectile, this.moveDist);
        return mainProjectile;
    }

    public String getTranslatedTypeName() {
        return Localization.translate((String)"item", (String)"gun");
    }

    protected SoundSettings getAttackSound() {
        return new SoundSettings(DarkMatter.DarkMatterRifle);
    }
}

