/*
 * Decompiled with CFR 0.152.
 */
package DarkMatter.Core;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.laserProjectile.LaserProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.InventoryItem;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class DarkMatterLaserProjectile
extends LaserProjectile {
    public DarkMatterLaserProjectile() {
    }

    public DarkMatterLaserProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
        this();
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public DarkMatterLaserProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        this();
        this.setLevel(owner.getLevel());
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public void init() {
        super.init();
        this.height = 8.5f;
        this.heightBasedOnDistance = true;
        this.setWidth(8.0f);
        this.speed = 2000.0f;
        this.piercing = 10;
        this.bouncing = 0;
        this.givesLight = true;
        this.canBreakObjects = true;
        this.isSolid = true;
        this.setDistance(750);
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(255, 100, 100), 0.3f, 150, 15.0f);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y);
            float rotationAngle = this.getAngle();
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(rotationAngle, this.texture.getWidth() / 2, 0).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
        }
    }

    public void dropItem() {
        if (GameRandom.globalRandom.getChance(0.0f)) {
            this.getLevel().entityManager.pickups.add((Entity)new InventoryItem("DarkMatter").getPickupEntity(this.getLevel(), this.x, this.y));
        }
    }

    protected void playHitSound(float x, float y) {
        SoundManager.playSound((GameSound)GameResources.laserBlast1, (SoundEffect)SoundEffect.effect((float)x, (float)y));
    }

    public void onHit(Mob mob, LevelObjectHit object, float x, float y, boolean fromPacket, ServerClient packetSubmitter) {
        super.onHit(mob, object, x, y, fromPacket, packetSubmitter);
        this.playHitSound(x, y);
        if (this.isClient()) {
            this.spawnWallHitParticles(x, y);
        }
    }

    public boolean canHit(Mob mob) {
        return true;
    }

    protected CollisionFilter getLevelCollisionFilter() {
        return null;
    }
}

