/*
 * Decompiled with CFR 0.152.
 */
package DarkMatter.Core;

import DarkMatter.DarkMatter;
import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.explosionEvent.BombExplosionEvent;
import necesse.entity.levelEvent.explosionEvent.ExplosionEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.IronBombProjectile;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.RicochetableProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventorySlot;
import necesse.inventory.PlayerInventoryManager;
import necesse.inventory.item.toolItem.ToolDamageItem;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class DarkMatterBombProjectile
extends IronBombProjectile
implements RicochetableProjectile {
    public DarkMatterBombProjectile() {
    }

    public DarkMatterBombProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        this();
        this.setLevel(owner.getLevel());
        this.applyData(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
        this.height = 8.5f;
        this.heightBasedOnDistance = true;
        this.setWidth(8.0f);
        this.speed = 120.0f;
        this.piercing = 999;
        this.setDistance(750);
        this.canBreakObjects = true;
        this.isSolid = true;
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(150, 150, 150), 0.5f, 250, 18.0f);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y);
            float rotationAngle = this.getAngle();
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(rotationAngle, this.texture.getWidth() / 2, 0).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
        }
    }

    public void dropItem() {
        if (GameRandom.globalRandom.getChance(0.0f)) {
            this.getLevel().entityManager.pickups.add((Entity)new InventoryItem("DarkMatter").getPickupEntity(this.getLevel(), this.x, this.y));
        }
    }

    protected void playHitSound(float x, float y) {
        SoundManager.playSound((GameSound)DarkMatter.DarkMatterRifle, (SoundEffect)SoundEffect.effect((float)x, (float)y));
    }

    public ExplosionEvent getExplosionEvent(float x, float y) {
        return new BombExplosionEvent(x, y, 30, this.getDamage(), true, false, 0.0f, this.getOwner());
    }

    public InventoryItem getOwnerToolSlot() {
        Mob owner = this.getOwner();
        if (owner != null && owner.isPlayer) {
            PlayerInventoryManager inv = ((PlayerMob)owner).getInv();
            InventoryItem item = inv.streamInventorySlots(false, false, false, false).map(InventorySlot::getItem).filter(i -> i != null && i.item instanceof ToolDamageItem).max((i, index) -> (int)((ToolDamageItem)i.item).getToolTier(i, owner)).get();
            return item;
        }
        return null;
    }

    public void onHit(Mob mob, LevelObjectHit object, float x, float y, boolean fromPacket, ServerClient packetSubmitter) {
        super.onHit(mob, object, x, y, fromPacket, packetSubmitter);
        this.playHitSound(x, y);
    }

    public boolean canHit(Mob mob) {
        return true;
    }

    protected CollisionFilter getLevelCollisionFilter() {
        return null;
    }
}

