/*
 * Decompiled with CFR 0.152.
 */
package autominer;

import autominer.MineralAutominerObject2;
import autominer.MineralAutominerObject3;
import autominer.MineralAutominerObject4;
import autominer.MineralAutominerObjectAbstract;
import autominer.MineralAutominerObjectEntity;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.GlobalIngredientRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.engine.sound.SoundSettings;
import necesse.engine.sound.SoundSettingsRegistry;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventoryRange;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import necesse.inventory.recipe.Tech;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.SettlementRequestOptions;
import necesse.level.maps.levelData.settlementData.SettlementWorkstationObject;
import necesse.level.maps.levelData.settlementData.storage.SettlementStorageGlobalIngredientIDIndex;
import necesse.level.maps.levelData.settlementData.storage.SettlementStorageRecords;
import necesse.level.maps.levelData.settlementData.storage.SettlementStorageRecordsRegionData;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.multiTile.MultiTile;
import necesse.level.maps.multiTile.StaticMultiTile;

public class MineralAutominerObject
extends MineralAutominerObjectAbstract
implements SettlementWorkstationObject {
    public GameTexture texture;
    protected int counterIDTopRight;
    protected int counterIDBotLeft;
    protected int counterIDBotRight;

    public Rectangle getCollision(Level level, int x, int y, int rotation) {
        if (rotation == 0) {
            return new Rectangle(x * 32 + 5, y * 32 + 12, 23, 20);
        }
        if (rotation == 1) {
            return new Rectangle(x * 32, y * 32 + 12, 23, 20);
        }
        return rotation == 2 ? new Rectangle(x * 32, y * 32, 23, 22) : new Rectangle(x * 32 + 5, y * 32, 23, 22);
    }

    @Override
    protected void setCounterIDs(int id1, int id2, int id3, int id4) {
        this.counterIDTopRight = id2;
        this.counterIDBotLeft = id3;
        this.counterIDBotRight = id4;
    }

    public MultiTile getMultiTile(int rotation) {
        return new StaticMultiTile(0, 0, 2, 2, rotation, true, new int[]{this.getID(), this.counterIDTopRight, this.counterIDBotLeft, this.counterIDBotRight});
    }

    public void loadTextures() {
        super.loadTextures();
        this.texture = GameTexture.fromFile((String)"objects/mineralautominer");
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        int originalTileX = tileX;
        int originalTileY = tileY;
        byte rotation = level.getObjectRotation(tileX, tileY);
        if (rotation == 1) {
            --tileX;
        } else if (rotation == 2) {
            --tileX;
            --tileY;
        } else if (rotation == 3) {
            --tileY;
        }
        GameLight light = level.getLightLevel(tileX, tileY);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        TextureDrawOptionsEnd options = this.texture.initDraw().addObjectDamageOverlay((GameObject)this, level, originalTileX, originalTileY).light(light).pos(drawX, drawY - (this.texture.getHeight() - 64));
        list.add(new LevelSortedDrawable(this, tileX, tileY, (DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
                super(arg0, arg1, arg2);
            }

            public int getSortY() {
                return 40;
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }

    public void drawPreview(Level level, int tileX, int tileY, int rotation, float alpha, PlayerMob player, GameCamera camera) {
        if (rotation == 1) {
            --tileX;
        } else if (rotation == 2) {
            --tileX;
            --tileY;
        } else if (rotation == 3) {
            --tileY;
        }
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        this.texture.initDraw().alpha(alpha).draw(drawX, drawY - (this.texture.getHeight() - 64));
    }

    public int getMaxCraftsAtOnce(Level level, int tileX, int tileY, Recipe recipe) {
        return 5;
    }

    public Tech[] getCraftingTechs() {
        return new Tech[]{RecipeTechRegistry.getTech((String)"mineralautominer")};
    }

    protected SoundSettings getInteractSoundOpen() {
        return SoundSettingsRegistry.defaultOpen;
    }

    public MineralAutominerObjectEntity getObjectEntity(Level level, int tileX, int tileY) {
        ObjectEntity objectEntity = level.entityManager.getObjectEntity(tileX, tileY);
        return objectEntity instanceof MineralAutominerObjectEntity ? (MineralAutominerObjectEntity)objectEntity : null;
    }

    public boolean isProcessingInventory(Level level, int tileX, int tileY) {
        return true;
    }

    public boolean canCurrentlyCraft(Level level, int tileX, int tileY, Recipe recipe) {
        MineralAutominerObjectEntity forgeObjectEntity = this.getObjectEntity(level, tileX, tileY);
        if (forgeObjectEntity == null) {
            return false;
        }
        return forgeObjectEntity.getExpectedResults().crafts < 10 && (forgeObjectEntity.isFuelRunning() || forgeObjectEntity.canUseFuel());
    }

    public SettlementRequestOptions getFuelRequestOptions(Level level, int tileX, int tileY) {
        return new SettlementRequestOptions(5, 20){

            public SettlementStorageRecordsRegionData getRequestStorageData(SettlementStorageRecords records) {
                return ((SettlementStorageGlobalIngredientIDIndex)records.getIndex(SettlementStorageGlobalIngredientIDIndex.class)).getGlobalIngredient(GlobalIngredientRegistry.getGlobalIngredientID((String)"anylog"));
            }
        };
    }

    public InventoryRange getFuelInventoryRange(Level level, int tileX, int tileY) {
        Inventory inventory;
        MineralAutominerObjectEntity forgeObjectEntity = this.getObjectEntity(level, tileX, tileY);
        if (forgeObjectEntity != null && (inventory = forgeObjectEntity.getInventory()) != null && forgeObjectEntity.fuelSlots > 0) {
            return new InventoryRange(inventory, 0, forgeObjectEntity.fuelSlots - 1);
        }
        return null;
    }

    public Stream<Recipe> streamSettlementRecipes(Level level, int i, int i1) {
        return Recipes.streamRecipes((Tech[])this.getCraftingTechs());
    }

    public InventoryRange getProcessingInputRange(Level level, int tileX, int tileY) {
        MineralAutominerObjectEntity forgeObjectEntity = this.getObjectEntity(level, tileX, tileY);
        return forgeObjectEntity != null ? forgeObjectEntity.getInputInventoryRange() : null;
    }

    public InventoryRange getProcessingOutputRange(Level level, int tileX, int tileY) {
        MineralAutominerObjectEntity forgeObjectEntity = this.getObjectEntity(level, tileX, tileY);
        return forgeObjectEntity != null ? forgeObjectEntity.getOutputInventoryRange() : null;
    }

    public ArrayList<InventoryItem> getCurrentAndFutureProcessingOutputs(Level level, int tileX, int tileY) {
        MineralAutominerObjectEntity forgeObjectEntity = this.getObjectEntity(level, tileX, tileY);
        return forgeObjectEntity != null ? forgeObjectEntity.getCurrentAndExpectedResults().items : new ArrayList<InventoryItem>();
    }

    public static void registerMineralAutominer() {
        MineralAutominerObject o1 = new MineralAutominerObject();
        int id1 = ObjectRegistry.registerObject((String)"mineralautominer", (GameObject)o1, (float)20.0f, (boolean)true);
        MineralAutominerObject2 o2 = new MineralAutominerObject2();
        int id2 = ObjectRegistry.registerObject((String)"mineralautominer2", (GameObject)o2, (float)0.0f, (boolean)false);
        MineralAutominerObject3 o3 = new MineralAutominerObject3();
        int id3 = ObjectRegistry.registerObject((String)"mineralautominer3", (GameObject)o3, (float)0.0f, (boolean)false);
        MineralAutominerObject4 o4 = new MineralAutominerObject4();
        int id4 = ObjectRegistry.registerObject((String)"mineralautominer4", (GameObject)o4, (float)0.0f, (boolean)false);
        o1.setCounterIDs(id1, id2, id3, id4);
        o2.setCounterIDs(id1, id2, id3, id4);
        o3.setCounterIDs(id1, id2, id3, id4);
        o4.setCounterIDs(id1, id2, id3, id4);
    }
}

