/*
 * Decompiled with CFR 0.152.
 */
package modmenu.server.playerdata;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import modmenu.server.playerdata.PlayerData;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.PlayerMob;

public final class PlayerDataManger {
    private final ConcurrentMap<Integer, PlayerData> dataBySlot = new ConcurrentHashMap<Integer, PlayerData>();

    public PlayerData get(PlayerMob playerMob) {
        return playerMob == null ? null : this.get(playerMob.getServerClient());
    }

    public PlayerData get(ServerClient client) {
        return client == null ? null : (PlayerData)this.dataBySlot.get(client.slot);
    }

    public PlayerData getOrCreate(ServerClient client) {
        if (client == null) {
            return null;
        }
        return this.dataBySlot.computeIfAbsent(client.slot, key -> new PlayerData());
    }

    public void destroy(ServerClient client) {
        if (client == null) {
            return;
        }
        this.dataBySlot.remove(client.slot);
    }

    public void destroy(PlayerMob playerMob) {
        if (playerMob == null) {
            return;
        }
        this.destroy(playerMob.getServerClient());
    }

    public void reset(ServerClient client) {
        PlayerData data = this.get(client);
        if (data != null) {
            data.reset();
        }
    }
}

