/*
 * Decompiled with CFR 0.152.
 */
package modmenu.server;

import java.util.Arrays;
import java.util.function.Consumer;
import modmenu.common.CheatSettingType;
import modmenu.common.CheatSettings;
import necesse.engine.modifiers.Modifier;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;

public final class CheatEffectApplier {
    private static final int LONG_DURATION = 999999999;
    private static final String BUFF_GOD = "godmodebuff";
    private static final String BUFF_UNLIMITED_SUMMONS = "unlimitedsummonsbuff";
    private static final String BUFF_SUPER_SUMMONS = "supersummonsbuff";
    private static final String BUFF_INVISIBLE = "insiviblebuff";
    private static final String BUFF_INFINITE_AMMO = "infammobuff";
    private static final String BUFF_STAMINA = "staminabuff";
    private static final String BUFF_LIGHT = "lightbuff";
    private static final String BUFF_WATER_WALK = "waterwalkingbuff";
    private static final String BUFF_SUPER_BUILD = "superbuildbuff";
    private static final String BUFF_WORLD_MAP = "worldbuff";
    private static final String BUFF_MOB_SPAWN = "manymobsbuff";
    private static final String BUFF_CRIT = "alwayscritbuff";
    private static final String BUFF_ATTACK_SPEED = "atsbuff";
    private static final String BUFF_DAMAGE = "dmgmultbuff";
    private static final String BUFF_MAX_HEALTH = "maxhealthbuff";
    private static final String BUFF_SUPER_MINING = "superminingbuff";
    private static final String BUFF_PICKUP = "superpickupbuff";
    private static final String BUFF_SPEED = "speedbuff";
    private static final String BUFF_HP_REGEN = "regenbuff";
    private static final String[] ALL_BUFF_IDS = new String[]{"godmodebuff", "unlimitedsummonsbuff", "supersummonsbuff", "insiviblebuff", "infammobuff", "staminabuff", "lightbuff", "waterwalkingbuff", "superbuildbuff", "worldbuff", "manymobsbuff", "alwayscritbuff", "atsbuff", "dmgmultbuff", "maxhealthbuff", "superminingbuff", "superpickupbuff", "speedbuff", "regenbuff"};

    private CheatEffectApplier() {
    }

    public static void applyAll(ServerClient client, CheatSettings settings) {
        if (client == null) {
            return;
        }
        settings.forEach((type, value) -> CheatEffectApplier.applySetting(client, type, value));
    }

    public static void applySetting(ServerClient client, CheatSettingType type, int rawValue) {
        PlayerMob mob = CheatEffectApplier.getMob(client);
        if (mob == null) {
            return;
        }
        int value = type.clamp(rawValue);
        switch (type) {
            case MOB_SPAWN_RATE: {
                CheatEffectApplier.updateMobSpawn(mob, value);
                break;
            }
            case CRIT_CHANCE: {
                CheatEffectApplier.updateSingleModifier(mob, BUFF_CRIT, (Modifier<Float>)BuffModifiers.CRIT_CHANCE, value);
                break;
            }
            case ATTACK_SPEED: {
                CheatEffectApplier.updateSingleModifier(mob, BUFF_ATTACK_SPEED, (Modifier<Float>)BuffModifiers.ATTACK_SPEED, value);
                break;
            }
            case DAMAGE_MULTIPLIER: {
                CheatEffectApplier.updateSingleModifier(mob, BUFF_DAMAGE, (Modifier<Float>)BuffModifiers.ALL_DAMAGE, value);
                break;
            }
            case MAX_HEALTH: {
                CheatEffectApplier.log("Applying MAX_HEALTH slider value " + value);
                CheatEffectApplier.updateMaxHealth(mob, value);
                break;
            }
            case MINING_SPEED: {
                CheatEffectApplier.updateMining(mob, value);
                break;
            }
            case PICKUP_RANGE: {
                CheatEffectApplier.updateSingleModifier(mob, BUFF_PICKUP, (Modifier<Float>)BuffModifiers.ITEM_PICKUP_RANGE, value);
                break;
            }
            case SUMMON_POWER: {
                CheatEffectApplier.updateSummons(mob, value);
                break;
            }
            case MOVE_SPEED: {
                CheatEffectApplier.updateMoveSpeed(mob, value);
                break;
            }
            case GOD_MODE: {
                CheatEffectApplier.toggleBuff(mob, BUFF_GOD, value);
                break;
            }
            case UNLIMITED_SUMMONS: {
                CheatEffectApplier.toggleBuff(mob, BUFF_UNLIMITED_SUMMONS, value);
                break;
            }
            case INVISIBLE: {
                CheatEffectApplier.toggleBuff(mob, BUFF_INVISIBLE, value);
                break;
            }
            case INFINITE_AMMO: {
                CheatEffectApplier.toggleBuff(mob, BUFF_INFINITE_AMMO, value);
                break;
            }
            case STAMINA: {
                CheatEffectApplier.toggleBuff(mob, BUFF_STAMINA, value);
                break;
            }
            case LIGHT: {
                CheatEffectApplier.toggleBuff(mob, BUFF_LIGHT, value);
                break;
            }
            case WATER_WALKING: {
                CheatEffectApplier.toggleBuff(mob, BUFF_WATER_WALK, value);
                break;
            }
            case SUPER_BUILD: {
                CheatEffectApplier.toggleBuff(mob, BUFF_SUPER_BUILD, value);
                break;
            }
            case WORLD_MAP: {
                CheatEffectApplier.toggleBuff(mob, BUFF_WORLD_MAP, value);
                break;
            }
            case NEVER_HUNGRY: {
                CheatEffectApplier.updateNeverHungry(mob, value);
            }
        }
    }

    public static void removeAll(ServerClient client) {
        PlayerMob mob = CheatEffectApplier.getMob(client);
        if (mob == null) {
            return;
        }
        Arrays.stream(ALL_BUFF_IDS).forEach(id -> CheatEffectApplier.removeBuff(mob, id));
    }

    public static void heal(ServerClient client, int duration, float regenAmount) {
        PlayerMob mob = CheatEffectApplier.getMob(client);
        if (mob == null) {
            return;
        }
        Buff buff = BuffRegistry.getBuff((String)BUFF_HP_REGEN);
        ActiveBuff active = new ActiveBuff(buff, (Mob)mob, duration, null);
        active.setModifier(BuffModifiers.HEALTH_REGEN, (Object)Float.valueOf(regenAmount));
        active.setModifier(BuffModifiers.COMBAT_HEALTH_REGEN, (Object)Float.valueOf(regenAmount));
        mob.buffManager.addBuff(active, true, false);
        CheatEffectApplier.markDirty(active);
        CheatEffectApplier.fillHunger(mob);
    }

    private static void updateMobSpawn(PlayerMob mob, int value) {
        if (value <= 0) {
            CheatEffectApplier.removeBuff(mob, BUFF_MOB_SPAWN);
            return;
        }
        CheatEffectApplier.applyBuff(mob, BUFF_MOB_SPAWN, true, buff -> {
            float floatValue = value;
            buff.setModifier(BuffModifiers.MOB_SPAWN_RATE, (Object)Float.valueOf(floatValue));
            buff.setModifier(BuffModifiers.MOB_SPAWN_CAP, (Object)Float.valueOf(floatValue));
        });
    }

    private static void updateSummons(PlayerMob mob, int value) {
        if (value <= 0) {
            CheatEffectApplier.removeBuff(mob, BUFF_SUPER_SUMMONS);
            return;
        }
        CheatEffectApplier.applyBuff(mob, BUFF_SUPER_SUMMONS, true, buff -> {
            float floatValue = value;
            buff.setModifier(BuffModifiers.SUMMONS_SPEED, (Object)Float.valueOf(floatValue));
            buff.setModifier(BuffModifiers.SUMMON_ATTACK_SPEED, (Object)Float.valueOf(floatValue));
        });
    }

    private static void updateMining(PlayerMob mob, int value) {
        if (value <= 0) {
            CheatEffectApplier.removeBuff(mob, BUFF_SUPER_MINING);
            return;
        }
        CheatEffectApplier.applyBuff(mob, BUFF_SUPER_MINING, true, buff -> {
            float floatValue = value;
            buff.setModifier(BuffModifiers.MINING_SPEED, (Object)Float.valueOf(floatValue));
            buff.setModifier(BuffModifiers.MINING_RANGE, (Object)Float.valueOf(floatValue));
        });
    }

    private static void updateMoveSpeed(PlayerMob mob, int value) {
        if (value <= 0) {
            CheatEffectApplier.removeBuff(mob, BUFF_SPEED);
            return;
        }
        CheatEffectApplier.applyBuff(mob, BUFF_SPEED, true, buff -> {
            float floatValue = (float)value * 10.0f;
            buff.setModifier(BuffModifiers.SPEED_FLAT, (Object)Float.valueOf(floatValue));
        });
    }

    private static void updateMaxHealth(PlayerMob mob, int value) {
        if (value <= 0) {
            CheatEffectApplier.log("MAX_HEALTH <= 0, removing buff");
            CheatEffectApplier.removeBuff(mob, BUFF_MAX_HEALTH);
            return;
        }
        CheatEffectApplier.log("Updating MAX_HEALTH to " + value + " (before=" + mob.getMaxHealth() + ")");
        CheatEffectApplier.applyBuff(mob, BUFF_MAX_HEALTH, true, buff -> buff.setModifier(BuffModifiers.MAX_HEALTH, (Object)Float.valueOf(value)));
        CheatEffectApplier.log("MAX_HEALTH applied (after=" + mob.getMaxHealth() + ")");
    }

    private static void updateSingleModifier(PlayerMob mob, String buffId, Modifier<Float> modifier, int value) {
        if (value <= 0) {
            CheatEffectApplier.removeBuff(mob, buffId);
            return;
        }
        CheatEffectApplier.applyBuff(mob, buffId, true, buff -> buff.setModifier(modifier, (Object)Float.valueOf(value)));
    }

    private static void toggleBuff(PlayerMob mob, String buffId, int state) {
        if (state <= 0) {
            CheatEffectApplier.removeBuff(mob, buffId);
        } else {
            CheatEffectApplier.applyBuff(mob, buffId, false, buff -> {});
        }
    }

    private static void applyBuff(PlayerMob mob, String buffId, boolean recreate, Consumer<ActiveBuff> consumer) {
        Buff buff = BuffRegistry.getBuff((String)buffId);
        BuffManager manager = mob.buffManager;
        ActiveBuff active = manager.getBuff(buff);
        if (recreate && active != null) {
            if (BUFF_MAX_HEALTH.equals(buffId)) {
                CheatEffectApplier.log("Recreating existing MAX_HEALTH buff");
            }
            manager.removeBuff(buff, true);
            active = null;
        }
        if (active == null) {
            active = new ActiveBuff(buff, (Mob)mob, 999999999, null);
            manager.addBuff(active, true, false);
            if (BUFF_MAX_HEALTH.equals(buffId)) {
                CheatEffectApplier.log("Created new MAX_HEALTH buff instance");
            }
        }
        consumer.accept(active);
        CheatEffectApplier.markDirty(active);
    }

    private static void removeBuff(PlayerMob mob, String buffId) {
        Buff buff = BuffRegistry.getBuff((String)buffId);
        mob.buffManager.removeBuff(buff, true);
    }

    private static void markDirty(ActiveBuff activeBuff) {
        if (activeBuff == null) {
            return;
        }
        activeBuff.forceManagerUpdate();
        if (activeBuff.owner != null && activeBuff.owner.buffManager != null) {
            activeBuff.owner.buffManager.forceUpdateBuffs();
        }
        if (BUFF_MAX_HEALTH.equals(activeBuff.buff.getStringID())) {
            CheatEffectApplier.log("Sent update packet for MAX_HEALTH buff (value=" + String.valueOf(activeBuff.getModifier(BuffModifiers.MAX_HEALTH)) + ")");
        }
        BuffManager.sendUpdatePacket((ActiveBuff)activeBuff, (boolean)true);
    }

    private static PlayerMob getMob(ServerClient client) {
        return client == null ? null : client.playerMob;
    }

    private static void log(String message) {
        System.out.println("[CheatBuffs] " + message);
    }

    private static void fillHunger(PlayerMob mob) {
        if (mob == null) {
            return;
        }
        mob.hungerLevel = 1.0f;
        mob.sendHungerPacket();
    }

    private static void updateNeverHungry(PlayerMob mob, int state) {
        if (state > 0) {
            CheatEffectApplier.fillHunger(mob);
        }
    }
}

