/*
 * Decompiled with CFR 0.152.
 */
package modmenu.common;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import modmenu.common.CheatSettingType;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;

public final class CheatSettings {
    private final EnumMap<CheatSettingType, Integer> values = new EnumMap(CheatSettingType.class);

    public CheatSettings() {
        this.reset();
    }

    public CheatSettings(CheatSettings other) {
        this();
        this.copyFrom(other);
    }

    public void reset() {
        for (CheatSettingType type : CheatSettingType.values()) {
            this.values.put(type, type.getDefaultValue());
        }
    }

    public void copyFrom(CheatSettings other) {
        for (CheatSettingType type : CheatSettingType.values()) {
            this.values.put(type, other.getRaw(type));
        }
    }

    public int getRaw(CheatSettingType type) {
        return this.values.get((Object)type);
    }

    public int getInt(CheatSettingType type) {
        CheatSettings.ensureInteger(type);
        return this.values.get((Object)type);
    }

    public boolean getBoolean(CheatSettingType type) {
        CheatSettings.ensureBoolean(type);
        return type.asBoolean(this.values.get((Object)type));
    }

    public void set(CheatSettingType type, int value) {
        this.values.put(type, type.clamp(value));
    }

    public void setBoolean(CheatSettingType type, boolean enabled) {
        CheatSettings.ensureBoolean(type);
        this.values.put(type, type.fromBoolean(enabled));
    }

    public void write(PacketWriter writer) {
        for (CheatSettingType type : CheatSettingType.values()) {
            writer.putNextInt(this.values.get((Object)type).intValue());
        }
    }

    public static CheatSettings read(PacketReader reader) {
        CheatSettings settings = new CheatSettings();
        for (CheatSettingType type : CheatSettingType.values()) {
            settings.values.put(type, type.clamp(reader.getNextInt()));
        }
        return settings;
    }

    public void forEach(BiConsumer<CheatSettingType, Integer> consumer) {
        for (Map.Entry<CheatSettingType, Integer> entry : this.values.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    private static void ensureBoolean(CheatSettingType type) {
        if (!type.getValueType().isBoolean()) {
            throw new IllegalArgumentException(type.name() + " is not a boolean");
        }
    }

    private static void ensureInteger(CheatSettingType type) {
        if (!type.getValueType().isInteger()) {
            throw new IllegalArgumentException(type.name() + " is not numeric");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheatSettings that = (CheatSettings)o;
        return this.values.equals((Object)that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "CheatSettings" + String.valueOf(this.values);
    }
}

