/*
 * Decompiled with CFR 0.152.
 */
package modmenu.common;

import modmenu.common.CheatValueType;

public enum CheatSettingType {
    MOB_SPAWN_RATE(CheatValueType.INTEGER, 0, 100, 0),
    CRIT_CHANCE(CheatValueType.INTEGER, 0, 100, 0),
    ATTACK_SPEED(CheatValueType.INTEGER, 0, 100, 0),
    DAMAGE_MULTIPLIER(CheatValueType.INTEGER, 0, 100, 0),
    MAX_HEALTH(CheatValueType.INTEGER, 0, 100, 0),
    MINING_SPEED(CheatValueType.INTEGER, 0, 100, 0),
    PICKUP_RANGE(CheatValueType.INTEGER, 0, 100, 0),
    SUMMON_POWER(CheatValueType.INTEGER, 0, 100, 0),
    MOVE_SPEED(CheatValueType.INTEGER, 0, 100, 0),
    GOD_MODE(CheatValueType.BOOLEAN, 0, 1, 0),
    UNLIMITED_SUMMONS(CheatValueType.BOOLEAN, 0, 1, 0),
    INVISIBLE(CheatValueType.BOOLEAN, 0, 1, 0),
    INFINITE_AMMO(CheatValueType.BOOLEAN, 0, 1, 0),
    STAMINA(CheatValueType.BOOLEAN, 0, 1, 0),
    LIGHT(CheatValueType.BOOLEAN, 0, 1, 0),
    WATER_WALKING(CheatValueType.BOOLEAN, 0, 1, 0),
    SUPER_BUILD(CheatValueType.BOOLEAN, 0, 1, 0),
    WORLD_MAP(CheatValueType.BOOLEAN, 0, 1, 0),
    NEVER_HUNGRY(CheatValueType.BOOLEAN, 0, 1, 0);

    private final CheatValueType valueType;
    private final int minValue;
    private final int maxValue;
    private final int defaultValue;

    private CheatSettingType(CheatValueType valueType, int minValue, int maxValue, int defaultValue) {
        this.valueType = valueType;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
    }

    public CheatValueType getValueType() {
        return this.valueType;
    }

    public boolean isToggle() {
        return this.valueType.isBoolean();
    }

    public boolean isSlider() {
        return this.valueType.isInteger();
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int clamp(int value) {
        if (value < this.minValue) {
            return this.minValue;
        }
        return Math.min(value, this.maxValue);
    }

    public boolean asBoolean(int value) {
        if (!this.valueType.isBoolean()) {
            throw new IllegalStateException(this.name() + " is not a toggle");
        }
        return this.clamp(value) == 1;
    }

    public int fromBoolean(boolean enabled) {
        if (!this.valueType.isBoolean()) {
            throw new IllegalStateException(this.name() + " is not a toggle");
        }
        return enabled ? 1 : 0;
    }
}

