/*
 * Decompiled with CFR 0.152.
 */
package modmenu.client.menu;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import modmenu.CheatBuffs;
import modmenu.client.menu.CurrentMenu;
import modmenu.common.CheatActionType;
import modmenu.common.CheatSettingType;
import modmenu.common.CheatSettings;
import modmenu.network.packet.PacketCheatAction;
import modmenu.network.packet.PacketCheatSettingUpdate;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.InputEvent;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.FormManager;
import necesse.gfx.forms.components.FormCheckBox;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormSlider;
import necesse.gfx.forms.components.FormTextButton;
import necesse.gfx.gameFont.FontOptions;

public class BuffMenu
extends Form {
    private final FormManager formManager;
    private final Client client;
    public boolean shown;
    public CurrentMenu currentMenu = CurrentMenu.Main;
    private final EnumMap<CheatSettingType, FormSlider> sliderComponents = new EnumMap(CheatSettingType.class);
    private final EnumMap<CheatSettingType, FormCheckBox> toggleComponents = new EnumMap(CheatSettingType.class);
    private final Consumer<CheatSettings> stashListener = this::applySettingsToControls;
    private boolean updatingControls;

    public BuffMenu(FormManager formManager, Client client) {
        super("Cheats", 500, 360);
        this.setPosition(700, 150);
        this.formManager = formManager;
        this.client = client;
        CheatBuffs.instance.clientSideStash.addListener(this.stashListener);
    }

    public void dispose() {
        CheatBuffs.instance.clientSideStash.removeListener(this.stashListener);
        super.dispose();
    }

    public void handleInputEvent(InputEvent event, TickManager tickManager, PlayerMob perspective) {
        super.handleInputEvent(event, tickManager, perspective);
        if (event.isKeyboardEvent() && event.getID() == 256) {
            this.shown = false;
            this.formManager.removeComponent((FormComponent)this);
        }
    }

    public void initMenu() {
        this.clearComponents();
        PermissionLevel level = this.client.getPermissionLevel();
        if (level == PermissionLevel.ADMIN || level == PermissionLevel.OWNER) {
            this.currentMenu = CurrentMenu.CheatBuffs;
            this.initPlayerMenu();
        }
    }

    private void initPlayerMenu() {
        this.sliderComponents.clear();
        this.toggleComponents.clear();
        this.addSlider("Mob Spawnrate", CheatSettingType.MOB_SPAWN_RATE, 250, 10);
        this.addSlider("Crit Chance", CheatSettingType.CRIT_CHANCE, 250, 40);
        this.addSlider("Attack Speed", CheatSettingType.ATTACK_SPEED, 250, 70);
        this.addSlider("Damage Multiplier", CheatSettingType.DAMAGE_MULTIPLIER, 250, 100);
        this.addSlider("Max Health", CheatSettingType.MAX_HEALTH, 250, 130);
        this.addSlider("Mining Buff", CheatSettingType.MINING_SPEED, 250, 160);
        this.addSlider("Pickup Range", CheatSettingType.PICKUP_RANGE, 250, 190);
        this.addSlider("Super Summons", CheatSettingType.SUMMON_POWER, 250, 220);
        this.addSlider("Speed Bonus", CheatSettingType.MOVE_SPEED, 250, 250);
        this.addToggle("(Nearly) Godmode", CheatSettingType.GOD_MODE, 5, 10);
        this.addToggle("Unlimited Stamina", CheatSettingType.STAMINA, 5, 40);
        this.addToggle("Afraid in the dark", CheatSettingType.LIGHT, 5, 70);
        this.addToggle("Infinite Ammo", CheatSettingType.INFINITE_AMMO, 5, 100);
        this.addToggle("Unlimited Summons", CheatSettingType.UNLIMITED_SUMMONS, 5, 130);
        this.addToggle("Invisible", CheatSettingType.INVISIBLE, 5, 160);
        this.addToggle("Water Walking", CheatSettingType.WATER_WALKING, 5, 190);
        this.addToggle("Super Build", CheatSettingType.SUPER_BUILD, 5, 220);
        this.addToggle("Worldmap High Range", CheatSettingType.WORLD_MAP, 5, 250);
        this.addToggle("Never Hungry", CheatSettingType.NEVER_HUNGRY, 5, 280);
        FormTextButton healButton = new FormTextButton("Heal", "Heal yourself", 5, 300, 80);
        healButton.onClicked(e -> this.sendAction(CheatActionType.HEAL_SELF));
        this.addComponent((FormComponent)healButton);
        FormTextButton resetButton = new FormTextButton("Reset", "Disable all cheats", 95, 300, 80);
        resetButton.onClicked(e -> this.sendAction(CheatActionType.RESET_ALL));
        this.addComponent((FormComponent)resetButton);
        FormTextButton achievementsButton = new FormTextButton("Give achievements", "Unlock all achievements", 185, 300, 200);
        achievementsButton.onClicked(e -> this.sendAction(CheatActionType.GIVE_ALL_ACHIEVEMENTS));
        this.addComponent((FormComponent)achievementsButton);
        this.applySettingsToControls(CheatBuffs.instance.clientSideStash.snapshot());
    }

    private void applySettingsToControls(CheatSettings settings) {
        CheatSettingType type;
        if (settings == null) {
            settings = new CheatSettings();
        }
        this.updatingControls = true;
        for (Map.Entry<CheatSettingType, FormSlider> entry : this.sliderComponents.entrySet()) {
            type = entry.getKey();
            entry.getValue().setValue(settings.getInt(type));
        }
        for (Map.Entry<CheatSettingType, FormSlider> entry : this.toggleComponents.entrySet()) {
            type = entry.getKey();
            ((FormCheckBox)entry.getValue()).checked = settings.getBoolean(type);
        }
        this.updatingControls = false;
    }

    private void sendSettingUpdate(CheatSettingType type, int value) {
        if (this.updatingControls) {
            return;
        }
        if (this.client == null || this.client.network == null) {
            return;
        }
        this.client.network.sendPacket((Packet)new PacketCheatSettingUpdate(type, value));
    }

    private void sendAction(CheatActionType action) {
        if (this.client == null || this.client.network == null) {
            return;
        }
        this.client.network.sendPacket((Packet)new PacketCheatAction(action));
    }

    private void addSlider(String label, CheatSettingType type, int x, int y) {
        FormSlider slider = new FormSlider(label, x, y, type.getDefaultValue(), type.getMinValue(), type.getMaxValue(), 200, new FontOptions(10));
        slider.onChanged(e -> this.sendSettingUpdate(type, slider.getValue()));
        this.sliderComponents.put(type, slider);
        this.addComponent((FormComponent)slider);
    }

    private void addToggle(String label, CheatSettingType type, int x, int y) {
        FormCheckBox checkBox = new FormCheckBox(label, x, y);
        checkBox.onClicked(e -> this.sendSettingUpdate(type, ((FormCheckBox)e.from).checked ? 1 : 0));
        this.toggleComponents.put(type, checkBox);
        this.addComponent((FormComponent)checkBox);
    }
}

