/*
 * Decompiled with CFR 0.152.
 */
package modmenu.client;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import modmenu.common.CheatSettingType;
import modmenu.common.CheatSettings;

public final class ClientSideStash {
    private final CheatSettings settings = new CheatSettings();
    private final List<Consumer<CheatSettings>> listeners = new CopyOnWriteArrayList<Consumer<CheatSettings>>();

    public CheatSettings snapshot() {
        return new CheatSettings(this.settings);
    }

    public int getInt(CheatSettingType type) {
        return this.settings.getInt(type);
    }

    public boolean getBoolean(CheatSettingType type) {
        return this.settings.getBoolean(type);
    }

    public void applyServerSettings(CheatSettings serverSettings) {
        if (serverSettings == null) {
            this.settings.reset();
        } else {
            this.settings.copyFrom(serverSettings);
        }
        this.notifyListeners();
    }

    public void resetAll() {
        this.settings.reset();
        this.notifyListeners();
    }

    public void addListener(Consumer<CheatSettings> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(Consumer<CheatSettings> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        CheatSettings copy = this.snapshot();
        for (Consumer<CheatSettings> listener : this.listeners) {
            listener.accept(copy);
        }
    }
}

