/*
 * Decompiled with CFR 0.152.
 */
package modmenu;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import modmenu.client.ClientSideStash;
import modmenu.client.buffs.AlwaysCritBuff;
import modmenu.client.buffs.AttackSpeedBuff;
import modmenu.client.buffs.DamageMultiplierBuff;
import modmenu.client.buffs.GodBuff;
import modmenu.client.buffs.HPRegenBuff;
import modmenu.client.buffs.InfinityAmmoBuff;
import modmenu.client.buffs.InsivibleBuff;
import modmenu.client.buffs.LightBuff;
import modmenu.client.buffs.ManyMobsBuff;
import modmenu.client.buffs.MaxHealthBuff;
import modmenu.client.buffs.SpeedBuff;
import modmenu.client.buffs.StaminaBuff;
import modmenu.client.buffs.SuperBuildBuff;
import modmenu.client.buffs.SuperMiningBuff;
import modmenu.client.buffs.SuperPickupBuff;
import modmenu.client.buffs.SuperSummonsBuff;
import modmenu.client.buffs.UnlimitedSummonsBuff;
import modmenu.client.buffs.WaterWalkingBuff;
import modmenu.client.buffs.WorldMap;
import modmenu.client.listener.ServerClientConnectListener;
import modmenu.client.listener.ServerClientDisconnectListener;
import modmenu.common.CheatActionType;
import modmenu.common.CheatSettingType;
import modmenu.common.CheatSettings;
import modmenu.network.packet.PacketCheatAction;
import modmenu.network.packet.PacketCheatSettingUpdate;
import modmenu.network.packet.PacketCheatSettingsSync;
import modmenu.server.CheatEffectApplier;
import modmenu.server.playerdata.PlayerData;
import modmenu.server.playerdata.PlayerDataManger;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEvents;
import necesse.engine.achievements.Achievement;
import necesse.engine.achievements.AchievementManager;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.events.ServerClientConnectedEvent;
import necesse.engine.events.ServerClientDisconnectEvent;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketAchievementUpdate;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.PacketRegistry;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.staticBuffs.Buff;

@ModEntry
public class CheatBuffs {
    private static final StaticMessage MSG_NEED_PERMISSION = new StaticMessage("Cheat menu requires admin or owner permissions.");
    private static final StaticMessage MSG_CLEAR_WORLD = new StaticMessage("World cheats flag cleared.");
    private static final StaticMessage MSG_ACHIEVEMENTS_UNLOCKED = new StaticMessage("All achievements unlocked.");
    private static final int HEAL_DURATION = 1000;
    private static final float HEAL_REGEN = 1.0E7f;
    public static CheatBuffs instance;
    public PlayerDataManger playerDataManger;
    public final ClientSideStash clientSideStash = new ClientSideStash();

    public void init() {
        instance = this;
        this.playerDataManger = new PlayerDataManger();
        PacketRegistry.registerPacket(PacketCheatSettingsSync.class);
        PacketRegistry.registerPacket(PacketCheatSettingUpdate.class);
        PacketRegistry.registerPacket(PacketCheatAction.class);
        GameEvents.addListener(ServerClientDisconnectEvent.class, (GameEventInterface)new ServerClientDisconnectListener());
        GameEvents.addListener(ServerClientConnectedEvent.class, (GameEventInterface)new ServerClientConnectListener());
        BuffRegistry.registerBuff((String)"unlimitedsummonsbuff", (Buff)new UnlimitedSummonsBuff());
        BuffRegistry.registerBuff((String)"dmgmultbuff", (Buff)new DamageMultiplierBuff());
        BuffRegistry.registerBuff((String)"atsbuff", (Buff)new AttackSpeedBuff());
        BuffRegistry.registerBuff((String)"insiviblebuff", (Buff)new InsivibleBuff());
        BuffRegistry.registerBuff((String)"manymobsbuff", (Buff)new ManyMobsBuff());
        BuffRegistry.registerBuff((String)"superminingbuff", (Buff)new SuperMiningBuff());
        BuffRegistry.registerBuff((String)"superpickupbuff", (Buff)new SuperPickupBuff());
        BuffRegistry.registerBuff((String)"supersummonsbuff", (Buff)new SuperSummonsBuff());
        BuffRegistry.registerBuff((String)"maxhealthbuff", (Buff)new MaxHealthBuff());
        BuffRegistry.registerBuff((String)"infammobuff", (Buff)new InfinityAmmoBuff());
        BuffRegistry.registerBuff((String)"regenbuff", (Buff)new HPRegenBuff());
        BuffRegistry.registerBuff((String)"staminabuff", (Buff)new StaminaBuff());
        BuffRegistry.registerBuff((String)"lightbuff", (Buff)new LightBuff());
        BuffRegistry.registerBuff((String)"waterwalkingbuff", (Buff)new WaterWalkingBuff());
        BuffRegistry.registerBuff((String)"superbuildbuff", (Buff)new SuperBuildBuff());
        BuffRegistry.registerBuff((String)"alwayscritbuff", (Buff)new AlwaysCritBuff());
        BuffRegistry.registerBuff((String)"godmodebuff", (Buff)new GodBuff());
        BuffRegistry.registerBuff((String)"worldbuff", (Buff)new WorldMap());
        BuffRegistry.registerBuff((String)"speedbuff", (Buff)new SpeedBuff());
    }

    public void initResources() {
    }

    public void postInit() {
    }

    public void handleSettingUpdate(Server server, ServerClient client, CheatSettingType type, int value) {
        if (!this.ensureCheatPermissions(server, client)) {
            return;
        }
        PlayerData data = this.playerDataManger.getOrCreate(client);
        if (data == null) {
            return;
        }
        data.getSettings().set(type, value);
        CheatEffectApplier.applySetting(client, type, value);
        this.sendSettingsTo(client, data.getSettings());
    }

    public void handleAction(Server server, ServerClient client, CheatActionType action) {
        if (!this.ensureCheatPermissions(server, client)) {
            return;
        }
        PlayerData data = this.playerDataManger.getOrCreate(client);
        if (data == null) {
            return;
        }
        switch (action) {
            case HEAL_SELF: {
                CheatEffectApplier.heal(client, 1000, 1.0E7f);
                break;
            }
            case RESET_ALL: {
                data.reset();
                CheatEffectApplier.removeAll(client);
                this.sendSettingsTo(client, data.getSettings());
                break;
            }
            case CLEAR_WORLD_CHEATS: {
                this.clearWorldCheats(server, client);
                break;
            }
            case GIVE_ALL_ACHIEVEMENTS: {
                this.grantAllAchievements(client);
            }
        }
    }

    public void onClientConnected(ServerClient client) {
        PlayerData data = this.playerDataManger.getOrCreate(client);
        if (data != null) {
            CheatEffectApplier.removeAll(client);
            CheatEffectApplier.applyAll(client, data.getSettings());
            this.sendSettingsTo(client, data.getSettings());
        }
    }

    public void onClientDisconnected(ServerClient client) {
        CheatEffectApplier.removeAll(client);
        this.playerDataManger.destroy(client);
    }

    public void onPlayerDeath(PlayerMob playerMob) {
        ServerClient client;
        ServerClient serverClient = client = playerMob == null ? null : playerMob.getServerClient();
        if (client == null) {
            return;
        }
        PlayerData data = this.playerDataManger.getOrCreate(client);
        if (data == null) {
            return;
        }
        data.reset();
        CheatEffectApplier.removeAll(client);
        this.sendSettingsTo(client, data.getSettings());
    }

    private boolean ensureCheatPermissions(Server server, ServerClient client) {
        if (client == null) {
            return false;
        }
        PermissionLevel level = client.getPermissionLevel();
        if (level == null || level.getLevel() < PermissionLevel.ADMIN.getLevel()) {
            client.sendChatMessage((GameMessage)MSG_NEED_PERMISSION);
            return false;
        }
        return true;
    }

    private void sendSettingsTo(ServerClient client, CheatSettings settings) {
        if (client == null || settings == null) {
            return;
        }
        client.sendPacket((Packet)new PacketCheatSettingsSync(settings));
    }

    private void clearWorldCheats(Server server, ServerClient requester) {
        if (server == null || server.world == null || server.world.settings == null) {
            return;
        }
        server.world.settings.allowCheats = false;
        server.world.settings.saveSettings();
        server.world.settings.sendSettingsPacket();
        if (requester != null) {
            requester.sendChatMessage((GameMessage)MSG_CLEAR_WORLD);
        }
    }

    private void grantAllAchievements(ServerClient client) {
        if (client == null || !client.achievementsLoaded()) {
            return;
        }
        AchievementManager manager = client.achievements();
        if (manager == null) {
            return;
        }
        for (Achievement achievement : manager.getAchievements()) {
            this.forceCompleteAchievement(client, achievement);
        }
        manager.saveAchievementsFileSafe();
        client.sendChatMessage((GameMessage)MSG_ACHIEVEMENTS_UNLOCKED);
    }

    private void forceCompleteAchievement(ServerClient client, Achievement achievement) {
        if (achievement == null || achievement.isCompleted()) {
            return;
        }
        try {
            Field completedField = this.getCompletedField(achievement.getClass());
            if (completedField != null) {
                completedField.setAccessible(true);
                completedField.setBoolean(achievement, true);
                completedField.setAccessible(false);
            }
            Method updateTime = Achievement.class.getDeclaredMethod("updateTimeCompleted", new Class[0]);
            updateTime.setAccessible(true);
            updateTime.invoke((Object)achievement, new Object[0]);
            updateTime.setAccessible(false);
            if (client.getServer() != null && client.getServer().network != null) {
                client.getServer().network.sendToAllClients((Packet)new PacketAchievementUpdate(client, achievement, true));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to grant achievement " + achievement.stringID, e);
        }
    }

    private Field getCompletedField(Class<?> clazz) throws NoSuchFieldException {
        while (clazz != null) {
            try {
                return clazz.getDeclaredField("completed");
            }
            catch (NoSuchFieldException ignored) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException("completed");
    }
}

