/*
 * Decompiled with CFR 0.152.
 */
package moremapsmod;

import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.MapIconRegistry;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.engine.util.LevelIdentifier;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.mapItem.WorldPresetMapItem;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import necesse.level.maps.mapData.GameMapIcon;
import necesse.level.maps.mapData.TextureGameMapIcon;

@ModEntry
public class MoreMapsMod {
    public void init() {
        System.out.println("Initializing " + this.getClass().getSimpleName());
        this.registerMap("forestbearcave", LevelIdentifier.CAVE_IDENTIFIER, 120.0f);
        this.registerMap("chieftainarena", LevelIdentifier.CAVE_IDENTIFIER, 120.0f);
        this.registerMap("swampwitchcabins", LevelIdentifier.SURFACE_IDENTIFIER, 120.0f);
        this.registerMap("swampwitchcastle", LevelIdentifier.CAVE_IDENTIFIER, 360.0f);
        this.registerMap("desertcavelingoasis", LevelIdentifier.CAVE_IDENTIFIER, 1080.0f);
        this.registerMap("cursedcronearena", LevelIdentifier.DEEP_CAVE_IDENTIFIER, 360.0f);
        this.registerMap("deepswampagedchampion", LevelIdentifier.DEEP_CAVE_IDENTIFIER, 1080.0f);
        this.registerMap("temple", "deserttemple", LevelIdentifier.DEEP_CAVE_IDENTIFIER, 360.0f);
    }

    public void initResources() {
    }

    public void postInit() {
        Recipes.registerModRecipe((Recipe)new Recipe("forestbearcavemap", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 4)}).showAfter("villagemap"));
        Recipes.registerModRecipe((Recipe)new Recipe("chieftainarenamap", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 4), new Ingredient("runestone", 2)}).showAfter("dungeonmap"));
        Recipes.registerModRecipe((Recipe)new Recipe("swampwitchcabinsmap", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 4), new Ingredient("ivybar", 2)}).showAfter("chieftainarenamap"));
        Recipes.registerModRecipe((Recipe)new Recipe("swampwitchcastlemap", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 8), new Ingredient("ivybar", 4)}).showAfter("swampwitchcabinsmap"));
        Recipes.registerModRecipe((Recipe)new Recipe("desertcavelingoasismap", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 16), new Ingredient("quartz", 8)}).showAfter("piratemap"));
        Recipes.registerModRecipe((Recipe)new Recipe("cursedcronearenamap", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 8), new Ingredient("amber", 4)}).showAfter("desertcavelingoasismap"));
        Recipes.registerModRecipe((Recipe)new Recipe("deepswampagedchampionmap", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 16), new Ingredient("myceliumbar", 8)}).showAfter("cursedcronearenamap"));
        Recipes.registerModRecipe((Recipe)new Recipe("templemap", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 8), new Ingredient("ancientfossilbar", 4)}).showAfter("deepswampagedchampionmap"));
    }

    private void registerMap(String keyword, String presetName, LevelIdentifier identifier, float brokerValue) {
        MapIconRegistry.registerIcon((String)keyword, (GameMapIcon)new TextureGameMapIcon("ui/mapicons/" + keyword));
        ItemRegistry.registerItem((String)(keyword + "map"), (Item)new WorldPresetMapItem(Item.Rarity.RARE, identifier, 800, keyword, (GameMessage)new LocalMessage("mapicon", keyword), new String[]{presetName}), (float)brokerValue, (boolean)true);
    }

    private void registerMap(String keyword, LevelIdentifier identifier, float brokerValue) {
        this.registerMap(keyword, keyword, identifier, brokerValue);
    }

    private void registerMapRecipe(String keyword, LevelIdentifier identifier, float brokerValue) {
        this.registerMap(keyword, keyword, identifier, brokerValue);
    }
}

