/*
 * Decompiled with CFR 0.152.
 */
package multitools.ui;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import multitools.ObjectCategories;
import multitools.TileCategories;
import multitools.items.MultitoolToolItem;
import multitools.packet.PacketUpdateGNDData;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.Renderer;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptionsList;
import necesse.gfx.drawables.SortedDrawable;
import necesse.gfx.forms.components.FormCheckBox;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormTextButton;
import necesse.gfx.forms.components.localComponents.FormLocalCheckBox;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.presets.sidebar.SidebarForm;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.ui.ButtonColor;
import necesse.inventory.InventoryItem;
import necesse.level.maps.hudManager.HudDrawElement;
import necesse.level.maps.light.GameLight;

public class MultitoolSidebarForm
extends SidebarForm {
    private static final int CHECK_INTERVAL = 40;
    private static final int SINE_PULSE_PERIOD = 400;
    private static boolean isCollapsed = false;
    private static int formHeight = 0;
    private volatile boolean shouldUpdate = false;
    private volatile float sineTimer;
    private final Map<String, FormCheckBox> checkBoxes = new ConcurrentHashMap<String, FormCheckBox>();
    private final List<Point> highlights = new ArrayList<Point>();
    private HudDrawElement highlightDrawElement;
    private Client client;
    private float checkTimer;

    public MultitoolSidebarForm(InventoryItem item, GNDItemMap categoryFilter) {
        super("drs_multitoolsidebar", 160, 120, item);
        Objects.requireNonNull(categoryFilter);
        FormFlow listFlow = new FormFlow(5);
        this.addComponent((FormComponent)new FormLocalLabel("ui", "drs_miningfilter", new FontOptions(16), -1, 5, listFlow.next(25)));
        FormTextButton collapse = (FormTextButton)this.addComponent((FormComponent)new FormTextButton(isCollapsed ? "+" : "-", 135, 5, 20, FormInputSize.SIZE_20, ButtonColor.BASE));
        int presetButtonsY = listFlow.next(20);
        FormTextButton axePreset = (FormTextButton)this.addComponent((FormComponent)new FormLocalTextButton("ui", "drs_allbutfloors", 2, presetButtonsY, 95, FormInputSize.SIZE_16, ButtonColor.BASE){});
        FormTextButton shovelPreset = (FormTextButton)this.addComponent((FormComponent)new FormLocalTextButton("ui", "drs_shovel", 100, presetButtonsY, 57, FormInputSize.SIZE_16, ButtonColor.BASE){});
        int selectButtonsY = listFlow.next(20);
        FormTextButton selectAll = (FormTextButton)this.addComponent((FormComponent)new FormLocalTextButton("ui", "drs_setall", 5, selectButtonsY, 70, FormInputSize.SIZE_16, ButtonColor.BASE){});
        FormTextButton selectNone = (FormTextButton)this.addComponent((FormComponent)new FormLocalTextButton("ui", "drs_setnone", 85, selectButtonsY, 70, FormInputSize.SIZE_16, ButtonColor.BASE){});
        ObjectCategories.COMPUTED.keySet().forEach(category -> this.checkBoxes.put((String)category, (this.addComponent((FormComponent)new FormLocalCheckBox("categories", "drs_" + category, 5, listFlow.next(20), categoryFilter.getBoolean(category), (String)category){
            final /* synthetic */ String val$category;
            {
                this.val$category = string;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            public GameTooltips getTooltip() {
                return new StringTooltips(Localization.translate((String)"categories", (String)("drs_" + this.val$category + "_desc")));
            }
        })).onClicked(e -> {
            MultitoolToolItem.getCategoryFilter(item).setBoolean(category, ((FormCheckBox)e.from).checked);
            if (this.client != null) {
                this.client.network.sendPacket((Packet)new PacketUpdateGNDData(item, "filter"));
            }
        })));
        TileCategories.COMPUTED.keySet().forEach(category -> this.checkBoxes.put((String)category, (this.addComponent((FormComponent)new FormLocalCheckBox("categories", "drs_" + category, 5, listFlow.next(20), categoryFilter.getBoolean(category), (String)category){
            final /* synthetic */ String val$category;
            {
                this.val$category = string;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            public GameTooltips getTooltip() {
                return new StringTooltips(Localization.translate((String)"categories", (String)("drs_" + this.val$category + "_desc")));
            }
        })).onClicked(e -> {
            MultitoolToolItem.getCategoryFilter(item).setBoolean(category, ((FormCheckBox)e.from).checked);
            if (this.client != null) {
                this.client.network.sendPacket((Packet)new PacketUpdateGNDData(item, "filter"));
            }
        })));
        axePreset.onClicked(e -> {
            GNDItemMap map = MultitoolToolItem.getCategoryFilter(item);
            this.checkBoxes.forEach((cat, cb) -> {
                boolean checked;
                cb.checked = checked = cat.equals("walls") || cat.equals("crafting") || cat.equals("storage") || cat.equals("objects") || cat.equals("transport") || cat.equals("wiring") || cat.equals("clutter") || cat.equals("ore") || cat.equals("harvestable");
                map.setBoolean(cat, checked);
            });
            item.getGndData().setItem("filter", (GNDItem)map);
            if (this.client != null) {
                this.client.network.sendPacket((Packet)new PacketUpdateGNDData(item, "filter"));
            }
        });
        shovelPreset.onClicked(e -> {
            GNDItemMap map = MultitoolToolItem.getCategoryFilter(item);
            this.checkBoxes.forEach((cat, cb) -> {
                boolean checked;
                cb.checked = checked = cat.equals("flooring") || cat.equals("terrain");
                map.setBoolean(cat, checked);
            });
            item.getGndData().setItem("filter", (GNDItem)map);
            if (this.client != null) {
                this.client.network.sendPacket((Packet)new PacketUpdateGNDData(item, "filter"));
            }
        });
        selectAll.onClicked(e -> {
            GNDItemMap map = MultitoolToolItem.getCategoryFilter(item);
            this.checkBoxes.forEach((cat, cb) -> {
                cb.checked = true;
                map.setBoolean(cat, true);
            });
            item.getGndData().setItem("filter", (GNDItem)map);
            if (this.client != null) {
                this.client.network.sendPacket((Packet)new PacketUpdateGNDData(item, "filter"));
            }
        });
        selectNone.onClicked(e -> {
            this.checkBoxes.values().forEach(cb -> {
                cb.checked = false;
            });
            item.getGndData().setItem("filter", (GNDItem)new GNDItemMap());
            if (this.client != null) {
                this.client.network.sendPacket((Packet)new PacketUpdateGNDData(item, "filter"));
            }
        });
        collapse.onClicked(e -> {
            FormTextButton btn = (FormTextButton)e.from;
            if (isCollapsed) {
                btn.setText("-");
                isCollapsed = false;
            } else {
                btn.setText("+");
                isCollapsed = true;
            }
        });
        formHeight = listFlow.next() + 5;
        this.setHeight(formHeight);
    }

    public void onAdded(Client client) {
        super.onAdded(client);
        this.client = client;
        this.highlightDrawElement = new HudDrawElement(){

            public void addDrawables(List<SortedDrawable> list, GameCamera camera, PlayerMob player) {
                if (MultitoolSidebarForm.this.shouldUpdate) {
                    MultitoolSidebarForm.this.shouldUpdate = false;
                    MultitoolSidebarForm.this.highlights.clear();
                    String currentCat = MultitoolSidebarForm.this.checkBoxes.entrySet().parallelStream().filter(e -> ((FormCheckBox)e.getValue()).isHovering()).map(Map.Entry::getKey).findAny().orElse("");
                    if (currentCat.isEmpty()) {
                        MultitoolSidebarForm.this.sineTimer = 0.0f;
                        return;
                    }
                    int lx = camera.getX() / 32 - 1;
                    int ly = camera.getY() / 32 - 1;
                    int hx = (camera.getX() + camera.getWidth()) / 32 + 1;
                    int hy = (camera.getY() + camera.getHeight()) / 32 + 1;
                    for (int ty = ly; ty <= hy; ++ty) {
                        for (int tx = lx; tx <= hx; ++tx) {
                            if (!MultitoolToolItem.isInCategory(player.getLevel(), tx, ty, currentCat)) continue;
                            MultitoolSidebarForm.this.highlights.add(new Point(tx, ty));
                        }
                    }
                }
                int alpha = (int)(64.0 - 48.0 * Math.cos((double)(MultitoolSidebarForm.this.sineTimer / 400.0f) * 2.0 * Math.PI));
                final DrawOptionsList drawOptions = new DrawOptionsList();
                MultitoolSidebarForm.this.highlights.forEach(p -> {
                    int drawX = camera.getTileDrawX(p.x);
                    int drawY = camera.getTileDrawY(p.y);
                    if (drawX >= -32 && drawX <= camera.getWidth() + 32 && drawY >= -32 && drawY <= camera.getHeight() + 32) {
                        GameLight light = player.getLevel().getLightLevel(p.x, p.y);
                        drawOptions.add(() -> Renderer.initQuadDraw((int)32, (int)32).color(new Color(64, 24, 192, alpha), true).light(light).draw(drawX, drawY));
                    }
                });
                list.add(new SortedDrawable(){

                    public int getPriority() {
                        return 80;
                    }

                    public void draw(TickManager tm) {
                        drawOptions.draw();
                    }
                });
            }
        };
        client.getLevel().hudManager.addElement(this.highlightDrawElement);
    }

    public void onRemoved(Client client) {
        super.onRemoved(client);
        if (this.highlightDrawElement != null) {
            this.highlightDrawElement.remove();
        }
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        this.setHeight(isCollapsed ? 30 : formHeight);
        super.draw(tickManager, perspective, renderBox);
        float sineTimer = this.sineTimer + tickManager.getDelta();
        this.sineTimer = sineTimer % 400.0f;
        if (!this.shouldUpdate) {
            this.checkTimer += tickManager.getDelta();
        }
        if (this.checkTimer > 40.0f) {
            this.checkTimer = 0.0f;
            this.shouldUpdate = true;
        }
    }
}

