/*
 * Decompiled with CFR 0.152.
 */
package multitools.packet;

import java.util.HashSet;
import java.util.Set;
import necesse.engine.GameLog;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.inventory.InventoryItem;

public class PacketUpdateGNDData
extends Packet {
    private static final Set<String> WHITELIST = new HashSet<String>(){
        {
            this.add("filter");
            this.add("usealt");
        }
    };
    public final InventoryItem inventoryItem;
    public final String gndItemName;

    public PacketUpdateGNDData(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.inventoryItem = InventoryItem.fromContentPacket((PacketReader)reader);
        this.gndItemName = reader.getNextString();
        if (!WHITELIST.contains(this.gndItemName)) {
            GameLog.warn.println(this.gndItemName + " is not whitelisted for PacketUpdateGNDData. Ignoring.");
        }
    }

    public PacketUpdateGNDData(InventoryItem item, String gndItemName) {
        this.inventoryItem = item;
        this.gndItemName = gndItemName;
        PacketWriter writer = new PacketWriter((Packet)this);
        item.addPacketContent(writer);
        writer.putNextString(gndItemName);
        if (!WHITELIST.contains(gndItemName)) {
            GameLog.warn.println(gndItemName + " is not whitelisted for PacketUpdateGNDData. Ignoring.");
        }
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        InventoryItem selected;
        if (this.inventoryItem != null && WHITELIST.contains(this.gndItemName) && (selected = client.playerMob.getSelectedItem()) != null && selected.item.equals(this.inventoryItem.item)) {
            selected.getGndData().setItem(this.gndItemName, this.inventoryItem.getGndData().getItem(this.gndItemName));
        }
    }
}

