/*
 * Decompiled with CFR 0.152.
 */
package multitools.items.planner;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import multitools.MultiTools;
import multitools.Util;
import multitools.items.PlannerItem;
import necesse.engine.GlobalData;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptionsList;
import necesse.gfx.drawables.SortedDrawable;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.ui.HUD;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.level.maps.hudManager.HudDrawElement;
import necesse.level.maps.regionSystem.Region;

public class PlannerLevelEvent
extends LevelEvent {
    public static boolean activeOnClient = false;
    public static boolean activeOnServer = false;
    private static final int[] NEIGH_SURROUND = new int[]{1, 3, 5, 7};
    private static final int[][] NEIGH_CONTIGUOUS = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}};
    private final List<Point> validPlacements = Collections.synchronizedList(new ArrayList());
    private final PlayerMob player;
    private int tile1X;
    private int tile1Y;
    private int tile2X;
    private int tile2Y;
    private final int placeInterval;
    private float placeTimer = 0.0f;
    private boolean active = false;
    private boolean useAlt = false;
    private InventoryItem item;
    private HudDrawElement cursorDrawElement;

    public PlannerLevelEvent(PlayerMob player, InventoryItem item) {
        super(false);
        if (!(item.item instanceof PlannerItem)) {
            throw new IllegalArgumentException("item using this event should be a PlannerItem");
        }
        this.player = player;
        this.item = item;
        this.placeInterval = item.item.getAttackCooldownTime(item, (ItemAttackerMob)player) / 2;
        if (player.getLevel().isClient()) {
            activeOnClient = true;
        } else {
            activeOnServer = true;
        }
    }

    public void init() {
        super.init();
        if (this.level.isClient()) {
            this.cursorDrawElement = new HudDrawElement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void addDrawables(List<SortedDrawable> list, GameCamera camera, PlayerMob perspective) {
                    final DrawOptionsList drawOptions = new DrawOptionsList();
                    float aimAlpha = PlannerLevelEvent.this.active ? 0.5f : 1.0f;
                    GameTexture tgtTex = PlannerLevelEvent.this.useAlt ? MultiTools.greenTargetTexture : MultiTools.blueTargetTexture;
                    GameTexture aimTex = PlannerLevelEvent.this.useAlt ? MultiTools.greenAimTexture : MultiTools.blueAimTexture;
                    PlannerLevelEvent.this.forEachPoint((tx, ty) -> {
                        int drawX = camera.getTileDrawX(tx.intValue());
                        int drawY = camera.getTileDrawY(ty.intValue());
                        if (drawX >= -32 && drawX <= camera.getWidth() + 32 && drawY >= -32 && drawY <= camera.getHeight() + 32) {
                            drawOptions.add(() -> aimTex.initDraw().alpha(aimAlpha).draw(drawX, drawY));
                        }
                    });
                    if (PlannerLevelEvent.this.active) {
                        List list2 = PlannerLevelEvent.this.validPlacements;
                        synchronized (list2) {
                            PlannerLevelEvent.this.validPlacements.forEach(p -> {
                                int drawX = camera.getTileDrawX(p.x);
                                int drawY = camera.getTileDrawY(p.y);
                                if (drawX >= -32 && drawX <= camera.getWidth() + 32 && drawY >= -32 && drawY <= camera.getHeight() + 32) {
                                    drawOptions.add(() -> tgtTex.initDraw().draw(drawX, drawY));
                                }
                            });
                        }
                    }
                    int lx = Math.min(PlannerLevelEvent.this.tile1X, PlannerLevelEvent.this.tile2X);
                    int ly = Math.min(PlannerLevelEvent.this.tile1Y, PlannerLevelEvent.this.tile2Y);
                    int hx = Math.max(PlannerLevelEvent.this.tile1X, PlannerLevelEvent.this.tile2X);
                    int hy = Math.max(PlannerLevelEvent.this.tile1Y, PlannerLevelEvent.this.tile2Y);
                    drawOptions.add((Object)HUD.tileBoundOptions((GameCamera)camera, (Color)new Color(128, 128, 255, 128), (boolean)false, (int)lx, (int)ly, (int)hx, (int)hy));
                    list.add(new SortedDrawable(){

                        public int getPriority() {
                            return 100;
                        }

                        public void draw(TickManager tm) {
                            drawOptions.draw();
                        }
                    });
                }
            };
            this.level.hudManager.addElement(this.cursorDrawElement);
        }
    }

    private void forEachPoint(BiConsumer<Integer, Integer> fn) {
        int lx = Math.min(this.tile1X, this.tile2X);
        int ly = Math.min(this.tile1Y, this.tile2Y);
        int hx = Math.max(this.tile1X, this.tile2X);
        int hy = Math.max(this.tile1Y, this.tile2Y);
        for (int ty = ly; ty <= hy; ++ty) {
            for (int tx = lx; tx <= hx; ++tx) {
                fn.accept(tx, ty);
            }
        }
    }

    public void clientTick() {
        super.clientTick();
        if (!this.isOver() && this.player == this.level.getClient().getPlayer()) {
            int tile2Y;
            int tile2X;
            int tile1Y;
            int tile1X;
            GNDItem p1 = this.item.getGndData().getItem("p1");
            GNDItem p2 = this.item.getGndData().getItem("p2");
            this.useAlt = this.item.getGndData().getBoolean("usealt");
            if (p2 instanceof GNDItemMap) {
                tile1X = ((GNDItemMap)p1).getInt("x");
                tile1Y = ((GNDItemMap)p1).getInt("y");
                tile2X = ((GNDItemMap)p2).getInt("x");
                tile2Y = ((GNDItemMap)p2).getInt("y");
                this.active = true;
            } else {
                if (!(p1 instanceof GNDItemMap)) {
                    this.active = false;
                    PlannerItem.PREVIEWS.clear();
                    return;
                }
                GameCamera camera = GlobalData.getCurrentState().getCamera();
                tile1X = ((GNDItemMap)p1).getInt("x");
                tile1Y = ((GNDItemMap)p1).getInt("y");
                tile2X = camera.getMouseLevelTilePosX();
                tile2Y = camera.getMouseLevelTilePosY();
                this.active = false;
            }
            boolean update = tile1X != this.tile1X || tile1Y != this.tile1Y || tile2X != this.tile2X || tile2Y != this.tile2Y;
            this.tile1X = tile1X;
            this.tile1Y = tile1Y;
            this.tile2X = tile2X;
            this.tile2Y = tile2Y;
            if (update) {
                PlannerItem.PREVIEWS.clear();
                this.forEachPoint((tx, ty) -> PlannerItem.PREVIEWS.add(new Point(tx * 32, ty * 32)));
            }
        }
    }

    public void serverTick() {
        super.serverTick();
        if (!this.isOver()) {
            GNDItem p1 = this.item.getGndData().getItem("p1");
            GNDItem p2 = this.item.getGndData().getItem("p2");
            this.useAlt = this.item.getGndData().getBoolean("usealt");
            if (p1 instanceof GNDItemMap && p2 instanceof GNDItemMap) {
                this.tile1X = ((GNDItemMap)p1).getInt("x");
                this.tile1Y = ((GNDItemMap)p1).getInt("y");
                this.tile2X = ((GNDItemMap)p2).getInt("x");
                this.tile2Y = ((GNDItemMap)p2).getInt("y");
                this.active = true;
            } else {
                this.active = false;
            }
        }
    }

    private boolean shouldPlaceAt(int tileX, int tileY, BiFunction<Integer, Integer, Boolean> canPlace) {
        if (!canPlace.apply(tileX, tileY).booleanValue()) {
            return false;
        }
        int numNeighbors = 0;
        boolean[] neighbors = new boolean[NEIGH_CONTIGUOUS.length];
        for (int i = 0; i < NEIGH_CONTIGUOUS.length; ++i) {
            int[] p = NEIGH_CONTIGUOUS[i];
            boolean bl = neighbors[i] = canPlace.apply(tileX + p[0], tileY + p[1]) == false;
            if (!neighbors[i]) continue;
            ++numNeighbors;
        }
        int surround = 0;
        for (int p : NEIGH_SURROUND) {
            if (neighbors[p]) {
                ++surround;
            }
            if (surround <= 2) continue;
            return true;
        }
        if (numNeighbors <= 3) {
            return false;
        }
        int maxContiguousNeighbors = PlannerLevelEvent.getMaxContiguousNeighbors(neighbors);
        return Math.min(8, maxContiguousNeighbors) == numNeighbors;
    }

    private static int getMaxContiguousNeighbors(boolean[] neighbors) {
        int contiguousNeighbors = 0;
        int maxContiguousNeighbors = 0;
        for (int i = 0; i < NEIGH_CONTIGUOUS.length * 2; ++i) {
            boolean isNeighbor = neighbors[i % 8];
            if (isNeighbor) {
                maxContiguousNeighbors = Math.max(maxContiguousNeighbors, ++contiguousNeighbors);
                continue;
            }
            contiguousNeighbors = 0;
        }
        return maxContiguousNeighbors;
    }

    private Packet setupACP(InventoryItem invItem, int tx, int ty) {
        Packet packet = new Packet();
        invItem.item.setupAttackMapContent(new GNDItemMap(), this.level, tx * 32 + 16, ty * 32 + 16, (ItemAttackerMob)this.player, Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom), invItem);
        return packet;
    }

    public void tickMovement(float delta) {
        super.tickMovement(delta);
        if (this.isOver()) {
            return;
        }
        GNDItem p1 = this.item.getGndData().getItem("p1");
        GNDItem p2 = this.item.getGndData().getItem("p2");
        if (!(p1 instanceof GNDItemMap) && !(p2 instanceof GNDItemMap)) {
            this.over();
        } else {
            InventoryItem current = this.player.getSelectedItem();
            if (current != null) {
                this.item = current;
            }
            if (current != null && current.item instanceof PlannerItem && ((PlannerItem)current.item).getCurrentItem(current).orElse(null) == ((PlannerItem)this.item.item).getCurrentItem(this.item).orElse(null)) {
                if (!((PlannerItem)this.item.item).getCurrentInventoryItem(this.item).isPresent()) {
                    this.item.getGndData().setItem("p1", null);
                    this.item.getGndData().setItem("p2", null);
                    this.over();
                } else {
                    this.placeTimer += delta;
                    if (this.placeTimer > (float)this.placeInterval) {
                        this.placeTimer = 0.0f;
                        this.validPlacements.clear();
                        int objDir = this.item.getGndData().getInt("dir", 0);
                        ((PlannerItem)this.item.item).acceptItemPair(this.item, (invItem, item) -> {
                            BiFunction<Integer, Integer, Boolean> canPlaceAt = (x, y) -> Util.wrapWithDirChange(this.player, objDir, () -> {
                                GNDItemMap map = new GNDItemMap();
                                invItem.item.setupAttackMapContent(map, this.level, x * 32 + 16, y * 32 + 16, (ItemAttackerMob)this.player, Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom), invItem);
                                Line2D.Float line = new Line2D.Float(this.player.x, this.player.y, x * 32 + 16, y * 32 + 16);
                                if (this.useAlt && item instanceof ItemInteractAction) {
                                    return "sametile".equals(item.canPlace(this.level, x * 32 + 16, y * 32 + 16, this.player, (Line2D)line, invItem, map));
                                }
                                return item.canPlace(this.level, x * 32 + 16, y * 32 + 16, this.player, (Line2D)line, invItem, map) == null;
                            });
                            Util.runWithModifierChange(this.player.buffManager, BuffModifiers.BUILD_RANGE, Float.valueOf(1000.0f), () -> this.forEachPoint((tx, ty) -> {
                                boolean shouldPlace = this.shouldPlaceAt((int)tx, (int)ty, (x, y) -> x >= Math.min(this.tile1X, this.tile2X) && x <= Math.max(this.tile1X, this.tile2X) && y >= Math.min(this.tile1Y, this.tile2Y) && y <= Math.max(this.tile1Y, this.tile2Y) && (Boolean)canPlaceAt.apply((Integer)x, (Integer)y) != false);
                                if (shouldPlace) {
                                    this.validPlacements.add(new Point((int)tx, (int)ty));
                                }
                            }));
                        });
                        if (this.active && ((PlannerItem)current.item).getCurrentInventoryItem(this.item).map(invItem -> invItem.itemStackSize() == 1 || invItem.getAmount() > 1).orElse(false).booleanValue()) {
                            float maxDist = 0.0f;
                            Point furthest = null;
                            for (Point p : this.validPlacements) {
                                float dist = this.player.getDistance((float)(p.x * 32 + 16), (float)(p.y * 32 + 16));
                                if (!(dist > maxDist)) continue;
                                maxDist = dist;
                                furthest = p;
                            }
                            if (furthest != null) {
                                Point finalFurthest = furthest;
                                ((PlannerItem)this.item.item).acceptItemPair(this.item, (invItem, item) -> {
                                    GNDItemMap mapContent = new GNDItemMap();
                                    Util.runWithDirChange(this.player, objDir, () -> invItem.item.setupAttackMapContent(mapContent, this.level, finalFurthest.x * 32 + 16, finalFurthest.y * 32 + 16, (ItemAttackerMob)this.player, Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom), invItem));
                                    if (this.useAlt && item instanceof ItemInteractAction) {
                                        ((ItemInteractAction)item).onLevelInteract(this.level, finalFurthest.x * 32 + 16, finalFurthest.y * 32 + 16, (ItemAttackerMob)this.player, this.player.getCurrentAttackHeight(), invItem, this.player.getCurrentSelectedAttackSlot(), this.player.attackSeed, new GNDItemMap());
                                    } else {
                                        item.onAttack(this.level, finalFurthest.x * 32 + 16, finalFurthest.y * 32 + 16, (ItemAttackerMob)this.player, this.player.getCurrentAttackHeight(), invItem, this.player.getCurrentSelectedAttackSlot(), 1, Item.getRandomAttackSeed((GameRandom)GameRandom.globalRandom), mapContent);
                                    }
                                    this.player.getSelectedItemSlot().markDirty(this.player.getInv());
                                });
                            }
                        }
                    }
                }
            } else {
                this.over();
            }
        }
    }

    public void over() {
        PlannerItem.PREVIEWS.clear();
        if (this.level.isClient()) {
            activeOnClient = false;
        } else {
            activeOnServer = false;
        }
        super.over();
        if (this.cursorDrawElement != null) {
            this.cursorDrawElement.remove();
        }
    }

    public void onDispose() {
        super.onDispose();
        if (!this.isOver()) {
            this.over();
        }
    }

    public void onUnloading(Region region) {
        super.onUnloading(region);
        if (!this.isOver()) {
            this.over();
        }
    }
}

