/*
 * Decompiled with CFR 0.152.
 */
package multitools.items.multitool;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.CRC32;
import multitools.MultiTools;
import multitools.items.MultitoolToolItem;
import multitools.items.multitool.MultitoolAttackHandler;
import necesse.engine.GameLog;
import necesse.engine.GlobalData;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptionsList;
import necesse.gfx.drawables.SortedDrawable;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.ToolDamageItem;
import necesse.level.maps.hudManager.HudDrawElement;

public class MultitoolLevelEvent
extends LevelEvent {
    public int levelX;
    public int levelY;
    private final ConcurrentLinkedDeque<MiningTarget> targets = new ConcurrentLinkedDeque();
    private final List<MiningTarget> currentlyMining;
    private final Set<MiningTarget> farTargets;
    private final InventoryItem item;
    private final PlayerMob player;
    private final int attackInterval;
    private final int smartMineSelectInterval;
    private final int damagePerHit;
    private final int maxTargets;
    private final int maxMining;
    private final float targetRangeFactor;
    private MultitoolAttackHandler attackHandler = null;
    private HudDrawElement cursorDrawElement;
    private float attackTimer = 0.0f;
    private long lastAddition = 0L;
    private boolean startDamage = false;
    private boolean targetsValid = true;

    public MultitoolLevelEvent(PlayerMob player, int levelX, int levelY, InventoryItem item) {
        super(false);
        if (!(item.item instanceof MultitoolToolItem)) {
            throw new IllegalArgumentException("item using this event should be a MultitoolToolItem");
        }
        this.levelX = levelX;
        this.levelY = levelY;
        this.player = player;
        this.item = item;
        this.maxTargets = ((MultitoolToolItem)item.item).getMaxTargets();
        this.maxMining = ((MultitoolToolItem)item.item).getMaxMining();
        this.targetRangeFactor = ((MultitoolToolItem)item.item).getTargetRangeFactor();
        this.attackInterval = item.item.getAttackCooldownTime(item, (ItemAttackerMob)player);
        this.smartMineSelectInterval = (int)((double)item.item.getAttackSpeedModifier(item, (ItemAttackerMob)player) * 0.6);
        this.damagePerHit = (int)((ToolDamageItem)item.item).getToolDamagePerHit(item, (ItemAttackerMob)player);
        this.currentlyMining = new ArrayList<MiningTarget>(this.maxMining);
        this.farTargets = new HashSet<MiningTarget>(this.maxTargets);
    }

    public void setAttackHandler(MultitoolAttackHandler attackHandler) {
        this.attackHandler = attackHandler;
    }

    public void init() {
        super.init();
        if (this.level.isClient()) {
            this.cursorDrawElement = new HudDrawElement(){

                public void addDrawables(List<SortedDrawable> list, GameCamera camera, PlayerMob perspective) {
                    final DrawOptionsList drawOptions = new DrawOptionsList();
                    MultitoolLevelEvent.this.targets.forEach(t -> {
                        int drawX = camera.getTileDrawX(t.x);
                        int drawY = camera.getTileDrawY(t.y);
                        if (MultitoolLevelEvent.this.farTargets.contains(t)) {
                            drawOptions.add(() -> MultiTools.aimTexture.initDraw().alpha(0.3f).draw(drawX, drawY));
                        } else {
                            drawOptions.add(() -> MultiTools.aimTexture.initDraw().draw(drawX, drawY));
                        }
                    });
                    MultitoolLevelEvent.this.currentlyMining.forEach(t -> {
                        int drawX = camera.getTileDrawX(t.x);
                        int drawY = camera.getTileDrawY(t.y);
                        drawOptions.add(() -> MultiTools.targetTexture.initDraw().draw(drawX, drawY));
                    });
                    list.add(new SortedDrawable(){

                        public int getPriority() {
                            return 100;
                        }

                        public void draw(TickManager tm) {
                            drawOptions.draw();
                        }
                    });
                }
            };
            this.level.hudManager.addElement(this.cursorDrawElement);
        }
    }

    public MiningTarget getTarget(int tileX, int tileY) {
        int objectId = this.level.getObjectID(tileX, tileY);
        int tileId = this.level.getTileID(tileX, tileY);
        if (objectId != 0) {
            return new MiningTarget(true, objectId, tileX, tileY, 0);
        }
        return tileId != 0 ? new MiningTarget(false, tileId, tileX, tileY) : null;
    }

    public void onTargetUpdate(int tileX, int tileY, int targetsHash) {
        MiningTarget target = this.getTarget(tileX, tileY);
        if (target == null) {
            this.attackHandler.requestTargetRecheck();
        } else {
            this.targets.addLast(target);
            if (targetsHash != this.targetsHash()) {
                this.targetsValid = false;
                this.attackHandler.requestTargetRefresh();
            }
            this.startDamage = true;
        }
    }

    public void writeTargetsToPacket(PacketWriter writer) {
        writer.putNextInt(this.targets.size());
        writer.putNextInt(this.targetsHash());
        this.targets.forEach(t -> t.serialize(writer));
    }

    public void checkAndWriteTargetsToPacket(PacketWriter writer) {
        this.recheckTargets();
        this.writeTargetsToPacket(writer);
    }

    public void readTargetsFromPacket(PacketReader reader) {
        int size = reader.getNextInt();
        int hash = reader.getNextInt();
        this.targets.clear();
        for (int i = 0; i < size; ++i) {
            this.targets.addLast(MiningTarget.deserialize(reader));
        }
        if (hash != this.targetsHash()) {
            GameLog.warn.println("RECEIVED TARGETS PACKET MISMATCH!");
        } else {
            this.targetsValid = true;
        }
    }

    public int targetsHash() {
        CRC32 hash = new CRC32();
        this.targets.forEach(target -> {
            hash.update(target.x >> 24);
            hash.update(target.x & 0xFF);
            hash.update(target.y >> 24);
            hash.update(target.y & 0xFF);
            hash.update(target.id >> 24);
            hash.update(target.id & 0xFF);
            hash.update(target.isObject ? 1 : 0);
            hash.update(target.priorityObjectLayerID);
        });
        return (int)hash.getValue();
    }

    public void serverTick() {
        super.serverTick();
    }

    public void clientTick() {
        super.clientTick();
        if (!this.isOver() && this.player == this.level.getClient().getPlayer()) {
            if (this.targets.size() >= this.maxTargets) {
                return;
            }
            GameCamera camera = GlobalData.getCurrentState().getCamera();
            this.levelX = camera.getMouseLevelPosX();
            this.levelY = camera.getMouseLevelPosY();
            ToolDamageItem toolItem = (ToolDamageItem)this.item.item;
            if (Settings.smartMining) {
                int id;
                ToolDamageItem.SmartMineTarget smartTarget = toolItem.getFirstSmartHitTile(this.level, this.player, this.item, this.levelX, this.levelY);
                if (smartTarget == null) {
                    return;
                }
                int tileX = smartTarget.x;
                int tileY = smartTarget.y;
                for (MiningTarget target : this.targets) {
                    if (!target.sameTileAs(tileX, tileY)) continue;
                    return;
                }
                int n = id = smartTarget.isObject ? this.level.getObjectID(tileX, tileY) : this.level.getTileID(tileX, tileY);
                if (id == 0) {
                    return;
                }
                MiningTarget newTarget = new MiningTarget(smartTarget.isObject, id, smartTarget.x, smartTarget.y, smartTarget.priorityObjectLayerID);
                if (toolItem.canDamageTile(this.level, newTarget.priorityObjectLayerID, tileX, tileY, (ItemAttackerMob)this.player, this.item)) {
                    this.targets.addLast(newTarget);
                    this.lastAddition = this.level.getWorldEntity().getTime();
                    this.attackHandler.sendTargetUpdate(tileX, tileY, this.targetsHash());
                    if (!this.startDamage) {
                        this.startDamage = true;
                        this.doDamage();
                    }
                } else {
                    GameLog.debug.println("MultitoolLevelEvent.clientTick: Smart mining - canDamageTile returned false for target " + newTarget);
                }
            } else {
                MiningTarget target;
                int tileX = (this.levelX - 32) / 32;
                int tileY = (this.levelY - 32) / 32;
                for (MiningTarget target2 : this.targets) {
                    if (!target2.sameTileAs(tileX, tileY)) continue;
                    return;
                }
                if (Math.hypot(this.player.x - (float)(tileX * 32 + 16), this.player.y - (float)(tileY * 32 + 16)) <= (double)(this.targetRangeFactor * (float)toolItem.getMiningRange(this.item, (ItemAttackerMob)this.player)) && (target = this.getTarget(tileX, tileY)) != null && toolItem.canDamageTile(this.level, target.priorityObjectLayerID, tileX, tileY, (ItemAttackerMob)this.player, this.item)) {
                    this.targets.addLast(target);
                    this.lastAddition = this.level.getWorldEntity().getTime();
                    this.attackHandler.sendTargetUpdate(tileX, tileY, this.targetsHash());
                    if (!this.startDamage) {
                        this.startDamage = true;
                        this.doDamage();
                    }
                }
            }
        }
    }

    public void tickMovement(float delta) {
        super.tickMovement(delta);
        if (this.startDamage) {
            this.attackTimer -= delta;
            if (this.attackTimer <= 0.0f) {
                this.attackTimer = this.attackInterval;
                this.doDamage();
            }
        }
    }

    private void recheckTargets() {
        ToolDamageItem toolItem = (ToolDamageItem)this.item.item;
        this.targets.removeIf(t -> {
            boolean remove = false;
            if (this.level.getObjectID(t.x, t.y) == 0 && this.level.getTileID(t.x, t.y) == 0) {
                remove = true;
            } else if (Math.hypot(this.player.x - (float)(t.x * 32 + 16), this.player.y - (float)(t.y * 32 + 16)) > (double)(this.targetRangeFactor * (float)toolItem.getMiningRange(this.item, (ItemAttackerMob)this.player))) {
                remove = true;
            } else if (t.isObject) {
                if (this.level.getObjectID(t.x, t.y) != t.id) {
                    remove = true;
                }
            } else if (this.level.getTileID(t.x, t.y) != t.id) {
                remove = true;
            }
            return remove;
        });
    }

    public void doDamage() {
        if (this.targetsValid) {
            MultitoolToolItem toolItem = (MultitoolToolItem)this.item.item;
            this.recheckTargets();
            this.farTargets.clear();
            this.currentlyMining.clear();
            Iterator<MiningTarget> iterator = this.targets.iterator();
            for (int i = 0; i < this.maxMining && iterator.hasNext(); ++i) {
                MiningTarget target = iterator.next();
                if (!toolItem.isTileInRange(this.level, target.x, target.y, (ItemAttackerMob)this.player, new Line2D.Float(this.player.x, this.player.y, target.x * 32 + 16, target.y * 32 + 16), this.item)) {
                    this.farTargets.add(target);
                    --i;
                    continue;
                }
                toolItem.runTileDamage(this.level, target.x * 32, target.y * 32, target.priorityObjectLayerID, target.x, target.y, this.player, this.item, this.damagePerHit);
                this.currentlyMining.add(target);
            }
        }
    }

    public boolean canSmartMine(int tileX, int tileY) {
        MiningTarget recentTarget = this.targets.peekLast();
        if (recentTarget == null) {
            return true;
        }
        if (recentTarget.sameTileAs(tileX, tileY)) {
            return this.level.getWorldEntity().getTime() - this.lastAddition >= (long)this.smartMineSelectInterval;
        }
        for (MiningTarget target : this.targets) {
            if (!target.sameTileAs(tileX, tileY)) continue;
            return false;
        }
        return true;
    }

    public void over() {
        super.over();
        if (this.cursorDrawElement != null) {
            this.cursorDrawElement.remove();
        }
    }

    public static class MiningTarget {
        public final boolean isObject;
        public final int id;
        public final int x;
        public final int y;
        public final int priorityObjectLayerID;

        public MiningTarget(boolean isObject, int id, int x, int y) {
            this(isObject, id, x, y, 0);
        }

        public MiningTarget(boolean isObject, int id, int x, int y, int priorityObjectLayerID) {
            if (id == 0) {
                throw new IllegalArgumentException("id must never be zero");
            }
            this.isObject = isObject;
            this.id = id;
            this.x = x;
            this.y = y;
            this.priorityObjectLayerID = priorityObjectLayerID;
        }

        public static MiningTarget deserialize(PacketReader reader) {
            return new MiningTarget(reader.getNextBoolean(), reader.getNextInt(), reader.getNextInt(), reader.getNextInt(), reader.getNextInt());
        }

        public void serialize(PacketWriter writer) {
            writer.putNextBoolean(this.isObject);
            writer.putNextInt(this.id);
            writer.putNextInt(this.x);
            writer.putNextInt(this.y);
            writer.putNextInt(this.priorityObjectLayerID);
        }

        public boolean sameTileAs(int otherX, int otherY) {
            return this.x == otherX && this.y == otherY;
        }

        public boolean sameTileAs(MiningTarget other) {
            return this.sameTileAs(other.x, other.y);
        }

        public boolean sameAs(MiningTarget other) {
            return this.sameTileAs(other) && this.isObject == other.isObject && this.id == other.id && this.priorityObjectLayerID == other.priorityObjectLayerID;
        }

        public String toString() {
            return "MiningTarget{isObject=" + this.isObject + ", id=" + this.id + ", x=" + this.x + ", y=" + this.y + ", priorityObjectLayerID=" + this.priorityObjectLayerID + '}';
        }
    }
}

