/*
 * Decompiled with CFR 0.152.
 */
package multitools.items.multitool;

import multitools.items.multitool.MultitoolLevelEvent;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.InventoryItem;

public class MultitoolAttackHandler
extends AttackHandler {
    public final MultitoolLevelEvent event;
    private final int animAttacks;
    private final int seed;
    private int animCounter = 1;
    private int tileX;
    private int tileY;
    private int targetsHash;
    private MultitoolPacketType packetType = MultitoolPacketType.NULL;
    private PlayerMob player;

    public MultitoolAttackHandler(PlayerMob player, ItemAttackSlot slot, InventoryItem item, int levelX, int levelY, int animAttacks, int animSpeed, int attackSeed) {
        super((ItemAttackerMob)player, slot, animSpeed / animAttacks);
        this.animAttacks = animAttacks;
        this.seed = attackSeed;
        this.event = new MultitoolLevelEvent(player, levelX, levelY, item);
        this.event.setAttackHandler(this);
        player.getLevel().entityManager.events.addHidden((LevelEvent)this.event);
    }

    public void sendTargetUpdate(int newTileX, int newTileY, int targetsHash) {
        this.checkClient();
        this.packetType = MultitoolPacketType.CLIENT_TARGET_UPDATE;
        this.tileX = newTileX;
        this.tileY = newTileY;
        this.targetsHash = targetsHash;
        this.sendPacketUpdate(false);
    }

    public void requestTargetRefresh() {
        this.checkServer();
        this.packetType = MultitoolPacketType.SERVER_TARGET_REFRESH;
        this.sendPacketUpdate(false);
    }

    public void sendTargetRefresh() {
        this.checkClient();
        this.packetType = MultitoolPacketType.SERVER_TARGET_REFRESH;
        this.sendPacketUpdate(false);
    }

    public void requestTargetRecheck() {
        this.checkServer();
        this.packetType = MultitoolPacketType.SERVER_TARGET_RECHECK;
        this.sendPacketUpdate(false);
    }

    public void sendTargetRecheck() {
        this.checkClient();
        this.packetType = MultitoolPacketType.SERVER_TARGET_RECHECK;
        this.sendPacketUpdate(false);
    }

    private void checkClient() {
        if (!this.event.level.isClient()) {
            throw new IllegalStateException("Client method called from server side!");
        }
    }

    private void checkServer() {
        if (!this.event.level.isServer()) {
            throw new IllegalStateException("Server method called from client side!");
        }
    }

    protected void setupClientUpdatePacket(PlayerMob player, PacketWriter writer) {
        writer.putNextEnum((Enum)this.packetType);
        switch (this.packetType) {
            case CLIENT_TARGET_UPDATE: {
                writer.putNextInt(this.tileX);
                writer.putNextInt(this.tileY);
                writer.putNextInt(this.targetsHash);
                break;
            }
            case SERVER_TARGET_REFRESH: {
                if (!this.event.level.isClient()) break;
                this.event.writeTargetsToPacket(writer);
                break;
            }
            case SERVER_TARGET_RECHECK: {
                if (!this.event.level.isClient()) break;
                this.event.checkAndWriteTargetsToPacket(writer);
            }
        }
        this.packetType = MultitoolPacketType.NULL;
    }

    public void onUpdatePacket(PacketReader reader) {
        MultitoolPacketType incomingType = (MultitoolPacketType)reader.getNextEnum(MultitoolPacketType.class);
        switch (incomingType) {
            case CLIENT_TARGET_UPDATE: {
                this.tileX = reader.getNextInt();
                this.tileY = reader.getNextInt();
                this.targetsHash = reader.getNextInt();
                this.event.onTargetUpdate(this.tileX, this.tileY, this.targetsHash);
                break;
            }
            case SERVER_TARGET_REFRESH: {
                if (this.event.level.isClient()) {
                    this.sendTargetRefresh();
                    break;
                }
                if (!this.event.level.isServer()) break;
                this.event.readTargetsFromPacket(reader);
                break;
            }
            case SERVER_TARGET_RECHECK: {
                if (this.event.level.isClient()) {
                    this.sendTargetRecheck();
                    break;
                }
                if (!this.event.level.isServer()) break;
                this.event.readTargetsFromPacket(reader);
            }
        }
    }

    public void onUpdate() {
        int attackX = this.event.levelX;
        int attackY = this.event.levelY;
        if (this.animCounter >= this.animAttacks) {
            this.attackerMob.showAttack(attackX, attackY, this.seed, true);
            this.animCounter = 0;
        }
        ++this.animCounter;
    }

    public void onEndAttack(boolean bySelf) {
        this.event.over();
    }

    public static enum MultitoolPacketType {
        NULL,
        CLIENT_TARGET_UPDATE,
        SERVER_TARGET_REFRESH,
        SERVER_TARGET_RECHECK;

    }
}

