/*
 * Decompiled with CFR 0.152.
 */
package multitools.items;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import multitools.MultiTools;
import multitools.Util;
import multitools.items.planner.PlannerLevelEvent;
import multitools.ui.PlannerSidebarForm;
import necesse.engine.input.Input;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameColor;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.forms.presets.sidebar.SidebarForm;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlaceableItemInterface;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.container.item.ItemInventoryContainer;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.miscItem.InternalInventoryItemInterface;
import necesse.inventory.item.miscItem.PouchItem;
import necesse.inventory.item.placeableItem.PlaceableItem;
import necesse.inventory.item.placeableItem.consumableItem.ConsumableItem;
import necesse.inventory.item.placeableItem.fishingRodItem.FishingRodItem;
import necesse.inventory.item.placeableItem.followerSummonItem.FollowerSummonPlaceableItem;
import necesse.inventory.item.placeableItem.mapItem.MapItem;
import necesse.inventory.item.placeableItem.objectItem.ObjectItem;
import necesse.level.maps.Level;

public class PlannerItem
extends PouchItem
implements PlaceableItemInterface {
    public static final List<Point> PREVIEWS = new ArrayList<Point>();

    public PlannerItem() {
        this.rarity = Item.Rarity.RARE;
        this.combinePurposes.clear();
        this.insertPurposes.clear();
        this.drawStoredItems = true;
        this.attackAnimTime.setBaseValue(250);
    }

    public void loadTextures() {
        super.loadTextures();
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"rclickinvopentip"));
        this.acceptItemPair(item, (invItem, i) -> tooltips.add((Object)new StringTooltips(i.getDisplayName(invItem), i.getRarityColor(invItem))));
        if (!Input.isFunctionKey((int)340) && !Input.isFunctionKey((int)344)) {
            tooltips.add((Object)new StringTooltips(Localization.translate((String)"ui", (String)"shiftmoreinfo"), GameColor.LIGHT_GRAY));
        } else {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"drs_planner_tip1"));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"drs_planner_tip2"));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"drs_planner_tip3"));
        }
        return tooltips;
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
        this.acceptItemPair(item, (invItem, i) -> {
            i.draw(invItem, perspective, x, y, inInventory);
            this.drawStoredItems = invItem.getAmount() > 1;
        });
        if (!this.getCurrentInventoryItem(item).isPresent()) {
            this.drawStoredItems = false;
        }
    }

    public SidebarForm getSidebar(InventoryItem item) {
        return new PlannerSidebarForm(item);
    }

    public Optional<PlaceableItem> getCurrentItem(InventoryItem item) {
        return this.getCurrentInventoryItem(item).map(invItem -> (PlaceableItem)invItem.item);
    }

    public <T> T applyItemPair(InventoryItem item, BiFunction<InventoryItem, PlaceableItem, T> fn) {
        return this.getCurrentInventoryItem(item).map(invItem -> fn.apply((InventoryItem)invItem, (PlaceableItem)invItem.item)).orElse(null);
    }

    public void acceptItemPair(InventoryItem item, BiConsumer<InventoryItem, PlaceableItem> fn) {
        this.getCurrentInventoryItem(item).ifPresent(invItem -> fn.accept((InventoryItem)invItem, (PlaceableItem)invItem.item));
    }

    public Optional<InventoryItem> getCurrentInventoryItem(InventoryItem item) {
        if (!(item.item instanceof PlannerItem)) {
            return Optional.empty();
        }
        Inventory inventory = this.getInternalInventory(item);
        return Optional.ofNullable(inventory.getItem(0)).filter(invItem -> this.isValidRequestItem(invItem.item));
    }

    protected void openContainer(ServerClient client, int slotIndex) {
        PacketOpenContainer p = new PacketOpenContainer(MultiTools.plannerContainer, ItemInventoryContainer.getContainerContent((InternalInventoryItemInterface)this, (PlayerInventorySlot)new PlayerInventorySlot(slotIndex, 0)));
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)p);
    }

    public boolean isValidPouchItem(InventoryItem item) {
        return this.isValidRequestItem(item.item);
    }

    public boolean isValidRequestItem(Item item) {
        return item instanceof PlaceableItem && !(item instanceof ConsumableItem) && !(item instanceof FishingRodItem) && !(item instanceof FollowerSummonPlaceableItem) && !(item instanceof MapItem) && (!(item instanceof ObjectItem) || ((ObjectItem)item).getObject().getMultiTile((int)0).width == 1 && ((ObjectItem)item).getObject().getMultiTile((int)0).height == 1);
    }

    public boolean isValidRequestType(Item.Type type) {
        return false;
    }

    public int getInternalInventorySize() {
        return 1;
    }

    public boolean canQuickStackInventory() {
        return true;
    }

    public boolean canRestockInventory() {
        return false;
    }

    public boolean canSortInventory() {
        return false;
    }

    public void updatePlannerEvent(InventoryItem item, PlayerMob player) {
        boolean hasFirst = item.getGndData().getItem("p1") instanceof GNDItemMap;
        boolean hasSecond = item.getGndData().getItem("p2") instanceof GNDItemMap;
        boolean hasAlt = this.getCurrentInventoryItem(item).map(i -> i.item instanceof ItemInteractAction).orElse(false);
        if (!hasAlt) {
            item.getGndData().setBoolean("usealt", false);
        }
        PlannerSidebarForm.updateState(hasFirst, hasSecond, hasAlt);
        Level level = player.getLevel();
        GNDItem fromLevel = item.getGndData().getItem("level");
        if (fromLevel != null && level.getIdentifier().toString().equals(fromLevel.toString())) {
            if (hasFirst) {
                if (player.getLevel().isClient() ? PlannerLevelEvent.activeOnClient : PlannerLevelEvent.activeOnServer) {
                    return;
                }
                level.entityManager.events.addHidden((LevelEvent)new PlannerLevelEvent(player, item));
            }
        } else {
            item.getGndData().setString("level", level.getIdentifier().toString());
            item.getGndData().setItem("p1", null);
            item.getGndData().setItem("p2", null);
            item.getGndData().setInt("dir", 0);
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        if (this.getCurrentInventoryItem(item).isPresent()) {
            boolean hasFirst = item.getGndData().getItem("p1") instanceof GNDItemMap;
            boolean hasSecond = item.getGndData().getItem("p2") instanceof GNDItemMap;
            if (!hasFirst) {
                int tileX = GameMath.getTileCoordinate((int)x);
                int tileY = GameMath.getTileCoordinate((int)y);
                item.getGndData().setItem("p1", (GNDItem)new GNDItemMap().setInt("x", tileX).setInt("y", tileY));
                item.getGndData().setItem("p2", null);
                item.getGndData().setInt("dir", 0);
            } else if (!hasSecond) {
                item.getGndData().setItem("p2", (GNDItem)new GNDItemMap().setInt("x", GameMath.getTileCoordinate((int)x)).setInt("y", GameMath.getTileCoordinate((int)y)));
                int dir = 0;
                if (attackerMob instanceof PlayerMob) {
                    dir = attackerMob.getDir();
                }
                item.getGndData().setInt("dir", 0x1000 | dir);
            } else {
                item.getGndData().setItem("p1", null);
                item.getGndData().setItem("p2", null);
                item.getGndData().setInt("dir", 0);
                PREVIEWS.clear();
                if (level.isClient()) {
                    PlannerLevelEvent.activeOnClient = false;
                    level.entityManager.events.stream().filter(e -> e instanceof PlannerLevelEvent && !e.isOver()).forEach(LevelEvent::over);
                } else {
                    PlannerLevelEvent.activeOnServer = false;
                    level.entityManager.events.stream().filter(e -> e instanceof PlannerLevelEvent && !e.isOver()).forEach(LevelEvent::over);
                }
            }
        }
        if (attackerMob instanceof PlayerMob) {
            this.updatePlannerEvent(item, (PlayerMob)attackerMob);
        }
        return item;
    }

    public boolean getConstantUse(InventoryItem item) {
        return false;
    }

    public void tickHolding(InventoryItem item, PlayerMob player) {
        if (!this.getCurrentInventoryItem(item).isPresent()) {
            item.getGndData().setItem("p1", null);
            item.getGndData().setItem("p2", null);
            item.getGndData().setInt("dir", 0);
            this.updatePlannerEvent(item, player);
        }
    }

    public void drawPlacePreview(Level level, int x, int y, GameCamera camera, PlayerMob player, InventoryItem item, PlayerInventorySlot slot) {
        Util.runWithModifierChange(player.buffManager, BuffModifiers.BUILD_RANGE, Float.valueOf(1000.0f), () -> {
            if (PREVIEWS.isEmpty()) {
                this.acceptItemPair(item, (invItem, i) -> i.drawPlacePreview(level, x, y, camera, player, invItem, slot));
            }
            int newDir = item.getGndData().getInt("dir", 0);
            Util.runWithDirChange(player, newDir, () -> {
                for (Point p : new ArrayList<Point>(PREVIEWS)) {
                    int drawX = camera.getDrawX(p.x);
                    int drawY = camera.getDrawY(p.y);
                    if (drawX < -32 || drawX > camera.getWidth() + 32 || drawY < -32 || drawY > camera.getHeight() + 32) continue;
                    this.acceptItemPair(item, (invItem, i) -> i.drawPlacePreview(level, p.x, p.y, camera, player, invItem, slot));
                }
            });
        });
    }
}

