/*
 * Decompiled with CFR 0.152.
 */
package multitools.items;

import java.awt.geom.Line2D;
import multitools.ObjectCategories;
import multitools.TileCategories;
import multitools.items.multitool.MultitoolAttackHandler;
import multitools.ui.MultitoolSidebarForm;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.forms.presets.sidebar.SidebarForm;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.MultiToolItem;
import necesse.inventory.item.toolItem.ToolType;
import necesse.level.maps.Level;

public class MultitoolToolItem
extends MultiToolItem {
    protected int maxTargets;
    protected int maxMining;
    protected float targetRangeFactor;

    public MultitoolToolItem(int animSpeed, int toolDps, int toolTier, int attackDmg, int attackRange, int knockback, int enchantCost, Item.Rarity rarity, int addedRange, int maxTargets, int maxMining, float targetRangeFactor) {
        super(enchantCost);
        this.attackAnimTime.setBaseValue(animSpeed);
        this.toolDps.setBaseValue(toolDps);
        this.toolTier.setBaseValue((float)toolTier);
        this.attackDamage.setBaseValue((float)attackDmg);
        this.attackRange.setBaseValue(attackRange);
        this.knockback.setBaseValue(knockback);
        this.addedRange = addedRange;
        this.maxTargets = maxTargets;
        this.maxMining = maxMining;
        this.targetRangeFactor = targetRangeFactor;
        this.rarity = rarity;
        this.toolType = ToolType.ALL;
        this.hungerUsage = 0.001f;
        this.animAttacks = 2;
    }

    public MultitoolToolItem(int animSpeed, int toolDps, int toolTier, int attackDmg, int attackRange, int knockback, int enchantCost) {
        this(animSpeed, toolDps, toolTier, attackDmg, attackRange, knockback, enchantCost, Item.Rarity.COMMON, 0, 10, 5, 2.0f);
        this.animAttacks = 2;
    }

    public SidebarForm getSidebar(InventoryItem item) {
        return new MultitoolSidebarForm(item, MultitoolToolItem.getCategoryFilter(item));
    }

    public int getMaxMining() {
        return this.maxMining;
    }

    public int getMaxTargets() {
        return this.maxTargets;
    }

    public float getTargetRangeFactor() {
        return this.targetRangeFactor;
    }

    public static GNDItemMap getCategoryFilter(InventoryItem item) {
        GNDItem gndItem = item.getGndData().getItem("filter");
        if (gndItem instanceof GNDItemMap) {
            return (GNDItemMap)gndItem;
        }
        GNDItemMap gndMap = new GNDItemMap();
        gndMap.setBoolean(ObjectCategories.ORDERING[0], true);
        item.getGndData().setItem("filter", (GNDItem)gndMap);
        return gndMap;
    }

    public static boolean isInCategory(Level level, int tileX, int tileY, String cat) {
        if (level.getObjectID(tileX, tileY) != 0) {
            return cat.equals(ObjectCategories.findCategory(level.getObject(tileX, tileY).getStringID()));
        }
        return level.getTileID(tileX, tileY) != 0 && cat.equals(TileCategories.findCategory(level.getTile(tileX, tileY).getStringID()));
    }

    public boolean canDamageTile(Level level, int layerID, int tileX, int tileY, ItemAttackerMob attackerMob, InventoryItem item) {
        PlayerMob player;
        PlayerMob playerMob = player = attackerMob instanceof PlayerMob ? (PlayerMob)attackerMob : null;
        if (player == null) {
            return true;
        }
        int objectId = level.getObjectID(tileX, tileY);
        int tileId = level.getTileID(tileX, tileY);
        if (objectId != 0) {
            String sid = level.getObject(tileX, tileY).getStringID();
            String cat = ObjectCategories.findCategory(sid);
            return cat != null && MultitoolToolItem.getCategoryFilter(item).getBoolean(cat);
        }
        if (tileId == 0) {
            return false;
        }
        String tid = level.getTile(tileX, tileY).getStringID();
        String cat = TileCategories.findCategory(tid);
        return cat != null && MultitoolToolItem.getCategoryFilter(item).getBoolean(cat);
    }

    public boolean canSmartMineTile(Level level, int tileX, int tileY, PlayerMob player, InventoryItem item) {
        if (!this.canDamageTile(level, 0, tileX, tileY, (ItemAttackerMob)player, item)) {
            return false;
        }
        AttackHandler currentAttackHandler = player.getAttackHandler();
        return !(currentAttackHandler instanceof MultitoolAttackHandler) || ((MultitoolAttackHandler)currentAttackHandler).event.canSmartMine(tileX, tileY);
    }

    public InventoryItem runLevelDamage(Level level, int levelX, int levelY, int priorityObjectLayerID, int tileX, int tileY, PlayerMob player, Line2D playerPositionLine, InventoryItem item, int animAttack, GNDItemMap mapContent) {
        return super.runLevelDamage(level, levelX, levelY, priorityObjectLayerID, tileX, tileY, player, playerPositionLine, item, animAttack, mapContent);
    }

    public void runTileDamage(Level level, int levelX, int levelY, int priorityObjectLayerID, int tileX, int tileY, PlayerMob player, InventoryItem item, int damage) {
        super.runTileDamage(level, levelX, levelY, priorityObjectLayerID, tileX, tileY, player, item, damage);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        if (attackerMob instanceof PlayerMob) {
            PlayerMob player = (PlayerMob)attackerMob;
            int animSpeed = this.getAttackAnimTime(item, (ItemAttackerMob)player);
            if (!(player.getAttackHandler() instanceof MultitoolAttackHandler)) {
                player.startAttackHandler((AttackHandler)new MultitoolAttackHandler(player, slot, item, x, y, this.animAttacks, animSpeed, seed));
            }
            return item;
        }
        return item;
    }
}

