/*
 * Decompiled with CFR 0.152.
 */
package multitools;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import necesse.engine.GameLog;
import necesse.level.gameTile.ChromaKeyTile;
import necesse.level.gameTile.DungeonFloorTile;
import necesse.level.gameTile.EdgedTiledTexture;
import necesse.level.gameTile.FarmlandTile;
import necesse.level.gameTile.GameTile;
import necesse.level.gameTile.LiquidTile;
import necesse.level.gameTile.SandBrickTile;
import necesse.level.gameTile.SimpleFloorTile;
import necesse.level.gameTile.SimpleTiledFloorTile;
import necesse.level.gameTile.TerrainSplatterTile;

public class TileCategories {
    public static final String EXCLUDED_TAG = "EXCLUDED";
    public static final String[] ORDERING = new String[]{"flooring", "terrain"};
    public static final Map<String, Set<String>> COMPUTED = new LinkedHashMap<String, Set<String>>();

    public static String findCategory(String tileId) {
        for (String cat : ORDERING) {
            if (!COMPUTED.containsKey(cat) || !COMPUTED.get(cat).contains(tileId)) continue;
            return cat;
        }
        return null;
    }

    public static void categorize(GameTile tile) {
        String[] cat;
        if (tile.canBeMined && !(tile instanceof LiquidTile)) {
            if (!(tile instanceof EdgedTiledTexture || tile instanceof FarmlandTile || tile instanceof DungeonFloorTile || tile instanceof SandBrickTile || tile instanceof SimpleFloorTile || tile instanceof SimpleTiledFloorTile || tile instanceof ChromaKeyTile)) {
                if (!(tile instanceof TerrainSplatterTile)) {
                    GameLog.warn.printf("Uncategorized object %s of type %s\n", tile.getDisplayName(), tile.getClass());
                }
                cat = TileCategories.CAT("terrain");
            } else {
                cat = TileCategories.CAT("flooring");
            }
        } else {
            cat = TileCategories.CAT(EXCLUDED_TAG);
        }
        if (!EXCLUDED_TAG.equals(cat[0]) && COMPUTED.containsKey(cat[cat.length - 1])) {
            COMPUTED.get(cat[cat.length - 1]).add(tile.getStringID());
        }
    }

    private static String[] CAT(String ... cats) {
        if (cats.length == 0) {
            throw new IllegalArgumentException("Categories must not be blank.");
        }
        return cats;
    }

    static {
        for (String s : ORDERING) {
            COMPUTED.computeIfAbsent(s, k -> ConcurrentHashMap.newKeySet());
        }
    }
}

