/*
 * Decompiled with CFR 0.152.
 */
package multitools;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import necesse.engine.GameLog;
import necesse.inventory.item.toolItem.ToolType;
import necesse.level.gameObject.AirObject;
import necesse.level.gameObject.AncientMummyStatueObject;
import necesse.level.gameObject.AncientPillarObject;
import necesse.level.gameObject.AncientTotemObject;
import necesse.level.gameObject.ArcanicMachinery;
import necesse.level.gameObject.BannerObject;
import necesse.level.gameObject.BannerOfPeaceObject;
import necesse.level.gameObject.BannerOfWarObject;
import necesse.level.gameObject.BeeHiveObject;
import necesse.level.gameObject.BeetCaveCropplerObject;
import necesse.level.gameObject.BigTentObject;
import necesse.level.gameObject.BlacksmithStatueObject;
import necesse.level.gameObject.BloodStainsObject;
import necesse.level.gameObject.BoneSpikeWallObject;
import necesse.level.gameObject.BounceGlyphTrapObject;
import necesse.level.gameObject.BrazierObject;
import necesse.level.gameObject.CandlePedestalObject;
import necesse.level.gameObject.ChallengersBannerObject;
import necesse.level.gameObject.ChickenGlyphTrapObject;
import necesse.level.gameObject.ChieftainBoneSpikeWallObject;
import necesse.level.gameObject.CoinPileObject;
import necesse.level.gameObject.ColumnObject;
import necesse.level.gameObject.CowSkeletonObject;
import necesse.level.gameObject.CrystalClusterObject;
import necesse.level.gameObject.CrystalClusterSmallObject;
import necesse.level.gameObject.CustomWildFlowerObject;
import necesse.level.gameObject.DiningSetTableDecorationObject;
import necesse.level.gameObject.DoorObject;
import necesse.level.gameObject.EggNestObject;
import necesse.level.gameObject.EmptyRavenNestObject;
import necesse.level.gameObject.FallenAltarObject;
import necesse.level.gameObject.FallenIcicleObject;
import necesse.level.gameObject.FenceObject;
import necesse.level.gameObject.FireChaliceObject;
import necesse.level.gameObject.FlowerPatchObject;
import necesse.level.gameObject.FlowerPotObject;
import necesse.level.gameObject.ForestryJobObject;
import necesse.level.gameObject.FountainObject;
import necesse.level.gameObject.FruitBushObject;
import necesse.level.gameObject.FruitTreeObject;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.GrassObject;
import necesse.level.gameObject.GravestoneObject;
import necesse.level.gameObject.HangingDecorationObject;
import necesse.level.gameObject.HomestoneObject;
import necesse.level.gameObject.KatanaStoneObject;
import necesse.level.gameObject.KegObject;
import necesse.level.gameObject.LEDPanelObject;
import necesse.level.gameObject.LadderDownObject;
import necesse.level.gameObject.LargePaintingObject;
import necesse.level.gameObject.LargeTableDecorationObject;
import necesse.level.gameObject.LeafPileObject;
import necesse.level.gameObject.MaskedPressurePlateObject;
import necesse.level.gameObject.MinecartTrackObject;
import necesse.level.gameObject.MissionBoardObject;
import necesse.level.gameObject.PaintingObject;
import necesse.level.gameObject.PearlescentShardObject;
import necesse.level.gameObject.PicnicBlanketObject;
import necesse.level.gameObject.PigStatueObject;
import necesse.level.gameObject.PressurePlateObject;
import necesse.level.gameObject.RandomBreakObject;
import necesse.level.gameObject.RavenEffigyObject;
import necesse.level.gameObject.RavenNestWithEggObject;
import necesse.level.gameObject.RavenSkullObject;
import necesse.level.gameObject.ReverseDamageGlyphTrapObject;
import necesse.level.gameObject.RockObject;
import necesse.level.gameObject.RockOreObject;
import necesse.level.gameObject.RoyalEggObject;
import necesse.level.gameObject.RunicBoulderObject;
import necesse.level.gameObject.SaplingObject;
import necesse.level.gameObject.SeedObject;
import necesse.level.gameObject.SettlementFlagObject;
import necesse.level.gameObject.SignObject;
import necesse.level.gameObject.SingleOreRockSmall;
import necesse.level.gameObject.SingleRockObject;
import necesse.level.gameObject.SingleRockSmall;
import necesse.level.gameObject.SinkObject;
import necesse.level.gameObject.SmallRuneStoneObject;
import necesse.level.gameObject.SnowPileObject;
import necesse.level.gameObject.SpiderEggObject;
import necesse.level.gameObject.SpiderThroneObject;
import necesse.level.gameObject.SpideriteArmorStandObject;
import necesse.level.gameObject.SpikeTrapObject;
import necesse.level.gameObject.StatueObject;
import necesse.level.gameObject.SteppingStonesObject;
import necesse.level.gameObject.StreetlampObject;
import necesse.level.gameObject.SwampRootObject;
import necesse.level.gameObject.SwitchObject;
import necesse.level.gameObject.TNTObject;
import necesse.level.gameObject.TableDecorationObject;
import necesse.level.gameObject.TeleportationStoneObject;
import necesse.level.gameObject.TikiTorchObject;
import necesse.level.gameObject.TileClutterObject;
import necesse.level.gameObject.TorchObject;
import necesse.level.gameObject.TrainingDummyObject;
import necesse.level.gameObject.TrapObject;
import necesse.level.gameObject.TravelstoneObject;
import necesse.level.gameObject.VoidVesselObject;
import necesse.level.gameObject.WallObject;
import necesse.level.gameObject.WallTorchObject;
import necesse.level.gameObject.WallTrapObject;
import necesse.level.gameObject.WallWindowPlaceObject;
import necesse.level.gameObject.WaystoneObject;
import necesse.level.gameObject.WitchStatueObject;
import necesse.level.gameObject.container.ApiaryObject;
import necesse.level.gameObject.container.BannerStandObject;
import necesse.level.gameObject.container.CampfireObject;
import necesse.level.gameObject.container.CartographerTableObject;
import necesse.level.gameObject.container.CoffinObject;
import necesse.level.gameObject.container.FeedingTroughObject;
import necesse.level.gameObject.container.FireworkDispenserObject;
import necesse.level.gameObject.container.IncineratorInventoryObject;
import necesse.level.gameObject.container.InventoryObject;
import necesse.level.gameObject.container.SalvageStationObject;
import necesse.level.gameObject.container.ShippingChestObject;
import necesse.level.gameObject.container.UpgradeStationObject;
import necesse.level.gameObject.furniture.RoomFurniture;
import necesse.level.maps.levelData.settlementData.SettlementWorkstationObject;
import necesse.level.maps.multiTile.MultiTile;
import necesse.level.maps.multiTile.StaticMultiTile;

public class ObjectCategories {
    public static final String EXCLUDED_TAG = "EXCLUDED";
    public static final String[] ORDERING = new String[]{"ore", "walls", "harvestable", "crafting", "storage", "objects", "transport", "wiring", "clutter"};
    public static final Map<String, Set<String>> COMPUTED = new LinkedHashMap<String, Set<String>>();

    public static String findCategory(String objectId) {
        for (String cat : ORDERING) {
            if (!COMPUTED.containsKey(cat) || !COMPUTED.get(cat).contains(objectId)) continue;
            return cat;
        }
        return null;
    }

    public static void categorize(GameObject object) {
        String[] cat;
        MultiTile mt = object.getMultiTile(0);
        if (!(object.toolType == ToolType.UNBREAKABLE || !mt.isMaster || mt instanceof StaticMultiTile && mt.ids[0] != object.getID() || object instanceof AirObject)) {
            if (object.getClass().getName().equals("necesse.level.gameObject.LadderUpObject")) {
                cat = ObjectCategories.CAT("transport");
            } else if (object instanceof CartographerTableObject || object instanceof IncineratorInventoryObject || object instanceof UpgradeStationObject || object instanceof SalvageStationObject) {
                cat = ObjectCategories.CAT("crafting");
            } else if (object instanceof ShippingChestObject) {
                cat = ObjectCategories.CAT("storage");
            } else if (!(object instanceof AncientTotemObject || object instanceof RoyalEggObject || object instanceof VoidVesselObject)) {
                if (!(object instanceof GrassObject || object instanceof CoinPileObject || object instanceof SnowPileObject || object instanceof SingleRockObject || object instanceof SingleRockSmall || object instanceof SingleOreRockSmall || object instanceof CrystalClusterSmallObject || object instanceof PearlescentShardObject || object instanceof TileClutterObject || object instanceof SwampRootObject || object instanceof CowSkeletonObject || object instanceof FlowerPatchObject || object instanceof LeafPileObject || object instanceof KatanaStoneObject)) {
                    if (!(object instanceof GravestoneObject || object instanceof CoffinObject || object instanceof RandomBreakObject || object instanceof BloodStainsObject)) {
                        if (!(object instanceof BannerStandObject || object instanceof CampfireObject || object instanceof ColumnObject || object instanceof FeedingTroughObject || object instanceof FireChaliceObject || object instanceof SettlementFlagObject || object instanceof SignObject || object instanceof TorchObject || object instanceof WallTorchObject || object instanceof TrainingDummyObject || object instanceof StreetlampObject || object instanceof CandlePedestalObject || object instanceof TikiTorchObject || object instanceof BrazierObject || object instanceof PaintingObject || object instanceof LargePaintingObject || object instanceof StatueObject || object instanceof AncientPillarObject || object instanceof AncientMummyStatueObject || object instanceof RavenEffigyObject || object instanceof PigStatueObject || object instanceof BlacksmithStatueObject || object instanceof WitchStatueObject || object instanceof SpiderEggObject || object instanceof FountainObject || object instanceof BeetCaveCropplerObject || object instanceof BigTentObject || object instanceof PicnicBlanketObject || object instanceof SteppingStonesObject || object instanceof SpideriteArmorStandObject || object instanceof EmptyRavenNestObject || object instanceof RavenNestWithEggObject || object instanceof RavenSkullObject || object instanceof ArcanicMachinery || object instanceof SinkObject || object instanceof KegObject || object instanceof TableDecorationObject || object instanceof DiningSetTableDecorationObject || object instanceof HangingDecorationObject || object instanceof LargeTableDecorationObject || object instanceof ChickenGlyphTrapObject || object instanceof BounceGlyphTrapObject || object instanceof ReverseDamageGlyphTrapObject || object instanceof EggNestObject || object instanceof FallenAltarObject || object instanceof SpiderThroneObject || object instanceof RunicBoulderObject || object instanceof SmallRuneStoneObject || object instanceof ChieftainBoneSpikeWallObject || object instanceof BoneSpikeWallObject || object instanceof BannerOfPeaceObject || object instanceof BannerOfWarObject || object instanceof ChallengersBannerObject || object instanceof TeleportationStoneObject || object instanceof MissionBoardObject || object instanceof FallenIcicleObject || object instanceof BannerObject)) {
                            if (!(object instanceof HomestoneObject || object instanceof WaystoneObject || object instanceof LadderDownObject || object instanceof MinecartTrackObject || object instanceof TravelstoneObject)) {
                                if (object instanceof InventoryObject) {
                                    cat = ObjectCategories.CAT("storage");
                                } else if (object instanceof SettlementWorkstationObject) {
                                    cat = ObjectCategories.CAT("crafting");
                                } else if (object instanceof RockOreObject || object instanceof CrystalClusterObject) {
                                    cat = ObjectCategories.CAT("ore");
                                } else if (!(object instanceof RockObject || object instanceof WallObject || object instanceof DoorObject || object instanceof FenceObject || object instanceof WallWindowPlaceObject)) {
                                    if (!(object instanceof RoomFurniture) && !(object instanceof FlowerPotObject)) {
                                        if (!(object instanceof FruitBushObject || object instanceof FruitTreeObject || object instanceof BeeHiveObject || object instanceof ApiaryObject)) {
                                            if (!(object instanceof ForestryJobObject) && !(object instanceof SaplingObject)) {
                                                if (!(object instanceof CustomWildFlowerObject) && !(object instanceof SeedObject)) {
                                                    if (!(object instanceof FireworkDispenserObject || object instanceof LEDPanelObject || object instanceof MaskedPressurePlateObject || object instanceof PressurePlateObject || object instanceof SpikeTrapObject || object instanceof SwitchObject || object instanceof TNTObject || object instanceof TrapObject || object instanceof WallTrapObject)) {
                                                        GameLog.warn.printf("Uncategorized object %s of type %s\n", object.getDisplayName(), object.getClass());
                                                        return;
                                                    }
                                                    cat = ObjectCategories.CAT("wiring");
                                                } else {
                                                    cat = ObjectCategories.CAT("harvestable");
                                                }
                                            } else {
                                                cat = ObjectCategories.CAT("harvestable");
                                            }
                                        } else {
                                            cat = ObjectCategories.CAT("harvestable");
                                        }
                                    } else {
                                        cat = ObjectCategories.CAT("objects");
                                    }
                                } else {
                                    cat = ObjectCategories.CAT("walls");
                                }
                            } else {
                                cat = ObjectCategories.CAT("transport");
                            }
                        } else {
                            cat = ObjectCategories.CAT("objects");
                        }
                    } else {
                        cat = ObjectCategories.CAT("clutter");
                    }
                } else {
                    cat = ObjectCategories.CAT("clutter");
                }
            } else {
                cat = ObjectCategories.CAT(EXCLUDED_TAG);
            }
        } else {
            cat = ObjectCategories.CAT(EXCLUDED_TAG);
        }
        if (!EXCLUDED_TAG.equals(cat[0]) && COMPUTED.containsKey(cat[cat.length - 1])) {
            COMPUTED.get(cat[cat.length - 1]).add(object.getStringID());
        }
    }

    private static String[] CAT(String ... cats) {
        if (cats.length == 0) {
            throw new IllegalArgumentException("Categories must not be blank.");
        }
        return cats;
    }

    static {
        for (String s : ORDERING) {
            COMPUTED.computeIfAbsent(s, k -> ConcurrentHashMap.newKeySet());
        }
    }
}

