/*
 * Decompiled with CFR 0.152.
 */
package multitools;

import multitools.ObjectCategories;
import multitools.TileCategories;
import multitools.items.MultitoolToolItem;
import multitools.items.PlannerItem;
import multitools.packet.PacketUpdateGNDData;
import multitools.ui.PlannerContainerForm;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.PacketRegistry;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.gfx.forms.presets.containerComponent.item.ItemInventoryContainerForm;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.container.item.ItemInventoryContainer;
import necesse.inventory.item.Item;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;

@ModEntry
public class MultiTools {
    public static GameTexture aimTexture;
    public static GameTexture targetTexture;
    public static GameTexture blueAimTexture;
    public static GameTexture blueTargetTexture;
    public static GameTexture greenAimTexture;
    public static GameTexture greenTargetTexture;
    public static int plannerContainer;

    public void init() {
        plannerContainer = Containers.registerContainer(PlannerContainerForm::new, ItemInventoryContainer::new);
        PacketRegistry.registerPacket(PacketUpdateGNDData.class);
        ItemRegistry.registerItem((String)"drs_planner", (Item)new PlannerItem(), (float)5.0f, (boolean)true);
        this.registerPivelaxe("gold", 500, 95, 0, 16, 450, Item.Rarity.COMMON, 0, 40, 6, 2, 2.0f);
        this.registerPivelaxe("frost", 500, 110, 1, 18, 500, Item.Rarity.COMMON, 0, 60, 8, 3, 2.1f);
        this.registerPivelaxe("demonic", 500, 125, 2, 20, 600, Item.Rarity.UNCOMMON, 0, 80, 10, 4, 2.2f);
        this.registerPivelaxe("runic", 500, 140, 3, 22, 700, Item.Rarity.UNCOMMON, 0, 100, 11, 4, 2.3f);
        this.registerPivelaxe("ivy", 450, 155, 4, 24, 700, Item.Rarity.UNCOMMON, 0, 100, 12, 5, 2.5f);
        this.registerPivelaxe("quartz", 450, 170, 5, 26, 700, Item.Rarity.RARE, 1, 100, 14, 5, 2.7f);
        this.registerPivelaxe("tungsten", 400, 185, 6, 28, 800, Item.Rarity.RARE, 1, 160, 16, 6, 3.0f);
        this.registerPivelaxe("glacial", 400, 200, 7, 30, 900, Item.Rarity.EPIC, 2, 160, 24, 8, 3.5f);
        this.registerPivelaxe("dryad", 400, 215, 8, 32, 950, Item.Rarity.EPIC, 2, 160, 28, 9, 3.8f);
        this.registerPivelaxe("mycelium", 400, 230, 9, 34, 1000, Item.Rarity.EPIC, 2, 160, 32, 10, 4.0f);
        this.registerPivelaxe("ancientfossil", 400, 245, 10, 36, 1000, Item.Rarity.LEGENDARY, 3, 160, 36, 12, 4.5f);
    }

    public void initResources() {
        aimTexture = GameTexture.fromFile((String)"other/drs_aim");
        targetTexture = GameTexture.fromFile((String)"other/drs_target");
        blueAimTexture = GameTexture.fromFile((String)"other/drs_aim_blue");
        blueTargetTexture = GameTexture.fromFile((String)"other/drs_target_blue");
        greenAimTexture = GameTexture.fromFile((String)"other/drs_aim_green");
        greenTargetTexture = GameTexture.fromFile((String)"other/drs_target_green");
    }

    public void postInit() {
        ObjectRegistry.streamObjects().forEach(ObjectCategories::categorize);
        TileRegistry.streamTiles().forEach(TileCategories::categorize);
        Recipes.registerModRecipe((Recipe)new Recipe("drs_planner", 1, RecipeTechRegistry.WORKSTATION, new Ingredient[]{new Ingredient("mapfragment", 4), new Ingredient("goldbar", 1)}).showBefore("wrench"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_gold", 1, RecipeTechRegistry.IRON_ANVIL, new Ingredient[]{new Ingredient("goldpickaxe", 1), new Ingredient("goldaxe", 1), new Ingredient("goldshovel", 1)}).showAfter("goldshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_frost", 1, RecipeTechRegistry.IRON_ANVIL, new Ingredient[]{new Ingredient("frostpickaxe", 1), new Ingredient("frostaxe", 1), new Ingredient("frostshovel", 1)}).showAfter("frostshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_demonic", 1, RecipeTechRegistry.DEMONIC_ANVIL, new Ingredient[]{new Ingredient("demonicpickaxe", 1), new Ingredient("demonicaxe", 1), new Ingredient("demonicshovel", 1)}).showAfter("demonicshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_runic", 1, RecipeTechRegistry.DEMONIC_ANVIL, new Ingredient[]{new Ingredient("runicpickaxe", 1), new Ingredient("runicaxe", 1), new Ingredient("runicshovel", 1)}).showAfter("runicshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_ivy", 1, RecipeTechRegistry.DEMONIC_ANVIL, new Ingredient[]{new Ingredient("ivypickaxe", 1), new Ingredient("ivyaxe", 1), new Ingredient("ivyshovel", 1)}).showAfter("ivyshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_quartz", 1, RecipeTechRegistry.DEMONIC_ANVIL, new Ingredient[]{new Ingredient("quartzpickaxe", 1), new Ingredient("quartzaxe", 1), new Ingredient("quartzshovel", 1)}).showAfter("quartzshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_tungsten", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, new Ingredient[]{new Ingredient("tungstenpickaxe", 1), new Ingredient("tungstenaxe", 1), new Ingredient("tungstenshovel", 1)}).showAfter("tungstenshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_glacial", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, new Ingredient[]{new Ingredient("glacialpickaxe", 1), new Ingredient("glacialaxe", 1), new Ingredient("glacialshovel", 1)}).showAfter("glacialshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_dryad", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, new Ingredient[]{new Ingredient("dryadpickaxe", 1), new Ingredient("dryadaxe", 1), new Ingredient("dryadshovel", 1)}).showAfter("dryadshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_mycelium", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, new Ingredient[]{new Ingredient("myceliumpickaxe", 1), new Ingredient("myceliumaxe", 1), new Ingredient("myceliumshovel", 1)}).showAfter("myceliumshovel"));
        Recipes.registerModRecipe((Recipe)new Recipe("drs_pivelaxe_ancientfossil", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, new Ingredient[]{new Ingredient("ancientfossilpickaxe", 1), new Ingredient("ancientfossilaxe", 1), new Ingredient("ancientfossilshovel", 1)}).showAfter("ancientfossilshovel"));
    }

    private void registerPivelaxe(String kind, int animSpeed, int toolDps, int toolTier, int attackDmg, int enchantCost, Item.Rarity rarity, int addedRange, int brokerValue, int maxTargets, int maxMining, float targetRangeFactor) {
        ItemRegistry.registerItem((String)("drs_pivelaxe_" + kind), (Item)new MultitoolToolItem(animSpeed, toolDps, toolTier, attackDmg, 50, 50, enchantCost, rarity, addedRange, maxTargets, maxMining, targetRangeFactor), (float)brokerValue, (boolean)true);
    }

    private static class Containers {
        private Containers() {
        }

        private static int registerContainer(IICFormConstructor formCtor, IICConstructor containerCtor) {
            return ContainerRegistry.registerContainer((client, uniqueSeed, packet) -> formCtor.create(client, containerCtor.create(client.getClient(), uniqueSeed, packet)), (client, uniqueSeed, packet, serverObject) -> containerCtor.create(client, uniqueSeed, packet));
        }

        @FunctionalInterface
        private static interface IICFormConstructor {
            public <I extends ItemInventoryContainer> ItemInventoryContainerForm<? extends ItemInventoryContainer> create(Client var1, I var2);
        }

        @FunctionalInterface
        private static interface IICConstructor {
            public <C extends NetworkClient> ItemInventoryContainer create(C var1, int var2, Packet var3);
        }
    }
}

