/*
 * Decompiled with CFR 0.152.
 */
package rdbp.Patches.Gameplay;

import java.util.ArrayList;
import java.util.List;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.entity.mobs.friendly.human.HappinessModifier;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.level.maps.levelData.settlementData.SettlementBed;
import necesse.level.maps.levelData.settlementData.SettlementRoom;
import necesse.level.maps.levelData.settlementData.settler.DietThought;
import necesse.level.maps.levelData.settlementData.settler.FoodQuality;
import necesse.level.maps.levelData.settlementData.settler.PopulationThought;
import necesse.level.maps.levelData.settlementData.settler.RoomQuality;
import necesse.level.maps.levelData.settlementData.settler.RoomSize;
import necesse.level.maps.levelData.settlementData.settler.Settler;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=HumanMob.class, name="getHappinessModifiers", arguments={})
public class HappinessModifiersPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This HumanMob ThisSettler, @Advice.Return(readOnly=false) List<HappinessModifier> list) {
        ArrayList<HappinessModifier> Modifiers = new ArrayList<HappinessModifier>();
        if (ThisSettler.getWorldEntity() != null) {
            if (ThisSettler.lastFoodEaten != null) {
                Modifiers.add(ThisSettler.lastFoodEaten.quality.getModifier());
            } else {
                Modifiers.add(FoodQuality.noFoodModifier);
            }
            int differentFoodsEaten = (int)ThisSettler.recentFoodItemIDsEaten.stream().distinct().count();
            DietThought DietThought2 = Settler.getDietThought((int)differentFoodsEaten);
            if (DietThought2 != null) {
                Modifiers.add(DietThought2.getModifier());
            }
            if (ThisSettler.levelSettler != null) {
                SettlementBed Bed = ThisSettler.levelSettler.getBed();
                if (Bed != null) {
                    SettlementRoom Room = Bed.getRoom();
                    if (Room != null) {
                        int RoomQuality2;
                        int NumberOfOccupiedBeds = Bed.getRoom().getOccupiedBeds();
                        if (NumberOfOccupiedBeds == 2) {
                            Modifiers.add(new HappinessModifier(0, (GameMessage)new GameMessageBuilder().append("settlement", "sharingroom")));
                        } else if (NumberOfOccupiedBeds >= 3) {
                            Modifiers.add(new HappinessModifier(-10 * NumberOfOccupiedBeds, (GameMessage)new GameMessageBuilder().append("settlement", "sharingroom")));
                        }
                        int RoomSize2 = Room.getRoomSize();
                        if (RoomSize2 > 0) {
                            RoomSize Size = Settler.getRoomSize((int)RoomSize2);
                            Modifiers.add(Size.getModifier());
                        }
                        if ((RoomQuality2 = Room.getFurnitureScore()) > 0) {
                            RoomQuality Quality = Settler.getRoomQuality((int)RoomQuality2);
                            Modifiers.add(Quality.getModifier());
                        }
                        if (Room.getRoomProperty("lights") <= 0) {
                            Modifiers.add(new HappinessModifier(-10, (GameMessage)new GameMessageBuilder().append("settlement", "roommissinglights")));
                        }
                        if (Room.getRoomProperty("outsidefloor") > 0) {
                            Modifiers.add(HappinessModifier.bedOutsideModifier);
                        }
                    }
                } else {
                    Modifiers.add(HappinessModifier.noBedModifier);
                }
                PopulationThought PoulationThought = Settler.getPopulationThough((int)ThisSettler.levelSettler.data.countTotalSettlers());
                if (PoulationThought != null) {
                    Modifiers.add(PoulationThought.getModifier());
                }
            }
        }
        list = Modifiers;
    }
}

