/*
 * Decompiled with CFR 0.152.
 */
package com.largoscript.nodarkness;

import com.largoscript.nodarkness.NoDarknessMod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import necesse.engine.GlobalData;
import necesse.engine.modLoader.ModSettings;
import necesse.engine.network.client.Client;
import necesse.engine.state.MainGame;
import necesse.engine.state.State;

public class NoDarknessSettingsFactory {
    public static ModSettings createSettings() {
        try {
            return NoDarknessSettingsFactory.createCustomSettings();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            System.out.println("[NoDarkness] CustomSettingsLib not found, using standard ModSettings");
            return new NoDarknessMod.NoDarknessSettings();
        }
        catch (Exception e) {
            System.err.println("[NoDarkness] Error creating CustomSettings, using standard ModSettings: " + e.getMessage());
            return new NoDarknessMod.NoDarknessSettings();
        }
    }

    private static ModSettings createCustomSettings() throws Exception {
        Object brightnessSetting;
        Class<?> customModSettingsClass = Class.forName("customsettingslib.settings.CustomModSettings");
        Class<?> intSettingClass = Class.forName("customsettingslib.components.settings.IntSetting");
        Class<?> textSeparatorClass = Class.forName("customsettingslib.components.TextSeparator");
        Object[] customSettingsRef = new Object[1];
        Object[] brightnessSettingRef = new Object[1];
        Consumer[] updateBrightnessRef = new Consumer[]{brightnessPercent -> {
            try {
                float newBrightness;
                block8: {
                    float oldBrightness = NoDarknessMod.darknessBrightness;
                    newBrightness = (float)brightnessPercent.intValue() / 100.0f;
                    System.out.println("[NoDarkness] Settings saved: brightness=" + brightnessPercent + "% (old: " + oldBrightness * 100.0f + "%, new: " + brightnessPercent + "%)");
                    try {
                        State currentState = GlobalData.getCurrentState();
                        if (!(currentState instanceof MainGame)) break block8;
                        MainGame mainGame = (MainGame)currentState;
                        Field clientField = MainGame.class.getDeclaredField("client");
                        clientField.setAccessible(true);
                        Client client = (Client)clientField.get(mainGame);
                        if (client == null || client.chat == null) break block8;
                        try {
                            Class<?> localMessageClass = Class.forName("necesse.engine.localization.message.LocalMessage");
                            Object localMessage = localMessageClass.getConstructor(String.class, String.class, Object[].class).newInstance("chat", "brightnesschanged", new Object[]{"newValue", String.valueOf(brightnessPercent), "oldValue", String.valueOf((int)(oldBrightness * 100.0f))});
                            Method translateMethod = localMessageClass.getMethod("translate", new Class[0]);
                            String translatedText = (String)translateMethod.invoke(localMessage, new Object[0]);
                            if (translatedText != null && !translatedText.startsWith("chat.") && !translatedText.startsWith("nodarkness.")) {
                                client.chat.addMessage(translatedText);
                                break block8;
                            }
                            client.chat.addMessage("Brightness: " + brightnessPercent + "% (was: " + (int)(oldBrightness * 100.0f) + "%)");
                        }
                        catch (Exception e) {
                            client.chat.addMessage("Brightness: " + brightnessPercent + "% (was: " + (int)(oldBrightness * 100.0f) + "%)");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                NoDarknessMod.darknessBrightness = newBrightness;
                if (NoDarknessMod.listener != null) {
                    NoDarknessMod.listener.needsUpdate = true;
                    NoDarknessMod.listener.updateDarknessLighting();
                }
            }
            catch (Exception e) {
                System.err.println("[NoDarkness] Error updating brightness: " + e.getMessage());
            }
        }};
        Runnable onSaved = () -> {
            try {
                Object customSettings = customSettingsRef[0];
                int brightnessPercent = 0;
                if (brightnessSettingRef[0] != null) {
                    try {
                        Field newValueField = brightnessSettingRef[0].getClass().getDeclaredField("newValue");
                        newValueField.setAccessible(true);
                        Object newValueAtomic = newValueField.get(brightnessSettingRef[0]);
                        Method getMethod = newValueAtomic.getClass().getMethod("get", new Class[0]);
                        brightnessPercent = (Integer)getMethod.invoke(newValueAtomic, new Object[0]);
                        System.out.println("[NoDarkness] Read from newValue: " + brightnessPercent + "%");
                    }
                    catch (Exception e) {
                        System.err.println("[NoDarkness] Failed to read from newValue, will retry after save: " + e.getMessage());
                        new Thread(() -> {
                            try {
                                Thread.sleep(100L);
                                Object brightnessValue = customModSettingsClass.getMethod("getSetting", String.class).invoke(customSettings, "darknessBrightness");
                                int percent = (Integer)brightnessValue;
                                updateBrightnessRef[0].accept(percent);
                            }
                            catch (Exception ex) {
                                System.err.println("[NoDarkness] Error in delayed update: " + ex.getMessage());
                            }
                        }).start();
                        return;
                    }
                } else {
                    new Thread(() -> {
                        try {
                            Thread.sleep(100L);
                            Object brightnessValue = customModSettingsClass.getMethod("getSetting", String.class).invoke(customSettings, "darknessBrightness");
                            int percent = (Integer)brightnessValue;
                            updateBrightnessRef[0].accept(percent);
                        }
                        catch (Exception ex) {
                            System.err.println("[NoDarkness] Error in delayed update: " + ex.getMessage());
                        }
                    }).start();
                    return;
                }
                updateBrightnessRef[0].accept(brightnessPercent);
            }
            catch (Exception e) {
                System.err.println("[NoDarkness] Error in onSaved listener: " + e.getMessage());
                e.printStackTrace();
            }
        };
        Object customSettings = customModSettingsClass.getConstructor(Runnable.class).newInstance(onSaved);
        customSettingsRef[0] = customSettings;
        customModSettingsClass.getMethod("addTextSeparator", String.class).invoke(customSettings, "nodarknesssection");
        Object displayModeEnum = Class.forName("customsettingslib.components.settings.IntSetting$DisplayMode").getEnumConstants()[1];
        brightnessSettingRef[0] = brightnessSetting = customModSettingsClass.getMethod("addIntSetting", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Class.forName("customsettingslib.components.settings.IntSetting$DisplayMode"), Integer.TYPE).invoke(customSettings, "darknessBrightness", (int)(NoDarknessMod.darknessBrightness * 100.0f), 0, 100, displayModeEnum, 0);
        System.out.println("[NoDarkness] CustomSettingsLib settings created successfully!");
        return (ModSettings)customSettings;
    }
}

