/*
 * Decompiled with CFR 0.152.
 */
package com.largoscript.nodarkness;

import com.largoscript.nodarkness.NoDarknessSettingsFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import necesse.engine.GlobalData;
import necesse.engine.gameLoop.GameLoop;
import necesse.engine.gameLoop.GameLoopListener;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.input.InputEvent;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.modLoader.LoadedMod;
import necesse.engine.modLoader.ModLoader;
import necesse.engine.modLoader.ModSettings;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.network.client.Client;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.state.MainGame;
import necesse.engine.state.State;
import necesse.engine.window.GameWindow;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

@ModEntry
public class NoDarknessMod {
    public static boolean enabled = true;
    public static float darknessBrightness = 0.2f;
    static DarknessListener listener = null;
    private static boolean initialized = false;
    public static Control TOGGLE_NO_DARKNESS;
    private static Level lastLevel;
    private static NoDarknessSettings settings;
    private static PrintWriter logFile;
    private static final SimpleDateFormat dateFormat;
    private static Set<String> detectedConflictingMods;
    private static boolean conflictWarningShown;
    private static int overrideResetCount;
    private static long lastOverrideResetTime;

    private static void log(String message) {
        NoDarknessMod.log(message, false);
    }

    private static void log(String message, boolean showInChat) {
        String timestamp = dateFormat.format(new Date());
        String logMessage = "[" + timestamp + "] [NoDarkness] " + message;
        System.out.println(logMessage);
        System.err.println(logMessage);
        try {
            if (logFile == null) {
                Object appDataPath = System.getenv("APPDATA");
                if (appDataPath == null) {
                    appDataPath = System.getProperty("user.home") + File.separator + "AppData" + File.separator + "Roaming";
                }
                File logDir = new File((String)appDataPath + File.separator + "Necesse" + File.separator + "logs");
                logDir.mkdirs();
                File logFilePath = new File(logDir, "nodarkness.log");
                logFile = new PrintWriter((Writer)new FileWriter(logFilePath, true), true);
                logFile.println("=== No Darkness Mod Log Started ===");
                logFile.flush();
            }
            logFile.println(logMessage);
            logFile.flush();
        }
        catch (IOException e) {
            System.err.println("[NoDarkness] Failed to write to log file: " + e.getMessage());
        }
        if (showInChat) {
            try {
                MainGame mainGame;
                State currentState = GlobalData.getCurrentState();
                if (currentState instanceof MainGame && (mainGame = (MainGame)currentState).getClient() != null && mainGame.getClient().chat != null) {
                    String chatMessage = message.replace("[NoDarkness] ", "");
                    mainGame.getClient().chat.addMessage("[NoDarkness] " + chatMessage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void checkForConflictingMods() {
        try {
            HashSet<String> knownLightingMods = new HashSet<String>();
            knownLightingMods.add("cavebrightness");
            knownLightingMods.add("bettertorch");
            detectedConflictingMods.clear();
            for (LoadedMod mod : ModLoader.getEnabledMods()) {
                String modId = mod.id.toLowerCase();
                String modName = mod.name.toLowerCase();
                if (knownLightingMods.contains(modId)) {
                    detectedConflictingMods.add(mod.name);
                    NoDarknessMod.log("\u26a0\ufe0f Detected potentially conflicting mod by ID: " + mod.name + " (ID: " + mod.id + ")");
                }
                if (!modId.contains("light") && !modId.contains("bright") && !modId.contains("dark") && !modName.contains("light") && !modName.contains("bright") && !modName.contains("dark") || modId.equals("nodarkness")) continue;
                detectedConflictingMods.add(mod.name);
                NoDarknessMod.log("\u26a0\ufe0f Detected potentially conflicting mod by name: " + mod.name + " (ID: " + mod.id + ")");
            }
            if (!detectedConflictingMods.isEmpty()) {
                NoDarknessMod.log("\u26a0\ufe0f Found " + detectedConflictingMods.size() + " potentially conflicting mod(s) that may modify lighting", true);
                for (String modName : detectedConflictingMods) {
                    NoDarknessMod.log("   - " + modName);
                }
            }
        }
        catch (Exception e) {
            NoDarknessMod.log("Error checking for conflicting mods: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void init() {
        NoDarknessMod.log("========== Mod initialized! ==========", true);
        NoDarknessMod.checkForConflictingMods();
        try {
            TOGGLE_NO_DARKNESS = Control.addModControl((Control)new Control(76, "togglenodarkness", (GameMessage)new StaticMessage("Toggle No Darkness")).setTooltip((GameMessage)new StaticMessage("Toggle darkness removal on/off")));
            if (TOGGLE_NO_DARKNESS != null) {
                NoDarknessMod.log("\u2705 Control registered successfully: " + NoDarknessMod.TOGGLE_NO_DARKNESS.id);
                NoDarknessMod.log("Control key: " + TOGGLE_NO_DARKNESS.getKey());
            } else {
                NoDarknessMod.log("\u274c ERROR: Control.addModControl returned null!", true);
            }
        }
        catch (Exception e) {
            NoDarknessMod.log("\u274c ERROR during Control registration: " + e.getMessage(), true);
            e.printStackTrace();
            TOGGLE_NO_DARKNESS = null;
        }
    }

    public ModSettings initSettings() {
        return NoDarknessSettingsFactory.createSettings();
    }

    public void postInit() {
        NoDarknessMod.log("PostInit called");
        NoDarknessMod.syncSettingsFromCustomLib();
        NoDarknessMod.trySetupListener();
        if (!initialized) {
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    NoDarknessMod.trySetupListener();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
        }
    }

    private static void syncSettingsFromCustomLib() {
        try {
            Class<?> customModSettingsClass = Class.forName("customsettingslib.settings.CustomModSettings");
            Method getModSettingMethod = customModSettingsClass.getMethod("getModSetting", String.class, String.class);
            try {
                Object enabledValue = getModSettingMethod.invoke(null, "nodarkness", "enabled");
                if (enabledValue != null && enabledValue instanceof Boolean) {
                    enabled = (Boolean)enabledValue;
                }
            }
            catch (Exception enabledValue) {
                // empty catch block
            }
            try {
                Object brightnessValue = getModSettingMethod.invoke(null, "nodarkness", "darknessBrightness");
                if (brightnessValue != null && brightnessValue instanceof Integer) {
                    int brightnessPercent = (Integer)brightnessValue;
                    darknessBrightness = Math.max(0.0f, Math.min(1.0f, (float)brightnessPercent / 100.0f));
                }
            }
            catch (Exception e) {
                NoDarknessMod.log("Error reading brightness from CustomSettingsLib: " + e.getMessage());
            }
            NoDarknessMod.log("Synced settings from CustomSettingsLib: enabled=" + enabled + ", brightness=" + darknessBrightness * 100.0f + "%");
        }
        catch (ClassNotFoundException | NoClassDefFoundError customModSettingsClass) {
        }
        catch (NoSuchMethodException e) {
            NoDarknessMod.log("CustomSettingsLib API method not found: " + e.getMessage());
        }
        catch (Exception e) {
            NoDarknessMod.log("Error syncing from CustomSettingsLib: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void syncSettingsFromConfig() {
        block17: {
            boolean syncedFromCustomLib = false;
            try {
                Class<?> customModSettingsClass = Class.forName("customsettingslib.settings.CustomModSettings");
                Method getModSettingMethod = customModSettingsClass.getMethod("getModSetting", String.class, String.class);
                Object brightnessValue = getModSettingMethod.invoke(null, "nodarkness", "darknessBrightness");
                if (brightnessValue != null && brightnessValue instanceof Integer) {
                    int brightnessPercent = (Integer)brightnessValue;
                    float newBrightness = Math.max(0.0f, Math.min(1.0f, (float)brightnessPercent / 100.0f));
                    if (Math.abs(newBrightness - darknessBrightness) > 0.001f) {
                        NoDarknessMod.log("Syncing brightness from CustomSettingsLib: " + darknessBrightness * 100.0f + "% -> " + brightnessPercent + "%");
                        darknessBrightness = newBrightness;
                    }
                    syncedFromCustomLib = true;
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError customModSettingsClass) {
            }
            catch (Exception customModSettingsClass) {
                // empty catch block
            }
            if (!syncedFromCustomLib) {
                try {
                    Class<?> loadedModClass;
                    Class<?> modLoaderClass = Class.forName("necesse.engine.modLoader.ModLoader");
                    Method getModMethod = modLoaderClass.getMethod("getLoadedMod", String.class);
                    Object loadedMod = getModMethod.invoke(null, "nodarkness");
                    if (loadedMod == null) {
                        return;
                    }
                    Class<?> settingsClass = Class.forName("necesse.engine.Settings");
                    Method clientModDirMethod = settingsClass.getMethod("clientModDir", loadedModClass = Class.forName("necesse.engine.modLoader.LoadedMod"));
                    String modFilePath = (String)clientModDirMethod.invoke(null, loadedMod);
                    if (modFilePath == null || modFilePath.isEmpty()) {
                        return;
                    }
                    File modFile = new File(modFilePath);
                    if (!modFile.exists() || !modFile.isFile()) {
                        return;
                    }
                    if (modFile.length() == 0L) {
                        return;
                    }
                    Method getSettingsMethod = loadedMod.getClass().getMethod("getSettings", new Class[0]);
                    Object modSettings = getSettingsMethod.invoke(loadedMod, new Object[0]);
                    if (!(modSettings instanceof NoDarknessSettings)) break block17;
                    try {
                        LoadData loadData = new LoadData(modFile);
                        float oldBrightness = darknessBrightness;
                        ((NoDarknessSettings)((Object)modSettings)).applyLoadData(loadData);
                        if (Math.abs(oldBrightness - darknessBrightness) > 0.001f) {
                            NoDarknessMod.log("Synced brightness from config file: " + oldBrightness * 100.0f + "% -> " + darknessBrightness * 100.0f + "%");
                        }
                    }
                    catch (Exception loadException) {
                        NoDarknessMod.log("Error loading config file: " + loadException.getMessage());
                    }
                }
                catch (ClassNotFoundException | NoClassDefFoundError modLoaderClass) {
                }
                catch (NoSuchMethodException e) {
                    NoDarknessMod.log("API method not found (API may have changed): " + e.getMessage());
                }
                catch (Exception e) {
                    NoDarknessMod.log("Error syncing from config: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    private static void trySetupListener() {
        if (initialized) {
            return;
        }
        try {
            GameLoop gameLoop = GlobalData.getCurrentGameLoop();
            if (gameLoop != null) {
                if (listener == null) {
                    listener = new DarknessListener();
                }
                gameLoop.addGameLoopListener((GameLoopListener)listener);
                initialized = true;
                NoDarknessMod.log("\u2705 Listener initialized successfully!", true);
                NoDarknessMod.log("TOGGLE_NO_DARKNESS control: " + (String)(TOGGLE_NO_DARKNESS != null ? "OK (key=" + TOGGLE_NO_DARKNESS.getKey() + ")" : "NULL"));
            } else {
                NoDarknessMod.log("GameLoop is null, will retry later");
            }
        }
        catch (IllegalStateException e) {
            NoDarknessMod.log("GameLoop not ready yet: " + e.getMessage());
        }
        catch (Exception e) {
            NoDarknessMod.log("\u274c Error setting up listener: " + e.getMessage(), true);
            e.printStackTrace();
        }
    }

    public static void toggleEnabled() {
        enabled = !enabled;
        String statusMessage = enabled ? "Enabled" : "Disabled";
        NoDarknessMod.log(statusMessage, true);
        if (listener != null) {
            NoDarknessMod.listener.needsUpdate = true;
        }
    }

    public static void setBrightness(float brightness) {
        darknessBrightness = Math.max(0.0f, Math.min(1.0f, brightness));
        NoDarknessMod.log("Brightness set to: " + darknessBrightness * 100.0f + "%");
        if (listener != null) {
            NoDarknessMod.listener.needsUpdate = true;
        }
    }

    static {
        lastLevel = null;
        settings = new NoDarknessSettings();
        logFile = null;
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        detectedConflictingMods = new HashSet<String>();
        conflictWarningShown = false;
        overrideResetCount = 0;
        lastOverrideResetTime = 0L;
    }

    static class NoDarknessSettings
    extends ModSettings {
        NoDarknessSettings() {
        }

        public void addSaveData(SaveData saveData) {
            saveData.addFloat("darknessBrightness", darknessBrightness, "[0.0 - 1.0] Brightness level for dark areas. 0.0 = dark, 1.0 = full light. Default: 0.2 (20%)");
        }

        public void applyLoadData(LoadData loadData) {
            float loadedBrightness;
            if (loadData == null) {
                NoDarknessMod.log("LoadData is null, using default brightness");
                return;
            }
            try {
                float floatValue = loadData.getFloat("darknessBrightness", 0.2f);
                if (floatValue > 1.0f) {
                    loadedBrightness = floatValue / 100.0f;
                    NoDarknessMod.log("Loaded brightness from CustomSettingsLib (int read as float): " + (int)floatValue + "% -> " + loadedBrightness * 100.0f + "%");
                } else {
                    loadedBrightness = floatValue;
                    NoDarknessMod.log("Loaded brightness from standard config (float): " + loadedBrightness * 100.0f + "%");
                }
            }
            catch (Exception e) {
                try {
                    int brightnessPercent = loadData.getInt("darknessBrightness", 20);
                    loadedBrightness = (float)brightnessPercent / 100.0f;
                    NoDarknessMod.log("Loaded brightness from CustomSettingsLib (int): " + brightnessPercent + "%");
                }
                catch (Exception e2) {
                    NoDarknessMod.log("Error reading brightness from config, using default: " + e2.getMessage());
                    loadedBrightness = 0.2f;
                }
            }
            darknessBrightness = Math.max(0.0f, Math.min(1.0f, loadedBrightness));
            if (listener != null) {
                NoDarknessMod.listener.needsUpdate = true;
            }
        }
    }

    static class DarknessListener
    implements GameLoopListener {
        boolean needsUpdate = true;

        DarknessListener() {
        }

        public boolean isDisposed() {
            return false;
        }

        public void drawTick(TickManager tickManager) {
            block12: {
                try {
                    if (lastLevel == null || lastLevel.isServer()) {
                        return;
                    }
                    if (enabled) {
                        long currentTime;
                        GameLight currentOverride;
                        boolean isDarkArea = NoDarknessMod.lastLevel.isCave;
                        if (!isDarkArea) {
                            try {
                                Method isNightMethod;
                                Object nightResult;
                                Field worldEntityField = Level.class.getDeclaredField("worldEntity");
                                worldEntityField.setAccessible(true);
                                Object worldEntity = worldEntityField.get(lastLevel);
                                if (worldEntity != null && (nightResult = (isNightMethod = worldEntity.getClass().getMethod("isNight", new Class[0])).invoke(worldEntity, new Object[0])) instanceof Boolean) {
                                    isDarkArea = (Boolean)nightResult;
                                }
                            }
                            catch (Exception worldEntityField) {
                                // empty catch block
                            }
                        }
                        if (isDarkArea && NoDarknessMod.lastLevel.lightManager != null && (currentOverride = NoDarknessMod.lastLevel.lightManager.ambientLightOverride) == null && !this.needsUpdate && (currentTime = System.currentTimeMillis()) - lastOverrideResetTime > 1000L) {
                            lastOverrideResetTime = currentTime;
                            if (++overrideResetCount >= 3 && !conflictWarningShown) {
                                conflictWarningShown = true;
                                this.showConflictWarning();
                            }
                        }
                        if (isDarkArea && (this.needsUpdate || this.shouldReapplyOverride() || NoDarknessMod.lastLevel.lightManager.ambientLightOverride == null)) {
                            this.updateDarknessLighting();
                        }
                        break block12;
                    }
                    if (this.needsUpdate) {
                        this.updateDarknessLighting();
                    }
                }
                catch (Exception e) {
                    NoDarknessMod.log("\u274c Error in drawTick: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }

        private void showConflictWarning() {
            block7: {
                try {
                    MainGame mainGame;
                    State currentState = GlobalData.getCurrentState();
                    if (!(currentState instanceof MainGame) || (mainGame = (MainGame)currentState).getClient() == null || mainGame.getClient().chat == null) break block7;
                    try {
                        LocalMessage msg = new LocalMessage("chat", "conflictwarning");
                        String translatedMsg = msg.translate();
                        if (translatedMsg != null && !translatedMsg.startsWith("chat.") && !translatedMsg.startsWith("nodarkness.")) {
                            mainGame.getClient().chat.addMessage(translatedMsg);
                        } else {
                            String warningMsg = "\u26a0\ufe0f [NoDarkness] Warning: Another mod is modifying lighting. No Darkness may not work correctly. Try moving No Darkness to the bottom of the mod load order.";
                            mainGame.getClient().chat.addMessage(warningMsg);
                        }
                    }
                    catch (Exception e) {
                        String warningMsg = "\u26a0\ufe0f [NoDarkness] Warning: Another mod is modifying lighting. No Darkness may not work correctly. Try moving No Darkness to the bottom of the mod load order.";
                        mainGame.getClient().chat.addMessage(warningMsg);
                    }
                    NoDarknessMod.log("\u26a0\ufe0f CONFLICT DETECTED: Override was reset " + overrideResetCount + " times by another mod");
                    if (!detectedConflictingMods.isEmpty()) {
                        NoDarknessMod.log("   Detected conflicting mods: " + String.join((CharSequence)", ", detectedConflictingMods));
                    }
                }
                catch (Exception e) {
                    NoDarknessMod.log("Error showing conflict warning: " + e.getMessage());
                }
            }
        }

        private boolean shouldReapplyOverride() {
            if (lastLevel == null || NoDarknessMod.lastLevel.lightManager == null) {
                return false;
            }
            if (enabled) {
                boolean isDarkArea = NoDarknessMod.lastLevel.isCave;
                if (!isDarkArea) {
                    try {
                        Method isNightMethod;
                        Object nightResult;
                        Field worldEntityField = Level.class.getDeclaredField("worldEntity");
                        worldEntityField.setAccessible(true);
                        Object worldEntity = worldEntityField.get(lastLevel);
                        if (worldEntity != null && (nightResult = (isNightMethod = worldEntity.getClass().getMethod("isNight", new Class[0])).invoke(worldEntity, new Object[0])) instanceof Boolean) {
                            isDarkArea = (Boolean)nightResult;
                        }
                    }
                    catch (Exception worldEntityField) {
                        // empty catch block
                    }
                }
                if (isDarkArea) {
                    GameLight currentOverride = NoDarknessMod.lastLevel.lightManager.ambientLightOverride;
                    if (currentOverride == null) {
                        return true;
                    }
                    float f = darknessBrightness * 150.0f;
                }
            }
            return false;
        }

        public void frameTick(TickManager tickManager, GameWindow gameWindow) {
            try {
                if (gameWindow == null) {
                    return;
                }
                State currentState = GlobalData.getCurrentState();
                if (!(currentState instanceof MainGame)) {
                    return;
                }
                MainGame mainGame = (MainGame)currentState;
                Client client = null;
                try {
                    Field clientField = MainGame.class.getDeclaredField("client");
                    clientField.setAccessible(true);
                    client = (Client)clientField.get(mainGame);
                }
                catch (Exception e) {
                    return;
                }
                if (client == null || client.levelManager == null) {
                    return;
                }
                Level level = client.levelManager.getLevel();
                if (level == null || level.isServer()) {
                    return;
                }
                if (level != lastLevel) {
                    lastLevel = level;
                    this.needsUpdate = true;
                    NoDarknessMod.syncSettingsFromConfig();
                    this.updateDarknessLighting();
                }
                if (TOGGLE_NO_DARKNESS != null) {
                    InputEvent event = TOGGLE_NO_DARKNESS.getEvent();
                    boolean isPressed = TOGGLE_NO_DARKNESS.isPressed();
                    if (isPressed) {
                        NoDarknessMod.log("Toggle key pressed! Current enabled: " + enabled);
                        NoDarknessMod.toggleEnabled();
                        this.needsUpdate = true;
                    }
                } else {
                    NoDarknessMod.log("\u26a0\ufe0f WARNING: TOGGLE_NO_DARKNESS Control is null!");
                }
            }
            catch (Exception e) {
                NoDarknessMod.log("\u274c Error in frameTick: " + e.getMessage());
                e.printStackTrace();
            }
        }

        public void updateDarknessLighting() {
            try {
                if (lastLevel == null || lastLevel.isServer()) {
                    return;
                }
                boolean isDarkArea = NoDarknessMod.lastLevel.isCave;
                if (!isDarkArea) {
                    try {
                        Method isNightMethod;
                        Object nightResult;
                        Field worldEntityField = Level.class.getDeclaredField("worldEntity");
                        worldEntityField.setAccessible(true);
                        Object worldEntity = worldEntityField.get(lastLevel);
                        if (worldEntity != null && (nightResult = (isNightMethod = worldEntity.getClass().getMethod("isNight", new Class[0])).invoke(worldEntity, new Object[0])) instanceof Boolean) {
                            isDarkArea = (Boolean)nightResult;
                        }
                    }
                    catch (Exception worldEntityField) {
                        // empty catch block
                    }
                }
                if (!isDarkArea) {
                    if (NoDarknessMod.lastLevel.lightManager != null) {
                        NoDarknessMod.lastLevel.lightManager.ambientLightOverride = null;
                    }
                    this.needsUpdate = false;
                    return;
                }
                if (enabled && NoDarknessMod.lastLevel.lightManager != null) {
                    GameLight newLight;
                    float lightLevel = darknessBrightness * 150.0f;
                    NoDarknessMod.lastLevel.lightManager.ambientLightOverride = newLight = NoDarknessMod.lastLevel.lightManager.newLight(lightLevel);
                    this.needsUpdate = false;
                } else if (!enabled && NoDarknessMod.lastLevel.lightManager != null) {
                    NoDarknessMod.lastLevel.lightManager.ambientLightOverride = null;
                    this.needsUpdate = false;
                }
            }
            catch (Exception e) {
                NoDarknessMod.log("\u274c Error updating darkness lighting: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

