/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class TradeExpedition
extends SettlerExpedition {
    public TradeExpedition() {
        this.initDisplayName();
        this.setCategory("tradeexpedition");
    }

    public void initDisplayName() {
        this.displayName = new LocalMessage("expedition", "tradeexpedition");
    }

    public GameMessage getUnavailableMessage() {
        return new LocalMessage("expedition", "tradeunavailable");
    }

    public boolean isAvailable(ServerSettlementData settlement) {
        if (settlement == null) {
            return false;
        }
        int settlerCount = settlement.getSettlers().size();
        return settlerCount >= 3;
    }

    public float getSuccessChance(ServerSettlementData settlement) {
        if (settlement == null) {
            return 0.0f;
        }
        int completedTiers = settlement.getQuestTiersCompleted();
        float baseChance = 0.6f + (float)completedTiers * 0.05f;
        return Math.min(baseChance, 0.9f);
    }

    public int getBaseCost(ServerSettlementData settlement) {
        int totalValue = this.calculateTotalTradeValue();
        return totalValue * 10;
    }

    public List<InventoryItem> getRewardItems(ServerSettlementData settlement, HumanMob mob) {
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        List<String> tradeItems = this.getTradeItems();
        int itemsToReward = GameRandom.globalRandom.getIntBetween(10, 20);
        for (int i = 0; i < itemsToReward; ++i) {
            String itemID = tradeItems.get(GameRandom.globalRandom.nextInt(tradeItems.size()));
            int amount = GameRandom.globalRandom.getIntBetween(0, 200);
            if (amount <= 0) continue;
            try {
                if (ItemRegistry.getItem((String)itemID) == null) continue;
                rewards.add(new InventoryItem(itemID, amount));
                continue;
            }
            catch (Exception e) {
                System.out.println("\u65e0\u6cd5\u521b\u5efa\u7269\u54c1: " + itemID + ", \u9519\u8bef: " + e.getMessage());
            }
        }
        return rewards;
    }

    public List<InventoryItem> getItemIcons() {
        ArrayList<InventoryItem> icons = new ArrayList<InventoryItem>();
        icons.add(new InventoryItem("raspberryjam"));
        return icons;
    }

    public int getTicksToComplete() {
        return GameRandom.globalRandom.getIntBetween(12000, 18000);
    }

    private int calculateTotalTradeValue() {
        int total = 0;
        for (String itemID : this.getTradeItems()) {
            try {
                if (ItemRegistry.getItem((String)itemID) == null) continue;
                InventoryItem item = new InventoryItem(itemID);
                float value = item.getBrokerValue();
                total += (int)value;
            }
            catch (Exception e) {
                System.out.println("\u4ef7\u683c\u8ba1\u7b97\u9519\u8bef: " + itemID + ", \u9519\u8bef: " + e.getMessage());
            }
        }
        return total;
    }

    private List<String> getTradeItems() {
        ArrayList<String> validItems = new ArrayList<String>();
        List<String> allItems = Arrays.asList("wheat", "sugarbeet", "flour", "sugar", "honey", "rice", "groundcoffee", "beef", "rawmutton", "rawpork", "rabbitleg", "duckbreast", "frogleg", "corn", "tomato", "cabbage", "chilipepper", "eggplant", "potato", "carrot", "onion", "pumpkin", "strawberry", "beet", "apple", "lemon", "coconut", "banana", "milk", "cheese", "blueberry", "raspberry", "blackberry", "rawchickenleg", "steak", "roastedmutton", "roastedpork", "roastedrabbitleg", "roastedduckbreast", "roastedfrogleg", "roastedfish", "bread", "candyapple", "popcorn", "donut", "cookies", "candycane", "meatballs", "smokedfillet", "blueberrycake", "blackberryicecream", "fruitsmoothie", "fishtaco", "juniorburger", "cheeseburger", "nachos", "eggplantparmesan", "tropicalstew", "fishandchips", "freshpotatosalad", "hotdog", "ricepudding", "minersstew", "sushirolls", "friedpork", "bananapudding", "lemontart", "spaghettibolognese", "porktenderloin", "beefgoulash", "shishkebab", "pumpkinpie", "sweetlemonade", "strawberrypie", "blackcoffee", "cappuccino", "chickendrumstick", "friedegg", "omelette", "parisiansteak", "chickencutletdish", "dessertpancakes", "hardboiledegg", "scrambledeggs", "deepfriedchicken", "raspberryjuice", "raspberrymousse", "raspberryjam", "raspberrypie", "wildsalad", "rootsalad", "cheesybeetbowl", "healthpotion", "greaterhealthpotion", "superiorhealthpotion", "manapotion", "greatermanapotion", "superiormanapotion", "speedpotion", "greaterspeedpotion", "webpotion", "healthregenpotion", "greaterhealthregenpotion", "manaregenpotion", "greatermanaregenpotion", "attackspeedpotion", "greaterattackspeedpotion", "invisibilitypotion", "fireresistancepotion", "fishingpotion", "greaterfishingpotion", "battlepotion", "greaterbattlepotion", "resistancepotion", "greaterresistancepotion", "spelunkerpotion", "treasurepotion", "passivepotion", "buildingpotion", "greaterbuildingpotion", "miningpotion", "greaterminingpotion", "thornspotion", "strengthpotion", "rangerpotion", "wisdompotion", "minionpotion", "knockbackpotion", "rapidpotion", "greaterrapidpotion", "accuracypotion", "greateraccuracypotion", "recallscroll");
        for (String itemID : allItems) {
            if (ItemRegistry.getItem((String)itemID) == null) continue;
            validItems.add(itemID);
        }
        return validItems;
    }
}

