/*
 * Decompiled with CFR 0.152.
 */
package com.tia.autominer;

import java.awt.Rectangle;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.registries.GlobalIngredientRegistry;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.AnyLogFueledInventoryObjectEntity;
import necesse.entity.objectEntity.FueledInventoryObjectEntity;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryRange;
import necesse.inventory.container.object.CraftingStationContainer;
import necesse.inventory.recipe.Recipe;
import necesse.level.gameObject.container.CraftingStationObject;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.SettlementRequestOptions;
import necesse.level.maps.levelData.settlementData.storage.SettlementStorageGlobalIngredientIDIndex;
import necesse.level.maps.levelData.settlementData.storage.SettlementStorageRecords;
import necesse.level.maps.levelData.settlementData.storage.SettlementStorageRecordsRegionData;

public class AutoMinerCraftingStationObject
extends CraftingStationObject {
    public AutoMinerCraftingStationObject() {
    }

    public AutoMinerCraftingStationObject(Rectangle collision) {
        super(collision);
    }

    public FueledInventoryObjectEntity getFueledObjectEntity(Level level, int x, int y) {
        ObjectEntity objectEntity = level.entityManager.getObjectEntity(x, y);
        return objectEntity instanceof FueledInventoryObjectEntity ? (FueledInventoryObjectEntity)objectEntity : null;
    }

    public void interact(Level level, int x, int y, PlayerMob player) {
        if (level.isServer()) {
            CraftingStationContainer.openAndSendContainer((int)ContainerRegistry.FUELED_CRAFTING_STATION_CONTAINER, (ServerClient)player.getServerClient(), (Level)level, (int)x, (int)y);
        }
    }

    public ObjectEntity getNewObjectEntity(Level level, int x, int y) {
        return new AnyLogFueledInventoryObjectEntity(level, this.getStringID(), x, y, false);
    }

    public boolean canCurrentlyCraft(Level level, int tileX, int tileY, Recipe recipe) {
        FueledInventoryObjectEntity fueledObjectEntity = this.getFueledObjectEntity(level, tileX, tileY);
        return fueledObjectEntity != null && (fueledObjectEntity.isFueled() || fueledObjectEntity.canFuel());
    }

    public void tickCrafting(Level level, int tileX, int tileY, Recipe recipe) {
        FueledInventoryObjectEntity fueledObjectEntity = this.getFueledObjectEntity(level, tileX, tileY);
        if (fueledObjectEntity != null && !fueledObjectEntity.isFueled()) {
            fueledObjectEntity.useFuel();
        }
    }

    public void onCraftFinished(Level level, int tileX, int tileY, Recipe recipe) {
        FueledInventoryObjectEntity fueledObjectEntity = this.getFueledObjectEntity(level, tileX, tileY);
        if (fueledObjectEntity != null && !fueledObjectEntity.isFueled()) {
            fueledObjectEntity.useFuel();
        }
    }

    public SettlementRequestOptions getFuelRequestOptions(Level level, int tileX, int tileY) {
        return new SettlementRequestOptions(5, 75){

            public SettlementStorageRecordsRegionData getRequestStorageData(SettlementStorageRecords records) {
                return ((SettlementStorageGlobalIngredientIDIndex)records.getIndex(SettlementStorageGlobalIngredientIDIndex.class)).getGlobalIngredient(GlobalIngredientRegistry.getGlobalIngredientID((String)"anylog"));
            }
        };
    }

    public InventoryRange getFuelInventoryRange(Level level, int tileX, int tileY) {
        FueledInventoryObjectEntity fueledObjectEntity = this.getFueledObjectEntity(level, tileX, tileY);
        Inventory inventory = fueledObjectEntity.getInventory();
        return inventory != null ? new InventoryRange(inventory) : null;
    }
}

