/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import necesse.engine.Settings;
import necesse.engine.input.Control;
import necesse.engine.input.InputEvent;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.registries.SettlerRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.LoadDataException;
import necesse.engine.save.SaveData;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.job.EntityJobWorker;
import necesse.gfx.Renderer;
import necesse.gfx.fairType.FairButtonGlyph;
import necesse.gfx.fairType.FairGlyph;
import necesse.gfx.fairType.FairItemGlyph;
import necesse.gfx.fairType.FairType;
import necesse.gfx.fairType.TypeParsers;
import necesse.gfx.fairType.parsers.TypeParser;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormFairTypeLabel;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.floatMenu.FloatMenu;
import necesse.gfx.forms.floatMenu.SelectionFloatMenu;
import necesse.gfx.forms.position.FormPositionContainer;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonState;
import necesse.gfx.ui.ButtonTexture;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.jobCondition.JobCondition;
import necesse.level.maps.levelData.settlementData.jobCondition.JobConditionUpdatePacketSender;
import necesse.level.maps.levelData.settlementData.settler.Settler;

public class DoWhenSettlerTypeJobCondition
extends JobCondition {
    protected ArrayList<SettlerTypeThreshold> thresholds = new ArrayList();

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        SaveData thresholdsSave = new SaveData("THRESHOLDS");
        for (SettlerTypeThreshold threshold : this.thresholds) {
            thresholdsSave.addSaveData(threshold.getSaveData(""));
        }
        save.addSaveData(thresholdsSave);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.thresholds.clear();
        LoadData thresholdsSave = save.getFirstLoadDataByName("THRESHOLDS");
        if (thresholdsSave != null) {
            for (LoadData thresholdSave : thresholdsSave.getLoadData()) {
                try {
                    SettlerTypeThreshold settlerThreshold = new SettlerTypeThreshold(thresholdSave);
                    this.thresholds.add(settlerThreshold);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextCollection(this.thresholds, threshold -> threshold.writePacket(writer));
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.thresholds = (ArrayList)reader.getNextCollection(ArrayList::new, () -> new SettlerTypeThreshold(reader));
    }

    public void applyUpdatePacket(int type, PacketReader reader) {
        super.applyUpdatePacket(type, reader);
        if (type == 0) {
            this.applySpawnPacket(reader);
            this.markDirty();
        }
    }

    public void sendFullUpdatePacket(JobConditionUpdatePacketSender sender) {
        Packet packet = new Packet();
        PacketWriter writer = new PacketWriter(packet);
        this.setupSpawnPacket(writer);
        sender.sendUpdatePacket(0, packet);
    }

    public boolean isConditionMet(EntityJobWorker worker, ServerSettlementData serverData) {
        if (this.thresholds.isEmpty()) {
            return false;
        }
        for (SettlerTypeThreshold threshold : this.thresholds) {
            if (threshold.isConditionMet(serverData)) continue;
            return false;
        }
        return true;
    }

    public GameMessage getSelectedMessage() {
        if (this.thresholds.size() == 1) {
            SettlerTypeThreshold threshold = this.thresholds.get(0);
            String conditionString = threshold.settler.getGenericMobName();
            conditionString = threshold.whenGreaterThan ? conditionString + " > " + threshold.threshold : conditionString + " < " + threshold.threshold;
            return new LocalMessage("ui", "conditiondowhen", "condition", conditionString);
        }
        if (this.thresholds.isEmpty()) {
            return new LocalMessage("ui", "conditiondowhen", "condition", "-");
        }
        StringBuilder settlerStringBuilder = new StringBuilder();
        for (SettlerTypeThreshold threshold : this.thresholds) {
            settlerStringBuilder.append(threshold.settler.getGenericMobName());
        }
        return new LocalMessage("ui", "conditiondowhen", "condition", settlerStringBuilder.toString());
    }

    public Form getConfigurationForm(Client client, int minWidth, final JobConditionUpdatePacketSender updatePacketSender, ArrayList<Runnable> updateListeners, Runnable refreshForm) {
        Form form = new Form(Math.max(minWidth, 500), 0);
        FormFlow flow = new FormFlow(4);
        form.addComponent((FormComponent)((FormLocalLabel)flow.nextY((FormPositionContainer)new FormLocalLabel((GameMessage)new LocalMessage("ui", "conditiondowhen", "condition", "X"), new FontOptions(20), 0, form.getWidth() / 2, 4, form.getWidth() - 10), 4)));
        form.addComponent((FormComponent)((FormLocalLabel)flow.nextY((FormPositionContainer)new FormLocalLabel("ui", "settlertypeconditiontip", new FontOptions(16), 0, form.getWidth() / 2, 4, form.getWidth() - 10), 4)));
        flow.next(10);
        ArrayList<FormFairTypeLabel> labels = new ArrayList<FormFairTypeLabel>();
        ArrayList<FormContentIconButton> configButtons = new ArrayList<FormContentIconButton>(this.thresholds.size());
        ArrayList<FormContentIconButton> deleteButtons = new ArrayList<FormContentIconButton>(this.thresholds.size());
        final Runnable updateButtonPositions = () -> {
            int maxWidth = labels.stream().mapToInt(label -> label.getBoundingBox().width).max().orElse(0);
            for (FormContentIconButton configButton : configButtons) {
                configButton.setX(form.getWidth() / 2 - maxWidth / 2 - 6 - 20);
            }
            for (FormContentIconButton deleteButton : deleteButtons) {
                deleteButton.setX(form.getWidth() / 2 + maxWidth / 2 + 6);
            }
        };
        for (final SettlerTypeThreshold threshold : this.thresholds) {
            final FormContentIconButton configButton = (FormContentIconButton)form.addComponent((FormComponent)new FormContentIconButton(0, 0, FormInputSize.SIZE_20, ButtonColor.BASE, (ButtonTexture)Settings.UI.button_collapsed_16, new GameMessage[]{new LocalMessage("ui", "changebutton")}));
            configButton.onClicked(e -> {
                threshold.whenGreaterThan = !threshold.whenGreaterThan;
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            });
            configButtons.add(configButton);
            final FormContentIconButton deleteButton = (FormContentIconButton)form.addComponent((FormComponent)new FormContentIconButton(0, 0, FormInputSize.SIZE_20, ButtonColor.RED, (ButtonTexture)Settings.UI.container_storage_remove, new GameMessage[]{new LocalMessage("ui", "deletebutton")}));
            deleteButton.onClicked(e -> {
                this.thresholds.remove(threshold);
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            });
            deleteButtons.add(deleteButton);
            FontOptions fontOptions = new FontOptions(16);
            final FormFairTypeLabel label = new FormFairTypeLabel((GameMessage)new StaticMessage(""), fontOptions, FairType.TextAlign.CENTER, form.getWidth() / 2, 0);
            labels.add(label);
            Runnable updateLabel = new Runnable(){

                @Override
                public void run() {
                    threshold.updateLabel(label, updatePacketSender, this);
                    int buttonY = label.getY() + label.getBoundingBox().height / 2 - 8;
                    configButton.setY(buttonY);
                    deleteButton.setY(buttonY);
                    updateButtonPositions.run();
                }
            };
            threshold.updateLabel(label, updatePacketSender, updateLabel);
            Rectangle labelBoundingBox = label.getBoundingBox();
            int thresholdY = flow.next(Math.max(labelBoundingBox.height, 24) + 4);
            label.setY(thresholdY);
            form.addComponent((FormComponent)label);
            int buttonY = thresholdY + labelBoundingBox.height / 2 - 8;
            configButton.setY(buttonY);
            deleteButton.setY(buttonY);
        }
        updateButtonPositions.run();
        flow.next(10);
        FormLocalTextButton addSettlerButton = (FormLocalTextButton)form.addComponent((FormComponent)new FormLocalTextButton("ui", "settlertypeconditionadd", form.getWidth() / 2 - 150, flow.next(28), 300, FormInputSize.SIZE_24, ButtonColor.BASE));
        addSettlerButton.onClicked(configureEvent -> {
            SelectionFloatMenu menu = new SelectionFloatMenu((FormComponent)addSettlerButton, SelectionFloatMenu.Solid((FontOptions)new FontOptions(12)), 200);
            Iterator iterator = SettlerRegistry.getSettlers().iterator();
            while (iterator.hasNext()) {
                Settler settler;
                Settler selectedSettler = settler = (Settler)iterator.next();
                menu.add(settler.getGenericMobName(), () -> {
                    boolean alreadyExists = this.thresholds.stream().anyMatch(t -> t.settler.getStringID().equals(selectedSettler.getStringID()));
                    if (!alreadyExists) {
                        this.thresholds.add(new SettlerTypeThreshold(selectedSettler, 0, false));
                        this.sendFullUpdatePacket(updatePacketSender);
                        refreshForm.run();
                    }
                    menu.remove();
                });
            }
            if (configureEvent.event.isControllerEvent()) {
                addSettlerButton.getManager().openFloatMenu((FloatMenu)menu);
            } else {
                addSettlerButton.getManager().openFloatMenu((FloatMenu)menu, (FormComponent)addSettlerButton, configureEvent.event, -4, 0);
            }
        });
        form.setHeight(flow.next());
        return form;
    }

    public class SettlerTypeThreshold {
        private final Object repeatInc = new Object();
        private final Object repeatDec = new Object();
        public final Settler settler;
        public int threshold;
        public boolean whenGreaterThan;

        public SettlerTypeThreshold(Settler settler, int threshold, boolean whenGreaterThan) {
            Objects.requireNonNull(settler);
            this.settler = settler;
            this.threshold = threshold;
            this.whenGreaterThan = whenGreaterThan;
        }

        public SettlerTypeThreshold(LoadData save) {
            String settlerStringID = save.getSafeString("settlerStringID");
            this.settler = SettlerRegistry.getSettler((String)settlerStringID);
            if (this.settler == null) {
                throw new LoadDataException("Could not find job condition settler threshold with settler stringID: " + settlerStringID);
            }
            this.threshold = save.getInt("threshold", this.threshold);
            this.whenGreaterThan = save.getBoolean("whenGreaterThan", this.whenGreaterThan);
        }

        public SaveData getSaveData(String name) {
            SaveData save = new SaveData(name);
            save.addSafeString("settlerStringID", this.settler.getStringID());
            save.addInt("threshold", this.threshold);
            save.addBoolean("whenGreaterThan", this.whenGreaterThan);
            return save;
        }

        public SettlerTypeThreshold(PacketReader reader) {
            this.settler = SettlerRegistry.getSettler((int)reader.getNextShortUnsigned());
            Objects.requireNonNull(this.settler);
            this.threshold = reader.getNextInt();
            this.whenGreaterThan = reader.getNextBoolean();
        }

        public void writePacket(PacketWriter writer) {
            writer.putNextShortUnsigned(this.settler.getID());
            writer.putNextInt(this.threshold);
            writer.putNextBoolean(this.whenGreaterThan);
        }

        public boolean isConditionMet(ServerSettlementData settlementData) {
            int totalSettlers = settlementData.getSettlerCount(this.settler);
            if (this.whenGreaterThan) {
                return totalSettlers > this.threshold;
            }
            return totalSettlers < this.threshold;
        }

        public void updateLabel(final FormFairTypeLabel label, final JobConditionUpdatePacketSender updatePacketSender, final Runnable updateLabel) {
            FontOptions fontOptions = label.getFontOptions();
            FairType fairType = new FairType();
            String displayText = this.whenGreaterThan ? this.settler.getGenericMobName() + " > [[-]] " + this.threshold + " [[+]]" : this.settler.getGenericMobName() + " < [[-]] " + this.threshold + " [[+]]";
            fairType.append(fontOptions, displayText);
            fairType.applyParsers(new TypeParser[]{TypeParsers.GAME_COLOR, TypeParsers.URL_OPEN, TypeParsers.MARKDOWN_URL, TypeParsers.ItemIcon((int)fontOptions.getSize(), (boolean)false, FairItemGlyph::onlyShowNameTooltip), TypeParsers.MobIcon((int)fontOptions.getSize()), TypeParsers.InputIcon((FontOptions)fontOptions), TypeParsers.replaceParser((String)"[[-]]", (FairGlyph[])new FairGlyph[]{new FairButtonGlyph(16, 16){

                public void handleEvent(float drawX, float drawY, InputEvent event) {
                    if ((event.getID() == -100 || event.isRepeatEvent(SettlerTypeThreshold.this.repeatDec)) && event.state) {
                        event.startRepeatEvents(new Object[]{SettlerTypeThreshold.this.repeatDec});
                        int amount = 1;
                        if (Control.INV_QUICK_MOVE.isDown()) {
                            amount = 10;
                        } else if (Control.INV_QUICK_TRASH.isDown() || Control.INV_QUICK_DROP.isDown()) {
                            amount = 100;
                        }
                        int lastRemainingTimes = SettlerTypeThreshold.this.threshold;
                        SettlerTypeThreshold.this.threshold = Math.max(0, SettlerTypeThreshold.this.threshold - amount);
                        if (lastRemainingTimes != SettlerTypeThreshold.this.threshold) {
                            if (updatePacketSender != null) {
                                DoWhenSettlerTypeJobCondition.this.sendFullUpdatePacket(updatePacketSender);
                            }
                            if (event.shouldSubmitSound()) {
                                label.playTickSound();
                            }
                            updateLabel.run();
                        }
                        WindowManager.getWindow().getInput().submitNextMoveEvent();
                    }
                }

                public void draw(float x, float y, Color defaultColor) {
                    Color color = this.isHovering() ? (Color)label.getInterfaceStyle().button_minus_20.colorGetter.apply(ButtonState.HIGHLIGHTED) : (Color)label.getInterfaceStyle().button_minus_20.colorGetter.apply(ButtonState.ACTIVE);
                    label.getInterfaceStyle().button_minus_20.texture.initDraw().color(color).posMiddle((int)x + 8, (int)y - 8).draw();
                    if (this.isHovering()) {
                        Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
                    }
                }
            }}), TypeParsers.replaceParser((String)"[[+]]", (FairGlyph[])new FairGlyph[]{new FairButtonGlyph(16, 16){

                public void handleEvent(float drawX, float drawY, InputEvent event) {
                    if ((event.getID() == -100 || event.isRepeatEvent(SettlerTypeThreshold.this.repeatInc)) && event.state) {
                        event.startRepeatEvents(new Object[]{SettlerTypeThreshold.this.repeatInc});
                        int amount = 1;
                        if (Control.INV_QUICK_MOVE.isDown()) {
                            amount = 10;
                        } else if (Control.INV_QUICK_TRASH.isDown() || Control.INV_QUICK_DROP.isDown()) {
                            amount = 100;
                        }
                        int lastRemainingTimes = SettlerTypeThreshold.this.threshold;
                        SettlerTypeThreshold.this.threshold = Math.min(65535, SettlerTypeThreshold.this.threshold + amount);
                        if (lastRemainingTimes != SettlerTypeThreshold.this.threshold) {
                            if (updatePacketSender != null) {
                                DoWhenSettlerTypeJobCondition.this.sendFullUpdatePacket(updatePacketSender);
                            }
                            if (event.shouldSubmitSound()) {
                                label.playTickSound();
                            }
                            updateLabel.run();
                        }
                        WindowManager.getWindow().getInput().submitNextMoveEvent();
                    }
                }

                public void draw(float x, float y, Color defaultColor) {
                    Color color = this.isHovering() ? (Color)label.getInterfaceStyle().button_plus_20.colorGetter.apply(ButtonState.HIGHLIGHTED) : (Color)label.getInterfaceStyle().button_plus_20.colorGetter.apply(ButtonState.ACTIVE);
                    label.getInterfaceStyle().button_plus_20.texture.initDraw().color(color).posMiddle((int)x + 8, (int)y - 8).draw();
                    if (this.isHovering()) {
                        Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
                    }
                }
            }})});
            label.setCustomFairType(fairType);
        }
    }
}

