/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.mobs.job.EntityJobWorker;
import necesse.gfx.fairType.FairType;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormFairTypeLabel;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.jobCondition.JobCondition;
import necesse.level.maps.levelData.settlementData.jobCondition.JobConditionUpdatePacketSender;

public class DoWhenPopulationJobCondition
extends JobCondition {
    protected int threshold = 10;
    protected boolean whenGreaterThan = true;

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt("populationThreshold", this.threshold);
        save.addBoolean("whenGreaterThan", this.whenGreaterThan);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.threshold = save.getInt("populationThreshold", 10);
        this.whenGreaterThan = save.getBoolean("whenGreaterThan", true);
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.threshold);
        writer.putNextBoolean(this.whenGreaterThan);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.threshold = reader.getNextInt();
        this.whenGreaterThan = reader.getNextBoolean();
    }

    public void applyUpdatePacket(int type, PacketReader reader) {
        super.applyUpdatePacket(type, reader);
        if (type == 0) {
            this.applySpawnPacket(reader);
            this.markDirty();
        }
    }

    public void sendFullUpdatePacket(JobConditionUpdatePacketSender sender) {
        Packet packet = new Packet();
        PacketWriter writer = new PacketWriter(packet);
        this.setupSpawnPacket(writer);
        sender.sendUpdatePacket(0, packet);
    }

    public boolean isConditionMet(EntityJobWorker worker, ServerSettlementData settlement) {
        if (settlement == null) {
            return false;
        }
        int currentPopulation = settlement.countTotalSettlers();
        if (this.whenGreaterThan) {
            return currentPopulation > this.threshold;
        }
        return currentPopulation < this.threshold;
    }

    public GameMessage getSelectedMessage() {
        String populationText = new LocalMessage("ui", "population").translate();
        String conditionString = this.whenGreaterThan ? populationText + " > " + this.threshold : populationText + " < " + this.threshold;
        return new LocalMessage("ui", "conditiondowhen", "condition", conditionString);
    }

    public Form getConfigurationForm(Client client, int minWidth, JobConditionUpdatePacketSender updatePacketSender, ArrayList<Runnable> updateListeners, Runnable refreshForm) {
        Form form = new Form(Math.max(minWidth, 400), 0);
        FormFlow flow = new FormFlow(10);
        FormFairTypeLabel styleLabel = new FormFairTypeLabel((GameMessage)new StaticMessage(""), new FontOptions(16), FairType.TextAlign.LEFT, 0, 0);
        form.addComponent((FormComponent)new FormLocalLabel("ui", "populationconditionconfig", new FontOptions(20), 0, form.getWidth() / 2, flow.next(), form.getWidth() - 20));
        flow.next(20);
        int rowY = flow.next();
        FormLocalTextButton lessThanButton = new FormLocalTextButton("ui", "conditionlessthan", 50, rowY, 120, FormInputSize.SIZE_24, this.whenGreaterThan ? ButtonColor.BASE : ButtonColor.GREEN);
        lessThanButton.onClicked(e -> {
            if (this.whenGreaterThan) {
                this.whenGreaterThan = false;
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            }
        });
        form.addComponent((FormComponent)lessThanButton);
        FormLocalTextButton greaterThanButton = new FormLocalTextButton("ui", "conditiongreaterthan", 230, rowY, 120, FormInputSize.SIZE_24, this.whenGreaterThan ? ButtonColor.GREEN : ButtonColor.BASE);
        greaterThanButton.onClicked(e -> {
            if (!this.whenGreaterThan) {
                this.whenGreaterThan = true;
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            }
        });
        form.addComponent((FormComponent)greaterThanButton);
        flow.next(30);
        rowY = flow.next();
        FontOptions numberFontOptions = new FontOptions(20);
        FormFairTypeLabel thresholdLabel = new FormFairTypeLabel((GameMessage)new StaticMessage(String.valueOf(this.threshold)), numberFontOptions, FairType.TextAlign.CENTER, form.getWidth() / 2, rowY);
        thresholdLabel.setMax(80, 1, true, true);
        form.addComponent((FormComponent)thresholdLabel);
        FormContentIconButton minus10Button = new FormContentIconButton(50, rowY, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)styleLabel.getInterfaceStyle().button_minus_24, new GameMessage[]{new StaticMessage("-10")});
        minus10Button.onClicked(e -> {
            this.threshold = Math.max(0, this.threshold - 10);
            this.sendFullUpdatePacket(updatePacketSender);
            thresholdLabel.setText((GameMessage)new StaticMessage(String.valueOf(this.threshold)));
            refreshForm.run();
        });
        form.addComponent((FormComponent)minus10Button);
        FormContentIconButton minus1Button = new FormContentIconButton(90, rowY, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)styleLabel.getInterfaceStyle().button_minus_24, new GameMessage[]{new StaticMessage("-1")});
        minus1Button.onClicked(e -> {
            this.threshold = Math.max(0, this.threshold - 1);
            this.sendFullUpdatePacket(updatePacketSender);
            thresholdLabel.setText((GameMessage)new StaticMessage(String.valueOf(this.threshold)));
            refreshForm.run();
        });
        form.addComponent((FormComponent)minus1Button);
        FormContentIconButton plus1Button = new FormContentIconButton(270, rowY, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)styleLabel.getInterfaceStyle().button_plus_24, new GameMessage[]{new StaticMessage("+1")});
        plus1Button.onClicked(e -> {
            this.threshold = Math.min(1000, this.threshold + 1);
            this.sendFullUpdatePacket(updatePacketSender);
            thresholdLabel.setText((GameMessage)new StaticMessage(String.valueOf(this.threshold)));
            refreshForm.run();
        });
        form.addComponent((FormComponent)plus1Button);
        FormContentIconButton plus10Button = new FormContentIconButton(310, rowY, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)styleLabel.getInterfaceStyle().button_plus_24, new GameMessage[]{new StaticMessage("+10")});
        plus10Button.onClicked(e -> {
            this.threshold = Math.min(1000, this.threshold + 10);
            this.sendFullUpdatePacket(updatePacketSender);
            thresholdLabel.setText((GameMessage)new StaticMessage(String.valueOf(this.threshold)));
            refreshForm.run();
        });
        form.addComponent((FormComponent)plus10Button);
        updateListeners.add(() -> {
            thresholdLabel.setText((GameMessage)new StaticMessage(String.valueOf(this.threshold)));
            lessThanButton.setActive(!this.whenGreaterThan);
            greaterThanButton.setActive(this.whenGreaterThan);
        });
        flow.next(40);
        form.setHeight(flow.next());
        return form;
    }
}

