/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import necesse.engine.Settings;
import necesse.engine.input.Control;
import necesse.engine.input.InputEvent;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.SettlerRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.LoadDataException;
import necesse.engine.save.SaveData;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.job.EntityJobWorker;
import necesse.gfx.Renderer;
import necesse.gfx.fairType.FairButtonGlyph;
import necesse.gfx.fairType.FairGlyph;
import necesse.gfx.fairType.FairItemGlyph;
import necesse.gfx.fairType.FairType;
import necesse.gfx.fairType.TypeParsers;
import necesse.gfx.fairType.parsers.TypeParser;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormFairTypeLabel;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.floatMenu.FloatMenu;
import necesse.gfx.forms.floatMenu.SelectionFloatMenu;
import necesse.gfx.forms.presets.containerComponent.settlement.SelectItemFloatMenu;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonState;
import necesse.gfx.ui.ButtonTexture;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.jobCondition.JobCondition;
import necesse.level.maps.levelData.settlementData.jobCondition.JobConditionUpdatePacketSender;
import necesse.level.maps.levelData.settlementData.settler.Settler;
import necesse.level.maps.levelData.settlementData.storage.SettlementStorageItemIDIndex;

public class DoWhenMultipleConditions
extends JobCondition {
    protected ArrayList<ItemThreshold> itemThresholds = new ArrayList();
    protected ArrayList<SettlerTypeThreshold> settlerThresholds = new ArrayList();
    protected PopulationThreshold populationThreshold;

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        SaveData itemsSave = new SaveData("ITEMS");
        for (ItemThreshold threshold : this.itemThresholds) {
            itemsSave.addSaveData(threshold.getSaveData(""));
        }
        save.addSaveData(itemsSave);
        SaveData settlersSave = new SaveData("SETTLERS");
        for (SettlerTypeThreshold threshold : this.settlerThresholds) {
            settlersSave.addSaveData(threshold.getSaveData(""));
        }
        save.addSaveData(settlersSave);
        if (this.populationThreshold != null) {
            save.addSaveData(this.populationThreshold.getSaveData("POPULATION"));
        }
    }

    public void applyLoadData(LoadData save) {
        LoadData populationSave;
        super.applyLoadData(save);
        this.itemThresholds.clear();
        LoadData itemsSave = save.getFirstLoadDataByName("ITEMS");
        if (itemsSave != null) {
            for (Object thresholdSave : itemsSave.getLoadData()) {
                try {
                    ItemThreshold itemThreshold = new ItemThreshold((LoadData)thresholdSave);
                    this.itemThresholds.add(itemThreshold);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.settlerThresholds.clear();
        LoadData settlersSave = save.getFirstLoadDataByName("SETTLERS");
        if (settlersSave != null) {
            for (LoadData thresholdSave : settlersSave.getLoadData()) {
                try {
                    SettlerTypeThreshold settlerThreshold = new SettlerTypeThreshold(thresholdSave);
                    this.settlerThresholds.add(settlerThreshold);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((populationSave = save.getFirstLoadDataByName("POPULATION")) != null) {
            this.populationThreshold = new PopulationThreshold(populationSave);
        }
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextCollection(this.itemThresholds, threshold -> threshold.writePacket(writer));
        writer.putNextCollection(this.settlerThresholds, threshold -> threshold.writePacket(writer));
        writer.putNextBoolean(this.populationThreshold != null);
        if (this.populationThreshold != null) {
            this.populationThreshold.writePacket(writer);
        }
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.itemThresholds = (ArrayList)reader.getNextCollection(ArrayList::new, () -> new ItemThreshold(reader));
        this.settlerThresholds = (ArrayList)reader.getNextCollection(ArrayList::new, () -> new SettlerTypeThreshold(reader));
        boolean hasPopulation = reader.getNextBoolean();
        this.populationThreshold = hasPopulation ? new PopulationThreshold(reader) : null;
    }

    public void applyUpdatePacket(int type, PacketReader reader) {
        super.applyUpdatePacket(type, reader);
        if (type == 0) {
            this.applySpawnPacket(reader);
            this.markDirty();
        }
    }

    public void sendFullUpdatePacket(JobConditionUpdatePacketSender sender) {
        Packet packet = new Packet();
        PacketWriter writer = new PacketWriter(packet);
        this.setupSpawnPacket(writer);
        sender.sendUpdatePacket(0, packet);
    }

    public boolean isConditionMet(EntityJobWorker worker, ServerSettlementData settlement) {
        if (settlement == null) {
            return false;
        }
        for (ItemThreshold itemThreshold : this.itemThresholds) {
            if (itemThreshold.isConditionMet(worker, settlement)) continue;
            return false;
        }
        for (SettlerTypeThreshold settlerTypeThreshold : this.settlerThresholds) {
            if (settlerTypeThreshold.isConditionMet(settlement)) continue;
            return false;
        }
        return this.populationThreshold == null || this.populationThreshold.isConditionMet(settlement);
    }

    public GameMessage getSelectedMessage() {
        StringBuilder conditionString = new StringBuilder();
        if (!this.itemThresholds.isEmpty()) {
            String itemsText = new LocalMessage("ui", "multipleconditionitems", "count", String.valueOf(this.itemThresholds.size())).translate();
            conditionString.append(itemsText).append(" ");
        }
        if (!this.settlerThresholds.isEmpty()) {
            String settlersText = new LocalMessage("ui", "multipleconditionsettlers", "count", String.valueOf(this.settlerThresholds.size())).translate();
            conditionString.append(settlersText).append(" ");
        }
        if (this.populationThreshold != null) {
            String populationText = new LocalMessage("ui", "multipleconditionpopulation").translate();
            conditionString.append(populationText).append(" ");
        }
        if (conditionString.length() == 0) {
            String noneText = new LocalMessage("ui", "multipleconditionnone").translate();
            conditionString.append(noneText);
        }
        return new LocalMessage("ui", "conditiondowhen", "condition", conditionString.toString());
    }

    public Form getConfigurationForm(Client client, int minWidth, final JobConditionUpdatePacketSender updatePacketSender, ArrayList<Runnable> updateListeners, final Runnable refreshForm) {
        Form form = new Form(Math.max(minWidth, 600), 0);
        FormFlow flow = new FormFlow(10);
        form.addComponent((FormComponent)new FormLocalLabel("ui", "multipleconditionsconfig", new FontOptions(20), 0, form.getWidth() / 2, flow.next(), form.getWidth() - 20));
        flow.next(20);
        form.addComponent((FormComponent)new FormLocalLabel("ui", "itemconditions", new FontOptions(16), 10, flow.next(), form.getWidth() - 20));
        flow.next(5);
        ArrayList<FormContentIconButton> itemConfigButtons = new ArrayList<FormContentIconButton>();
        ArrayList<FormContentIconButton> itemDeleteButtons = new ArrayList<FormContentIconButton>();
        for (final ItemThreshold threshold : this.itemThresholds) {
            final FormContentIconButton configButton = (FormContentIconButton)form.addComponent((FormComponent)new FormContentIconButton(0, 0, FormInputSize.SIZE_20, ButtonColor.BASE, (ButtonTexture)Settings.UI.button_collapsed_16, new GameMessage[]{new LocalMessage("ui", "changebutton")}));
            configButton.onClicked(e -> {
                threshold.whenGreaterThan = !threshold.whenGreaterThan;
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            });
            itemConfigButtons.add(configButton);
            final FormContentIconButton deleteButton = (FormContentIconButton)form.addComponent((FormComponent)new FormContentIconButton(0, 0, FormInputSize.SIZE_20, ButtonColor.RED, (ButtonTexture)Settings.UI.container_storage_remove, new GameMessage[]{new LocalMessage("ui", "deletebutton")}));
            deleteButton.onClicked(e -> {
                this.itemThresholds.remove(threshold);
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            });
            itemDeleteButtons.add(deleteButton);
            FontOptions fontOptions = new FontOptions(16);
            final FormFairTypeLabel label = new FormFairTypeLabel((GameMessage)new StaticMessage(""), fontOptions, FairType.TextAlign.CENTER, form.getWidth() / 2, 0);
            Runnable updateLabel = new Runnable(){

                @Override
                public void run() {
                    threshold.updateLabel(label, updatePacketSender, this);
                    int buttonY = label.getY() + label.getBoundingBox().height / 2 - 8;
                    configButton.setY(buttonY);
                    deleteButton.setY(buttonY);
                }
            };
            threshold.updateLabel(label, updatePacketSender, updateLabel);
            Rectangle labelBoundingBox = label.getBoundingBox();
            int thresholdY = flow.next(Math.max(labelBoundingBox.height, 24) + 4);
            label.setY(thresholdY);
            form.addComponent((FormComponent)label);
            int buttonY = thresholdY + label.getBoundingBox().height / 2 - 8;
            configButton.setY(buttonY);
            deleteButton.setY(buttonY);
            configButton.setX(form.getWidth() / 2 - 120);
            deleteButton.setX(form.getWidth() / 2 + 100);
        }
        FormLocalTextButton addItemButton = new FormLocalTextButton("ui", "additemcondition", form.getWidth() / 2 - 150, flow.next(28), 300, FormInputSize.SIZE_24, ButtonColor.BASE);
        addItemButton.onClicked(configureEvent -> {
            SelectItemFloatMenu menu = new SelectItemFloatMenu((FormComponent)addItemButton, client, 400, 400){

                public void onItemSelected(Item item) {
                    boolean alreadyExists = DoWhenMultipleConditions.this.itemThresholds.stream().anyMatch(t -> t.item.getStringID().equals(item.getStringID()));
                    if (!alreadyExists) {
                        DoWhenMultipleConditions.this.itemThresholds.add(new ItemThreshold(item, 0, true));
                        DoWhenMultipleConditions.this.sendFullUpdatePacket(updatePacketSender);
                        refreshForm.run();
                    }
                    this.remove();
                }
            };
            if (configureEvent.event.isControllerEvent()) {
                addItemButton.getManager().openFloatMenu((FloatMenu)menu);
            } else {
                addItemButton.getManager().openFloatMenu((FloatMenu)menu, (FormComponent)addItemButton, configureEvent.event, -4, 0);
            }
        });
        form.addComponent((FormComponent)addItemButton);
        flow.next(20);
        form.addComponent((FormComponent)new FormLocalLabel("ui", "settlerconditions", new FontOptions(16), 10, flow.next(), form.getWidth() - 20));
        flow.next(5);
        ArrayList<FormContentIconButton> settlerConfigButtons = new ArrayList<FormContentIconButton>();
        ArrayList<FormContentIconButton> settlerDeleteButtons = new ArrayList<FormContentIconButton>();
        ArrayList<FormFairTypeLabel> settlerLabels = new ArrayList<FormFairTypeLabel>();
        for (final SettlerTypeThreshold threshold : this.settlerThresholds) {
            final FormContentIconButton configButton = (FormContentIconButton)form.addComponent((FormComponent)new FormContentIconButton(0, 0, FormInputSize.SIZE_20, ButtonColor.BASE, (ButtonTexture)Settings.UI.button_collapsed_16, new GameMessage[]{new LocalMessage("ui", "changebutton")}));
            configButton.onClicked(e -> {
                threshold.whenGreaterThan = !threshold.whenGreaterThan;
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            });
            settlerConfigButtons.add(configButton);
            final FormContentIconButton deleteButton = (FormContentIconButton)form.addComponent((FormComponent)new FormContentIconButton(0, 0, FormInputSize.SIZE_20, ButtonColor.RED, (ButtonTexture)Settings.UI.container_storage_remove, new GameMessage[]{new LocalMessage("ui", "deletebutton")}));
            deleteButton.onClicked(e -> {
                this.settlerThresholds.remove(threshold);
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            });
            settlerDeleteButtons.add(deleteButton);
            FontOptions fontOptions = new FontOptions(16);
            final FormFairTypeLabel label = new FormFairTypeLabel((GameMessage)new StaticMessage(""), fontOptions, FairType.TextAlign.CENTER, form.getWidth() / 2, 0);
            settlerLabels.add(label);
            Runnable updateLabel = new Runnable(){

                @Override
                public void run() {
                    threshold.updateLabel(label, updatePacketSender, this);
                    int buttonY = label.getY() + label.getBoundingBox().height / 2 - 8;
                    configButton.setY(buttonY);
                    deleteButton.setY(buttonY);
                }
            };
            threshold.updateLabel(label, updatePacketSender, updateLabel);
            Rectangle labelBoundingBox = label.getBoundingBox();
            int thresholdY = flow.next(Math.max(labelBoundingBox.height, 24) + 4);
            label.setY(thresholdY);
            form.addComponent((FormComponent)label);
            int buttonY = thresholdY + labelBoundingBox.height / 2 - 8;
            configButton.setY(buttonY);
            deleteButton.setY(buttonY);
            configButton.setX(form.getWidth() / 2 - 120);
            deleteButton.setX(form.getWidth() / 2 + 100);
        }
        FormLocalTextButton addSettlerButton = new FormLocalTextButton("ui", "settlertypeconditionadd", form.getWidth() / 2 - 150, flow.next(28), 300, FormInputSize.SIZE_24, ButtonColor.BASE);
        addSettlerButton.onClicked(configureEvent -> {
            SelectionFloatMenu menu = new SelectionFloatMenu((FormComponent)addSettlerButton, SelectionFloatMenu.Solid((FontOptions)new FontOptions(12)), 200);
            Iterator iterator = SettlerRegistry.getSettlers().iterator();
            while (iterator.hasNext()) {
                Settler settler;
                Settler selectedSettler = settler = (Settler)iterator.next();
                menu.add(settler.getGenericMobName(), () -> {
                    boolean alreadyExists = this.settlerThresholds.stream().anyMatch(t -> t.settler.getStringID().equals(selectedSettler.getStringID()));
                    if (!alreadyExists) {
                        this.settlerThresholds.add(new SettlerTypeThreshold(selectedSettler, 0, true));
                        this.sendFullUpdatePacket(updatePacketSender);
                        refreshForm.run();
                    }
                    menu.remove();
                });
            }
            if (configureEvent.event.isControllerEvent()) {
                addSettlerButton.getManager().openFloatMenu((FloatMenu)menu);
            } else {
                addSettlerButton.getManager().openFloatMenu((FloatMenu)menu, (FormComponent)addSettlerButton, configureEvent.event, -4, 0);
            }
        });
        form.addComponent((FormComponent)addSettlerButton);
        flow.next(20);
        form.addComponent((FormComponent)new FormLocalLabel("ui", "populationcondition", new FontOptions(16), 10, flow.next(), form.getWidth() - 20));
        flow.next(5);
        if (this.populationThreshold != null) {
            final FormContentIconButton popConfigButton = (FormContentIconButton)form.addComponent((FormComponent)new FormContentIconButton(0, 0, FormInputSize.SIZE_20, ButtonColor.BASE, (ButtonTexture)Settings.UI.button_collapsed_16, new GameMessage[]{new LocalMessage("ui", "changebutton")}));
            popConfigButton.onClicked(e -> {
                this.populationThreshold.whenGreaterThan = !this.populationThreshold.whenGreaterThan;
                this.sendFullUpdatePacket(updatePacketSender);
                refreshForm.run();
            });
            FontOptions fontOptions = new FontOptions(16);
            final FormFairTypeLabel label = new FormFairTypeLabel((GameMessage)new StaticMessage(""), fontOptions, FairType.TextAlign.CENTER, form.getWidth() / 2, 0);
            Runnable updateLabel = new Runnable(){

                @Override
                public void run() {
                    DoWhenMultipleConditions.this.populationThreshold.updateLabel(label, updatePacketSender, this);
                    int buttonY = label.getY() + label.getBoundingBox().height / 2 - 8;
                    popConfigButton.setY(buttonY);
                }
            };
            this.populationThreshold.updateLabel(label, updatePacketSender, updateLabel);
            Rectangle labelBoundingBox = label.getBoundingBox();
            int thresholdY = flow.next(Math.max(labelBoundingBox.height, 24) + 4);
            label.setY(thresholdY);
            form.addComponent((FormComponent)label);
            int buttonY = thresholdY + labelBoundingBox.height / 2 - 8;
            popConfigButton.setY(buttonY);
            popConfigButton.setX(form.getWidth() / 2 - 120);
        }
        FormLocalTextButton populationButton = new FormLocalTextButton("ui", this.populationThreshold != null ? "removepopulationcondition" : "addpopulationcondition", form.getWidth() / 2 - 150, flow.next(28), 300, FormInputSize.SIZE_24, this.populationThreshold != null ? ButtonColor.RED : ButtonColor.BASE);
        populationButton.onClicked(e -> {
            this.populationThreshold = this.populationThreshold != null ? null : new PopulationThreshold(0, true);
            this.sendFullUpdatePacket(updatePacketSender);
            refreshForm.run();
        });
        form.addComponent((FormComponent)populationButton);
        flow.next(20);
        form.setHeight(flow.next());
        return form;
    }

    public class ItemThreshold {
        private final Object repeatInc = new Object();
        private final Object repeatDec = new Object();
        public Item item;
        public int threshold;
        public boolean whenGreaterThan;

        public ItemThreshold(Item item, int threshold, boolean whenGreaterThan) {
            this.item = item;
            this.threshold = threshold;
            this.whenGreaterThan = whenGreaterThan;
        }

        public ItemThreshold(LoadData save) {
            String itemStringID = save.getSafeString("itemStringID");
            this.item = ItemRegistry.getItem((String)itemStringID);
            if (this.item == null) {
                throw new LoadDataException("Could not find item with stringID: " + itemStringID);
            }
            this.threshold = save.getInt("threshold", 0);
            this.whenGreaterThan = save.getBoolean("whenGreaterThan", true);
        }

        public ItemThreshold(PacketReader reader) {
            int itemID = reader.getNextShortUnsigned();
            this.item = ItemRegistry.getItem((int)itemID);
            Objects.requireNonNull(this.item);
            this.threshold = reader.getNextInt();
            this.whenGreaterThan = reader.getNextBoolean();
        }

        public SaveData getSaveData(String name) {
            SaveData save = new SaveData(name);
            save.addSafeString("itemStringID", this.item.getStringID());
            save.addInt("threshold", this.threshold);
            save.addBoolean("whenGreaterThan", this.whenGreaterThan);
            return save;
        }

        public void writePacket(PacketWriter writer) {
            writer.putNextShortUnsigned(this.item.getID());
            writer.putNextInt(this.threshold);
            writer.putNextBoolean(this.whenGreaterThan);
        }

        public boolean isConditionMet(EntityJobWorker worker, ServerSettlementData settlementData) {
            if (worker == null || settlementData == null) {
                return false;
            }
            SettlementStorageItemIDIndex itemStorageIndex = (SettlementStorageItemIDIndex)settlementData.storageRecords.getIndex(SettlementStorageItemIDIndex.class);
            int totalItems = itemStorageIndex.getTotalItems(this.item);
            if (this.whenGreaterThan) {
                return totalItems > this.threshold;
            }
            return totalItems < this.threshold;
        }

        public void updateLabel(final FormFairTypeLabel label, final JobConditionUpdatePacketSender updatePacketSender, final Runnable updateLabel) {
            FontOptions fontOptions = label.getFontOptions();
            FairType fairType = new FairType();
            String displayText = this.whenGreaterThan ? TypeParsers.getItemParseString((InventoryItem)new InventoryItem(this.item)) + " > [[-]] " + this.threshold + " [[+]]" : TypeParsers.getItemParseString((InventoryItem)new InventoryItem(this.item)) + " < [[-]] " + this.threshold + " [[+]]";
            fairType.append(fontOptions, displayText);
            fairType.applyParsers(new TypeParser[]{TypeParsers.GAME_COLOR, TypeParsers.URL_OPEN, TypeParsers.MARKDOWN_URL, TypeParsers.ItemIcon((int)fontOptions.getSize(), (boolean)false, FairItemGlyph::onlyShowNameTooltip), TypeParsers.MobIcon((int)fontOptions.getSize()), TypeParsers.InputIcon((FontOptions)fontOptions), TypeParsers.replaceParser((String)"[[-]]", (FairGlyph[])new FairGlyph[]{new FairButtonGlyph(16, 16){

                public void handleEvent(float drawX, float drawY, InputEvent event) {
                    if ((event.getID() == -100 || event.isRepeatEvent(ItemThreshold.this.repeatDec)) && event.state) {
                        event.startRepeatEvents(new Object[]{ItemThreshold.this.repeatDec});
                        int amount = 1;
                        if (Control.INV_QUICK_MOVE.isDown()) {
                            amount = 10;
                        } else if (Control.INV_QUICK_TRASH.isDown() || Control.INV_QUICK_DROP.isDown()) {
                            amount = 100;
                        }
                        int lastRemainingTimes = ItemThreshold.this.threshold;
                        ItemThreshold.this.threshold = Math.max(0, ItemThreshold.this.threshold - amount);
                        if (lastRemainingTimes != ItemThreshold.this.threshold) {
                            if (updatePacketSender != null) {
                                DoWhenMultipleConditions.this.sendFullUpdatePacket(updatePacketSender);
                            }
                            if (event.shouldSubmitSound()) {
                                label.playTickSound();
                            }
                            updateLabel.run();
                        }
                        WindowManager.getWindow().getInput().submitNextMoveEvent();
                    }
                }

                public void draw(float x, float y, Color defaultColor) {
                    Color color = this.isHovering() ? (Color)label.getInterfaceStyle().button_minus_20.colorGetter.apply(ButtonState.HIGHLIGHTED) : (Color)label.getInterfaceStyle().button_minus_20.colorGetter.apply(ButtonState.ACTIVE);
                    label.getInterfaceStyle().button_minus_20.texture.initDraw().color(color).posMiddle((int)x + 8, (int)y - 8).draw();
                    if (this.isHovering()) {
                        Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
                    }
                }
            }}), TypeParsers.replaceParser((String)"[[+]]", (FairGlyph[])new FairGlyph[]{new FairButtonGlyph(16, 16){

                public void handleEvent(float drawX, float drawY, InputEvent event) {
                    if ((event.getID() == -100 || event.isRepeatEvent(ItemThreshold.this.repeatInc)) && event.state) {
                        event.startRepeatEvents(new Object[]{ItemThreshold.this.repeatInc});
                        int amount = 1;
                        if (Control.INV_QUICK_MOVE.isDown()) {
                            amount = 10;
                        } else if (Control.INV_QUICK_TRASH.isDown() || Control.INV_QUICK_DROP.isDown()) {
                            amount = 100;
                        }
                        int lastRemainingTimes = ItemThreshold.this.threshold;
                        ItemThreshold.this.threshold = Math.min(65535, ItemThreshold.this.threshold + amount);
                        if (lastRemainingTimes != ItemThreshold.this.threshold) {
                            if (updatePacketSender != null) {
                                DoWhenMultipleConditions.this.sendFullUpdatePacket(updatePacketSender);
                            }
                            if (event.shouldSubmitSound()) {
                                label.playTickSound();
                            }
                            updateLabel.run();
                        }
                        WindowManager.getWindow().getInput().submitNextMoveEvent();
                    }
                }

                public void draw(float x, float y, Color defaultColor) {
                    Color color = this.isHovering() ? (Color)label.getInterfaceStyle().button_plus_20.colorGetter.apply(ButtonState.HIGHLIGHTED) : (Color)label.getInterfaceStyle().button_plus_20.colorGetter.apply(ButtonState.ACTIVE);
                    label.getInterfaceStyle().button_plus_20.texture.initDraw().color(color).posMiddle((int)x + 8, (int)y - 8).draw();
                    if (this.isHovering()) {
                        Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
                    }
                }
            }})});
            label.setCustomFairType(fairType);
        }
    }

    public class SettlerTypeThreshold {
        private final Object repeatInc = new Object();
        private final Object repeatDec = new Object();
        public final Settler settler;
        public int threshold;
        public boolean whenGreaterThan;

        public SettlerTypeThreshold(Settler settler, int threshold, boolean whenGreaterThan) {
            this.settler = settler;
            this.threshold = threshold;
            this.whenGreaterThan = whenGreaterThan;
        }

        public SettlerTypeThreshold(LoadData save) {
            String settlerStringID = save.getSafeString("settlerStringID");
            this.settler = SettlerRegistry.getSettler((String)settlerStringID);
            if (this.settler == null) {
                throw new LoadDataException("Could not find settler with stringID: " + settlerStringID);
            }
            this.threshold = save.getInt("threshold", 0);
            this.whenGreaterThan = save.getBoolean("whenGreaterThan", true);
        }

        public SettlerTypeThreshold(PacketReader reader) {
            this.settler = SettlerRegistry.getSettler((int)reader.getNextShortUnsigned());
            Objects.requireNonNull(this.settler);
            this.threshold = reader.getNextInt();
            this.whenGreaterThan = reader.getNextBoolean();
        }

        public SaveData getSaveData(String name) {
            SaveData save = new SaveData(name);
            save.addSafeString("settlerStringID", this.settler.getStringID());
            save.addInt("threshold", this.threshold);
            save.addBoolean("whenGreaterThan", this.whenGreaterThan);
            return save;
        }

        public void writePacket(PacketWriter writer) {
            writer.putNextShortUnsigned(this.settler.getID());
            writer.putNextInt(this.threshold);
            writer.putNextBoolean(this.whenGreaterThan);
        }

        public boolean isConditionMet(ServerSettlementData settlementData) {
            int totalSettlers = settlementData.getSettlerCount(this.settler);
            if (this.whenGreaterThan) {
                return totalSettlers > this.threshold;
            }
            return totalSettlers < this.threshold;
        }

        public void updateLabel(final FormFairTypeLabel label, final JobConditionUpdatePacketSender updatePacketSender, final Runnable updateLabel) {
            FontOptions fontOptions = label.getFontOptions();
            FairType fairType = new FairType();
            String displayText = this.whenGreaterThan ? this.settler.getGenericMobName() + " > [[-]] " + this.threshold + " [[+]]" : this.settler.getGenericMobName() + " < [[-]] " + this.threshold + " [[+]]";
            fairType.append(fontOptions, displayText);
            fairType.applyParsers(new TypeParser[]{TypeParsers.GAME_COLOR, TypeParsers.URL_OPEN, TypeParsers.MARKDOWN_URL, TypeParsers.ItemIcon((int)fontOptions.getSize(), (boolean)false, FairItemGlyph::onlyShowNameTooltip), TypeParsers.MobIcon((int)fontOptions.getSize()), TypeParsers.InputIcon((FontOptions)fontOptions), TypeParsers.replaceParser((String)"[[-]]", (FairGlyph[])new FairGlyph[]{new FairButtonGlyph(16, 16){

                public void handleEvent(float drawX, float drawY, InputEvent event) {
                    if ((event.getID() == -100 || event.isRepeatEvent(SettlerTypeThreshold.this.repeatDec)) && event.state) {
                        event.startRepeatEvents(new Object[]{SettlerTypeThreshold.this.repeatDec});
                        int amount = 1;
                        if (Control.INV_QUICK_MOVE.isDown()) {
                            amount = 10;
                        } else if (Control.INV_QUICK_TRASH.isDown() || Control.INV_QUICK_DROP.isDown()) {
                            amount = 100;
                        }
                        int lastRemainingTimes = SettlerTypeThreshold.this.threshold;
                        SettlerTypeThreshold.this.threshold = Math.max(0, SettlerTypeThreshold.this.threshold - amount);
                        if (lastRemainingTimes != SettlerTypeThreshold.this.threshold) {
                            if (updatePacketSender != null) {
                                DoWhenMultipleConditions.this.sendFullUpdatePacket(updatePacketSender);
                            }
                            if (event.shouldSubmitSound()) {
                                label.playTickSound();
                            }
                            updateLabel.run();
                        }
                        WindowManager.getWindow().getInput().submitNextMoveEvent();
                    }
                }

                public void draw(float x, float y, Color defaultColor) {
                    Color color = this.isHovering() ? (Color)label.getInterfaceStyle().button_minus_20.colorGetter.apply(ButtonState.HIGHLIGHTED) : (Color)label.getInterfaceStyle().button_minus_20.colorGetter.apply(ButtonState.ACTIVE);
                    label.getInterfaceStyle().button_minus_20.texture.initDraw().color(color).posMiddle((int)x + 8, (int)y - 8).draw();
                    if (this.isHovering()) {
                        Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
                    }
                }
            }}), TypeParsers.replaceParser((String)"[[+]]", (FairGlyph[])new FairGlyph[]{new FairButtonGlyph(16, 16){

                public void handleEvent(float drawX, float drawY, InputEvent event) {
                    if ((event.getID() == -100 || event.isRepeatEvent(SettlerTypeThreshold.this.repeatInc)) && event.state) {
                        event.startRepeatEvents(new Object[]{SettlerTypeThreshold.this.repeatInc});
                        int amount = 1;
                        if (Control.INV_QUICK_MOVE.isDown()) {
                            amount = 10;
                        } else if (Control.INV_QUICK_TRASH.isDown() || Control.INV_QUICK_DROP.isDown()) {
                            amount = 100;
                        }
                        int lastRemainingTimes = SettlerTypeThreshold.this.threshold;
                        SettlerTypeThreshold.this.threshold = Math.min(65535, SettlerTypeThreshold.this.threshold + amount);
                        if (lastRemainingTimes != SettlerTypeThreshold.this.threshold) {
                            if (updatePacketSender != null) {
                                DoWhenMultipleConditions.this.sendFullUpdatePacket(updatePacketSender);
                            }
                            if (event.shouldSubmitSound()) {
                                label.playTickSound();
                            }
                            updateLabel.run();
                        }
                        WindowManager.getWindow().getInput().submitNextMoveEvent();
                    }
                }

                public void draw(float x, float y, Color defaultColor) {
                    Color color = this.isHovering() ? (Color)label.getInterfaceStyle().button_plus_20.colorGetter.apply(ButtonState.HIGHLIGHTED) : (Color)label.getInterfaceStyle().button_plus_20.colorGetter.apply(ButtonState.ACTIVE);
                    label.getInterfaceStyle().button_plus_20.texture.initDraw().color(color).posMiddle((int)x + 8, (int)y - 8).draw();
                    if (this.isHovering()) {
                        Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
                    }
                }
            }})});
            label.setCustomFairType(fairType);
        }
    }

    public class PopulationThreshold {
        private final Object repeatInc = new Object();
        private final Object repeatDec = new Object();
        public int threshold;
        public boolean whenGreaterThan;

        public PopulationThreshold(int threshold, boolean whenGreaterThan) {
            this.threshold = threshold;
            this.whenGreaterThan = whenGreaterThan;
        }

        public PopulationThreshold(LoadData save) {
            this.threshold = save.getInt("threshold", 0);
            this.whenGreaterThan = save.getBoolean("whenGreaterThan", true);
        }

        public PopulationThreshold(PacketReader reader) {
            this.threshold = reader.getNextInt();
            this.whenGreaterThan = reader.getNextBoolean();
        }

        public SaveData getSaveData(String name) {
            SaveData save = new SaveData(name);
            save.addInt("threshold", this.threshold);
            save.addBoolean("whenGreaterThan", this.whenGreaterThan);
            return save;
        }

        public void writePacket(PacketWriter writer) {
            writer.putNextInt(this.threshold);
            writer.putNextBoolean(this.whenGreaterThan);
        }

        public boolean isConditionMet(ServerSettlementData settlementData) {
            int currentPopulation = settlementData.countTotalSettlers();
            if (this.whenGreaterThan) {
                return currentPopulation > this.threshold;
            }
            return currentPopulation < this.threshold;
        }

        public void updateLabel(final FormFairTypeLabel label, final JobConditionUpdatePacketSender updatePacketSender, final Runnable updateLabel) {
            FontOptions fontOptions = label.getFontOptions();
            FairType fairType = new FairType();
            String populationText = new LocalMessage("ui", "population").translate();
            String displayText = this.whenGreaterThan ? populationText + " > [[-]] " + this.threshold + " [[+]]" : populationText + " < [[-]] " + this.threshold + " [[+]]";
            fairType.append(fontOptions, displayText);
            fairType.applyParsers(new TypeParser[]{TypeParsers.GAME_COLOR, TypeParsers.URL_OPEN, TypeParsers.MARKDOWN_URL, TypeParsers.ItemIcon((int)fontOptions.getSize(), (boolean)false, FairItemGlyph::onlyShowNameTooltip), TypeParsers.MobIcon((int)fontOptions.getSize()), TypeParsers.InputIcon((FontOptions)fontOptions), TypeParsers.replaceParser((String)"[[-]]", (FairGlyph[])new FairGlyph[]{new FairButtonGlyph(16, 16){

                public void handleEvent(float drawX, float drawY, InputEvent event) {
                    if ((event.getID() == -100 || event.isRepeatEvent(PopulationThreshold.this.repeatDec)) && event.state) {
                        event.startRepeatEvents(new Object[]{PopulationThreshold.this.repeatDec});
                        int amount = 1;
                        if (Control.INV_QUICK_MOVE.isDown()) {
                            amount = 10;
                        } else if (Control.INV_QUICK_TRASH.isDown() || Control.INV_QUICK_DROP.isDown()) {
                            amount = 100;
                        }
                        int lastRemainingTimes = PopulationThreshold.this.threshold;
                        PopulationThreshold.this.threshold = Math.max(0, PopulationThreshold.this.threshold - amount);
                        if (lastRemainingTimes != PopulationThreshold.this.threshold) {
                            if (updatePacketSender != null) {
                                DoWhenMultipleConditions.this.sendFullUpdatePacket(updatePacketSender);
                            }
                            if (event.shouldSubmitSound()) {
                                label.playTickSound();
                            }
                            updateLabel.run();
                        }
                        WindowManager.getWindow().getInput().submitNextMoveEvent();
                    }
                }

                public void draw(float x, float y, Color defaultColor) {
                    Color color = this.isHovering() ? (Color)label.getInterfaceStyle().button_minus_20.colorGetter.apply(ButtonState.HIGHLIGHTED) : (Color)label.getInterfaceStyle().button_minus_20.colorGetter.apply(ButtonState.ACTIVE);
                    label.getInterfaceStyle().button_minus_20.texture.initDraw().color(color).posMiddle((int)x + 8, (int)y - 8).draw();
                    if (this.isHovering()) {
                        Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
                    }
                }
            }}), TypeParsers.replaceParser((String)"[[+]]", (FairGlyph[])new FairGlyph[]{new FairButtonGlyph(16, 16){

                public void handleEvent(float drawX, float drawY, InputEvent event) {
                    if ((event.getID() == -100 || event.isRepeatEvent(PopulationThreshold.this.repeatInc)) && event.state) {
                        event.startRepeatEvents(new Object[]{PopulationThreshold.this.repeatInc});
                        int amount = 1;
                        if (Control.INV_QUICK_MOVE.isDown()) {
                            amount = 10;
                        } else if (Control.INV_QUICK_TRASH.isDown() || Control.INV_QUICK_DROP.isDown()) {
                            amount = 100;
                        }
                        int lastRemainingTimes = PopulationThreshold.this.threshold;
                        PopulationThreshold.this.threshold = Math.min(65535, PopulationThreshold.this.threshold + amount);
                        if (lastRemainingTimes != PopulationThreshold.this.threshold) {
                            if (updatePacketSender != null) {
                                DoWhenMultipleConditions.this.sendFullUpdatePacket(updatePacketSender);
                            }
                            if (event.shouldSubmitSound()) {
                                label.playTickSound();
                            }
                            updateLabel.run();
                        }
                        WindowManager.getWindow().getInput().submitNextMoveEvent();
                    }
                }

                public void draw(float x, float y, Color defaultColor) {
                    Color color = this.isHovering() ? (Color)label.getInterfaceStyle().button_plus_20.colorGetter.apply(ButtonState.HIGHLIGHTED) : (Color)label.getInterfaceStyle().button_plus_20.colorGetter.apply(ButtonState.ACTIVE);
                    label.getInterfaceStyle().button_plus_20.texture.initDraw().color(color).posMiddle((int)x + 8, (int)y - 8).draw();
                    if (this.isHovering()) {
                        Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
                    }
                }
            }})});
            label.setCustomFairType(fairType);
        }
    }
}

