/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.lang.reflect.Field;
import mod.AlchemistFindingExpedition;
import mod.AnglerFindingExpedition;
import mod.AnimalKeeperFindingExpedition;
import mod.BlacksmithFindingExpedition;
import mod.ExoticMerchantFindingExpedition;
import mod.ExplorerFindingExpedition;
import mod.FarmerFindingExpedition;
import mod.GenericFindingExpedition;
import mod.GunsmithFindingExpedition;
import mod.HunterFindingExpedition;
import mod.MageFindingExpedition;
import mod.MinerFindingExpedition;
import mod.PawnBrokerFindingExpedition;
import mod.PirateFindingExpedition;
import mod.SettlerFindingMod;
import mod.StylistFindingExpedition;
import mod.TraderFindingExpedition;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.registries.SettlerRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.mobs.friendly.human.humanShop.explorerMission.ExpeditionMission;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.LevelSettler;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.settler.Settler;
import necesse.level.maps.levelData.settlementData.settler.SettlerMob;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=ExpeditionMission.class, name="endMission", arguments={HumanMob.class})
public class SettlerFindingMissionPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This Object missionObj, @Advice.Argument(value=0) HumanMob mob) {
        try {
            Field successField = missionObj.getClass().getDeclaredField("success");
            Field expeditionField = missionObj.getClass().getDeclaredField("expedition");
            successField.setAccessible(true);
            expeditionField.setAccessible(true);
            boolean success = (Boolean)successField.get(missionObj);
            Object expeditionObj = expeditionField.get(missionObj);
            if (success) {
                SettlerFindingMissionPatch.handleExpeditionCompletion(expeditionObj, mob);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleExpeditionCompletion(Object expeditionObj, HumanMob mob) {
        if (expeditionObj instanceof FarmerFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[0])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "farmer", "\u519c\u592b");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[0]);
        } else if (expeditionObj instanceof BlacksmithFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[1])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "blacksmith", "\u5320\u4eba");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[1]);
        } else if (expeditionObj instanceof MageFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[2])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "mage", "\u6cd5\u5e08");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[2]);
        } else if (expeditionObj instanceof HunterFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[3])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "hunter", "\u730e\u9b54\u4eba");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[3]);
        } else if (expeditionObj instanceof GunsmithFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[4])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "gunsmith", "\u706b\u5668\u5320");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[4]);
        } else if (expeditionObj instanceof AlchemistFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[5])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "alchemist", "\u836f\u5e08");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[5]);
        } else if (expeditionObj instanceof AnglerFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[6])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "angler", "\u6e14\u592b");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[6]);
        } else if (expeditionObj instanceof PawnBrokerFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[7])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "pawnbroker", "\u8d2a\u5a6a\u5546\u4eba");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[7]);
        } else if (expeditionObj instanceof TraderFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[8])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "trader", "\u884c\u5546");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[8]);
        } else if (expeditionObj instanceof ExoticMerchantFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[9])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "exoticmerchant", "\u5f02\u57df\u5546\u4eba");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[9]);
        } else if (expeditionObj instanceof ExplorerFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[10])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "explorer", "\u6e38\u65b9\u58eb");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[10]);
        } else if (expeditionObj instanceof MinerFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[11])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "miner", "\u77ff\u5de5");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[11]);
        } else if (expeditionObj instanceof AnimalKeeperFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[12])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "animalkeeper", "\u9972\u517b\u5458");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[12]);
        } else if (expeditionObj instanceof StylistFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[13])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "stylist", "\u9020\u578b\u5e08");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[13]);
        } else if (expeditionObj instanceof PirateFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[14])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "pirate", "\u4ea1\u547d\u6d77\u76d7");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[14]);
        } else if (expeditionObj instanceof GenericFindingExpedition && SettlerFindingMissionPatch.hasMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[15])) {
            SettlerFindingMissionPatch.spawnFoundSettler(mob, "generic", "\u6751\u592b");
            SettlerFindingMissionPatch.removeMarkerItem(mob, SettlerFindingMod.MARKER_ITEMS[15]);
        }
    }

    public static boolean spawnFoundSettler(HumanMob mob, String settlerId, String settlerType) {
        try {
            ServerSettlementData settlement = mob.getSettlerSettlementServerData();
            if (settlement == null) {
                return false;
            }
            Settler settler = SettlerRegistry.getSettler((String)settlerId);
            if (settler == null) {
                return false;
            }
            SettlerMob settlerMob = settler.getNewSettlerMob(settlement);
            if (settlerMob == null) {
                return false;
            }
            Mob generatedMob = settlerMob.getMob();
            if (generatedMob instanceof HumanMob) {
                HumanMob human = (HumanMob)generatedMob;
                settlerMob.setSettlerSeed(GameRandom.globalRandom.nextInt(), true);
                settlement.getLevel().entityManager.mobs.add((Entity)generatedMob);
                LevelSettler levelSettler = new LevelSettler(settlement, settlerMob);
                settlement.moveIn(levelSettler);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasMarkerItem(HumanMob mob, String itemId) {
        for (InventoryItem item : mob.getWorkInventory().items()) {
            if (item == null || !itemId.equals(item.item.getStringID())) continue;
            return true;
        }
        return false;
    }

    public static void removeMarkerItem(HumanMob mob, String itemId) {
        try {
            for (InventoryItem item : mob.getWorkInventory().items()) {
                if (item == null || !itemId.equals(item.item.getStringID())) continue;
                if (item.getAmount() > 1) {
                    item.setAmount(item.getAmount() - 1);
                } else {
                    item.setAmount(0);
                }
                mob.getWorkInventory().markDirty();
                mob.sendWorkUpdatePacket();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

