/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.List;
import mod.SettlerFindingMod;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class HunterFindingExpedition
extends SettlerExpedition {
    public HunterFindingExpedition() {
        this.initDisplayName();
        this.setCategory("settlerfinding");
    }

    public void initDisplayName() {
        this.displayName = new LocalMessage("expedition", "hunterfinding");
    }

    public GameMessage getUnavailableMessage() {
        return new LocalMessage("expedition", "hunterfindingunavailable");
    }

    public boolean isAvailable(ServerSettlementData settlement) {
        return this.getSuccessChance(settlement) > 0.0f;
    }

    public float getSuccessChance(ServerSettlementData settlement) {
        if (settlement == null) {
            return 0.0f;
        }
        if (HunterFindingExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"ancientvulture") <= 0.0f) {
            return 0.0f;
        }
        int completedTiers = settlement.getQuestTiersCompleted();
        float baseChance = 0.45f + (float)completedTiers * 0.07f;
        return Math.min(baseChance, 0.75f);
    }

    public int getBaseCost(ServerSettlementData settlement) {
        return 1300;
    }

    public List<InventoryItem> getRewardItems(ServerSettlementData settlement, HumanMob mob) {
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        rewards.add(new InventoryItem("coin", 90));
        rewards.add(new InventoryItem(SettlerFindingMod.MARKER_ITEMS[3], 1));
        return rewards;
    }

    public List<InventoryItem> getItemIcons() {
        ArrayList<InventoryItem> icons = new ArrayList<InventoryItem>();
        icons.add(new InventoryItem(SettlerFindingMod.MARKER_ITEMS[3]));
        return icons;
    }

    public int getTicksToComplete() {
        return GameRandom.globalRandom.getIntBetween(9500, 14500);
    }
}

