/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.List;
import mod.SettlerFindingMod;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class GunsmithFindingExpedition
extends SettlerExpedition {
    public GunsmithFindingExpedition() {
        this.initDisplayName();
        this.setCategory("settlerfinding");
    }

    public void initDisplayName() {
        this.displayName = new LocalMessage("expedition", "gunsmithfinding");
    }

    public GameMessage getUnavailableMessage() {
        return new LocalMessage("expedition", "gunsmithfindingunavailable");
    }

    public boolean isAvailable(ServerSettlementData settlement) {
        return this.getSuccessChance(settlement) > 0.0f;
    }

    public float getSuccessChance(ServerSettlementData settlement) {
        if (settlement == null) {
            return 0.0f;
        }
        if (GunsmithFindingExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"evilsprotector") <= 0.0f) {
            return 0.0f;
        }
        int completedTiers = settlement.getQuestTiersCompleted();
        float baseChance = 0.35f + (float)completedTiers * 0.05f;
        return Math.min(baseChance, 0.65f);
    }

    public int getBaseCost(ServerSettlementData settlement) {
        return 2000;
    }

    public List<InventoryItem> getRewardItems(ServerSettlementData settlement, HumanMob mob) {
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        rewards.add(new InventoryItem("coin", 120));
        rewards.add(new InventoryItem(SettlerFindingMod.MARKER_ITEMS[4], 1));
        return rewards;
    }

    public List<InventoryItem> getItemIcons() {
        ArrayList<InventoryItem> icons = new ArrayList<InventoryItem>();
        icons.add(new InventoryItem(SettlerFindingMod.MARKER_ITEMS[4]));
        return icons;
    }

    public int getTicksToComplete() {
        return GameRandom.globalRandom.getIntBetween(11000, 17000);
    }
}

