/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mod.SettlerFindingManager;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.registries.ExpeditionMissionRegistry;
import necesse.entity.mobs.friendly.human.ExpeditionList;
import necesse.entity.mobs.friendly.human.humanShop.ExplorerHumanMob;
import necesse.entity.mobs.friendly.human.humanShop.HumanShop;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=ExplorerHumanMob.class, name="getPossibleExpeditions", arguments={})
public class ExplorerGetSettlerFindingExpeditionsPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This ExplorerHumanMob mob, @Advice.Return(readOnly=false) List returnValue) {
        System.out.println("=== \u63a2\u9669\u5bb6\u8865\u4e01\u6267\u884c ===");
        ServerSettlementData data = mob.getSettlerSettlementServerData();
        if (data != null && mob.isSettlerWithinSettlement(data.networkData)) {
            ArrayList<SettlerExpedition> allExpeditions = new ArrayList<SettlerExpedition>();
            allExpeditions.addAll(ExpeditionMissionRegistry.explorerExpeditionIDs.stream().map(ExpeditionMissionRegistry::getExpedition).collect(Collectors.toList()));
            allExpeditions.addAll(SettlerFindingManager.getSettlerFindingExpeditions());
            ExpeditionList combinedExpeditions = new ExpeditionList((GameMessage)new LocalMessage("ui", "explorerexpeditions"), (GameMessage)new LocalMessage("ui", "explorerselectexp"), (GameMessage)new LocalMessage("ui", "explorerexpcost"), (GameMessage)new LocalMessage("ui", "explorershowmore"), data, (HumanShop)mob, allExpeditions);
            returnValue = Collections.singletonList(combinedExpeditions);
        }
    }
}

