/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.List;
import mod.SettlerFindingMod;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class ExoticMerchantFindingExpedition
extends SettlerExpedition {
    public ExoticMerchantFindingExpedition() {
        this.initDisplayName();
        this.setCategory("settlerfinding");
    }

    public void initDisplayName() {
        this.displayName = new LocalMessage("expedition", "exoticmerchantfinding");
    }

    public GameMessage getUnavailableMessage() {
        return new LocalMessage("expedition", "exoticmerchantfindingunavailable");
    }

    public boolean isAvailable(ServerSettlementData settlement) {
        return this.getSuccessChance(settlement) > 0.0f;
    }

    public float getSuccessChance(ServerSettlementData settlement) {
        if (settlement == null) {
            return 0.0f;
        }
        int completedTiers = settlement.getQuestTiersCompleted();
        float baseChance = 0.25f + (float)completedTiers * 0.03f;
        return Math.min(baseChance, 0.55f);
    }

    public int getBaseCost(ServerSettlementData settlement) {
        return 3000;
    }

    public List<InventoryItem> getRewardItems(ServerSettlementData settlement, HumanMob mob) {
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        rewards.add(new InventoryItem("coin", 200));
        rewards.add(new InventoryItem(SettlerFindingMod.MARKER_ITEMS[9], 1));
        return rewards;
    }

    public List<InventoryItem> getItemIcons() {
        ArrayList<InventoryItem> icons = new ArrayList<InventoryItem>();
        icons.add(new InventoryItem(SettlerFindingMod.MARKER_ITEMS[9]));
        return icons;
    }

    public int getTicksToComplete() {
        return GameRandom.globalRandom.getIntBetween(13000, 19000);
    }
}

