/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.List;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class VeteranRecruitmentExpedition
extends SettlerExpedition {
    public VeteranRecruitmentExpedition() {
        this.initDisplayName();
        this.setCategory("recruitment");
    }

    public void initDisplayName() {
        this.displayName = new LocalMessage("expedition", "veteranrecruit");
    }

    public GameMessage getUnavailableMessage() {
        return new LocalMessage("expedition", "veteranrecruitunavailable");
    }

    public boolean isAvailable(ServerSettlementData settlement) {
        return this.getSuccessChance(settlement) > 0.0f;
    }

    public float getSuccessChance(ServerSettlementData settlement) {
        if (settlement == null) {
            return 0.0f;
        }
        if (VeteranRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"cryoqueen") <= 0.0f) {
            return 0.0f;
        }
        int completedTiers = settlement.getQuestTiersCompleted();
        float baseChance = 0.2f + (float)completedTiers * 0.05f;
        return Math.min(baseChance, 0.6f);
    }

    public int getBaseCost(ServerSettlementData settlement) {
        return 75000;
    }

    public List<InventoryItem> getRewardItems(ServerSettlementData settlement, HumanMob mob) {
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        rewards.add(new InventoryItem("coin", 100));
        rewards.add(new InventoryItem("agedchampionsword", 1));
        return rewards;
    }

    public List<InventoryItem> getItemIcons() {
        ArrayList<InventoryItem> icons = new ArrayList<InventoryItem>();
        icons.add(new InventoryItem("agedchampionhelmet"));
        return icons;
    }

    public int getTicksToComplete() {
        return GameRandom.globalRandom.getIntBetween(20000, 30000);
    }
}

