/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameRandom;
import necesse.engine.util.TicketSystemList;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class LotteryRecruitmentExpedition
extends SettlerExpedition {
    public LotteryRecruitmentExpedition() {
        this.initDisplayName();
        this.setCategory("recruitment");
    }

    public void initDisplayName() {
        this.displayName = new LocalMessage("expedition", "lotteryrecruit");
    }

    public GameMessage getUnavailableMessage() {
        return new LocalMessage("expedition", "lotteryrecruitunavailable");
    }

    public boolean isAvailable(ServerSettlementData settlement) {
        return this.getSuccessChance(settlement) > 0.0f;
    }

    public float getSuccessChance(ServerSettlementData settlement) {
        if (settlement == null) {
            return 0.0f;
        }
        int completedTiers = settlement.getQuestTiersCompleted();
        float baseChance = 0.4f + (float)completedTiers * 0.06f;
        return Math.min(baseChance, 0.8f);
    }

    public int getBaseCost(ServerSettlementData settlement) {
        int availableRanks = LotteryRecruitmentExpedition.getAvailableRankCount(settlement);
        switch (availableRanks) {
            case 2: {
                return 750;
            }
            case 3: {
                return 3000;
            }
            case 4: {
                return 10000;
            }
            case 5: {
                return 40000;
            }
            case 6: {
                return 50000;
            }
        }
        return 50000;
    }

    public static int getAvailableRankCount(ServerSettlementData settlement) {
        int count = 2;
        if (LotteryRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"chieftain") > 0.0f) {
            ++count;
        }
        if (LotteryRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"piratecaptain") > 0.0f) {
            ++count;
        }
        if (LotteryRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"reaper") > 0.0f) {
            ++count;
        }
        if (LotteryRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"sageandgrit") > 0.0f) {
            ++count;
        }
        return count;
    }

    public List<InventoryItem> getRewardItems(ServerSettlementData settlement, HumanMob mob) {
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        rewards.add(new InventoryItem("christmaspresent", 1));
        if (GameRandom.globalRandom.getChance(0.2f)) {
            int coinAmount = GameRandom.globalRandom.getIntBetween(10000, 100000);
            rewards.add(new InventoryItem("coin", coinAmount));
            System.out.println("\u62bd\u5956\u62db\u52df\uff1a\u83b7\u5f97\u989d\u5916\u91d1\u5e01\u5956\u52b1 " + coinAmount);
        }
        return rewards;
    }

    public List<InventoryItem> getItemIcons() {
        ArrayList<InventoryItem> icons = new ArrayList<InventoryItem>();
        icons.add(new InventoryItem("christmaspresent"));
        return icons;
    }

    public int getTicksToComplete() {
        return GameRandom.globalRandom.getIntBetween(15000, 25000);
    }

    public static String getAvailableRank(ServerSettlementData settlement) {
        TicketSystemList rankWeights = new TicketSystemList().addObject(100, (Object)"F").addObject(250, (Object)"D");
        if (LotteryRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"chieftain") > 0.0f) {
            rankWeights.addObject(400, (Object)"C");
        }
        if (LotteryRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"piratecaptain") > 0.0f) {
            rankWeights.addObject(150, (Object)"B");
        }
        if (LotteryRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"reaper") > 0.0f) {
            rankWeights.addObject(70, (Object)"A");
        }
        if (LotteryRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"sageandgrit") > 0.0f) {
            rankWeights.addObject(30, (Object)"S");
        }
        if (rankWeights.getTotalTickets() == 0L) {
            return null;
        }
        return (String)rankWeights.getRandomObject((Random)GameRandom.globalRandom);
    }
}

