/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mod.CowboyRecruitmentExpedition;
import mod.GuardRecruitmentExpedition;
import mod.LotteryRecruitmentExpedition;
import mod.SoldierRecruitmentExpedition;
import mod.ThiefRecruitmentExpedition;
import mod.VeteranRecruitmentExpedition;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.SettlerRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.mobs.friendly.human.humanShop.explorerMission.ExpeditionMission;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.LevelSettler;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.settler.Settler;
import necesse.level.maps.levelData.settlementData.settler.SettlerMob;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=ExpeditionMission.class, name="endMission", arguments={HumanMob.class})
public class GuardRecruitmentMissionPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This Object missionObj, @Advice.Argument(value=0) HumanMob mob) {
        try {
            Field successField = missionObj.getClass().getDeclaredField("success");
            Field expeditionField = missionObj.getClass().getDeclaredField("expedition");
            successField.setAccessible(true);
            expeditionField.setAccessible(true);
            boolean success = (Boolean)successField.get(missionObj);
            Object expeditionObj = expeditionField.get(missionObj);
            if (success) {
                if (expeditionObj instanceof GuardRecruitmentExpedition) {
                    boolean spawnSuccess;
                    if (GuardRecruitmentMissionPatch.hasMarkerItem(mob, "ironsword") && (spawnSuccess = GuardRecruitmentMissionPatch.spawnRecruitedSettler(mob, GuardRecruitmentMissionPatch.getGuardEquipment(), "\u5b88\u536b"))) {
                        GuardRecruitmentMissionPatch.removeMarkerItem(mob, "ironsword");
                    }
                } else if (expeditionObj instanceof SoldierRecruitmentExpedition) {
                    boolean spawnSuccess;
                    if (GuardRecruitmentMissionPatch.hasMarkerItem(mob, "reanimationbow") && (spawnSuccess = GuardRecruitmentMissionPatch.spawnRecruitedSettler(mob, GuardRecruitmentMissionPatch.getSoldierEquipment(), "\u58eb\u5175"))) {
                        GuardRecruitmentMissionPatch.removeMarkerItem(mob, "reanimationbow");
                    }
                } else if (expeditionObj instanceof ThiefRecruitmentExpedition) {
                    boolean spawnSuccess;
                    if (GuardRecruitmentMissionPatch.hasMarkerItem(mob, "captorsshortbow") && (spawnSuccess = GuardRecruitmentMissionPatch.spawnRecruitedSettler(mob, GuardRecruitmentMissionPatch.getThiefEquipment(), "\u76d7\u8d3c"))) {
                        GuardRecruitmentMissionPatch.removeMarkerItem(mob, "captorsshortbow");
                    }
                } else if (expeditionObj instanceof VeteranRecruitmentExpedition) {
                    boolean spawnSuccess;
                    if (GuardRecruitmentMissionPatch.hasMarkerItem(mob, "agedchampionsword") && (spawnSuccess = GuardRecruitmentMissionPatch.spawnRecruitedSettler(mob, GuardRecruitmentMissionPatch.getVeteranEquipment(), "\u5386\u6218\u738b"))) {
                        GuardRecruitmentMissionPatch.removeMarkerItem(mob, "agedchampionsword");
                    }
                } else if (expeditionObj instanceof CowboyRecruitmentExpedition) {
                    boolean spawnSuccess;
                    if (GuardRecruitmentMissionPatch.hasMarkerItem(mob, "sixshooter") && (spawnSuccess = GuardRecruitmentMissionPatch.spawnRecruitedSettler(mob, GuardRecruitmentMissionPatch.getCowboyEquipment(), "\u725b\u4ed4"))) {
                        GuardRecruitmentMissionPatch.removeMarkerItem(mob, "sixshooter");
                    }
                } else if (expeditionObj instanceof LotteryRecruitmentExpedition && GuardRecruitmentMissionPatch.hasMarkerItem(mob, "christmaspresent")) {
                    String rank = LotteryRecruitmentExpedition.getAvailableRank(mob.getSettlerSettlementServerData());
                    if (rank != null) {
                        boolean spawnSuccess;
                        List<InventoryItem> equipment = GuardRecruitmentMissionPatch.getLotteryEquipment(rank);
                        if (equipment != null && (spawnSuccess = GuardRecruitmentMissionPatch.spawnRecruitedSettler(mob, equipment, "\u62bd\u5956-" + rank))) {
                            GuardRecruitmentMissionPatch.removeMarkerItem(mob, "christmaspresent");
                            ServerSettlementData settlement = mob.getSettlerSettlementServerData();
                            if (settlement != null && settlement.networkData != null) {
                                List clients = settlement.networkData.streamTeamMembers().collect(Collectors.toList());
                                int messageNumber = GameRandom.globalRandom.getIntBetween(1, 8);
                                String messageKey = "lotterymessage" + messageNumber;
                                for (ServerClient client : clients) {
                                    if (client == null) continue;
                                    client.sendChatMessage((GameMessage)new LocalMessage("recruitment", messageKey, new String[]{"settler", mob.getDisplayName(), "rank", rank}));
                                }
                            }
                        }
                    } else {
                        System.out.println("\u7edd\u5730\u63a2\u9669\uff1a\u6ca1\u6709\u53ef\u7528\u7684\u7b49\u7ea7");
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u62db\u52df\u4efb\u52a1\u5904\u7406\u9519\u8bef: " + e.getMessage());
        }
    }

    public static List<InventoryItem> getGuardEquipment() {
        return Arrays.asList(new InventoryItem("ironhelmet"), new InventoryItem("ironchestplate"), new InventoryItem("ironboots"), new InventoryItem("ironsword"));
    }

    public static List<InventoryItem> getSoldierEquipment() {
        return Arrays.asList(new InventoryItem("soldierhelmet"), new InventoryItem("soldierchestplate"), new InventoryItem("soldierboots"), new InventoryItem("reanimationbow"));
    }

    public static List<InventoryItem> getThiefEquipment() {
        return Arrays.asList(new InventoryItem("thiefscowl"), new InventoryItem("thiefscloak"), new InventoryItem("thiefsboots"), new InventoryItem("captorsshortbow"));
    }

    public static List<InventoryItem> getVeteranEquipment() {
        return Arrays.asList(new InventoryItem("agedchampionhelmet"), new InventoryItem("agedchampionchestplate"), new InventoryItem("agedchampiongreaves"), new InventoryItem("agedchampionsword"));
    }

    public static List<InventoryItem> getCowboyEquipment() {
        return Arrays.asList(new InventoryItem("gunslingerhat"), new InventoryItem("gunslingervest"), new InventoryItem("gunslingerboots"), new InventoryItem("sixshooter"));
    }

    public static boolean spawnRecruitedSettler(HumanMob mob, List<InventoryItem> equipment, String settlerType) {
        try {
            ServerSettlementData settlement = mob.getSettlerSettlementServerData();
            if (settlement == null) {
                return false;
            }
            Settler settler = SettlerRegistry.getSettler((String)"guard");
            if (settler == null) {
                return false;
            }
            SettlerMob settlerMob = settler.getNewSettlerMob(settlement);
            if (settlerMob == null) {
                return false;
            }
            Mob generatedMob = settlerMob.getMob();
            if (generatedMob instanceof HumanMob) {
                HumanMob human = (HumanMob)generatedMob;
                GuardRecruitmentMissionPatch.applyEquipmentSet(human, equipment);
                settlerMob.setSettlerSeed(GameRandom.globalRandom.nextInt(), true);
                settlement.getLevel().entityManager.mobs.add((Entity)generatedMob);
                LevelSettler levelSettler = new LevelSettler(settlement, settlerMob);
                settlement.moveIn(levelSettler);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("\u751f\u6210\u5b9a\u5c45\u8005\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public static void applyEquipmentSet(HumanMob human, List<InventoryItem> equipment) {
        try {
            if (equipment.size() >= 4) {
                human.equipmentInventory.setItem(0, equipment.get(0));
                human.equipmentInventory.setItem(1, equipment.get(1));
                human.equipmentInventory.setItem(2, equipment.get(2));
                human.equipmentInventory.setItem(6, equipment.get(3));
                human.equipmentBuffManager.updateAll();
                human.updateStats(true);
            }
        }
        catch (Exception e) {
            System.err.println("\u5e94\u7528\u88c5\u5907\u5931\u8d25: " + e.getMessage());
        }
    }

    public static boolean hasMarkerItem(HumanMob mob, String itemId) {
        for (InventoryItem item : mob.getWorkInventory().items()) {
            if (item == null || !itemId.equals(item.item.getStringID())) continue;
            return true;
        }
        return false;
    }

    public static void removeMarkerItem(HumanMob mob, String itemId) {
        try {
            for (InventoryItem item : mob.getWorkInventory().items()) {
                if (item == null || !itemId.equals(item.item.getStringID())) continue;
                if (item.getAmount() > 1) {
                    item.setAmount(item.getAmount() - 1);
                } else {
                    item.setAmount(0);
                }
                mob.getWorkInventory().markDirty();
                mob.sendWorkUpdatePacket();
                break;
            }
        }
        catch (Exception e) {
            System.err.println("\u79fb\u9664\u6807\u8bb0\u7269\u54c1\u5931\u8d25: " + e.getMessage());
        }
    }

    public static List<InventoryItem> getLotteryEquipment(String rank) {
        try {
            String countKey = "lottery." + rank.toLowerCase() + ".count";
            String countStr = GuardRecruitmentMissionPatch.getLocalizedString(countKey);
            if (countStr == null) {
                return null;
            }
            int count = Integer.parseInt(countStr);
            if (count <= 0) {
                return null;
            }
            int selected = GameRandom.globalRandom.getIntBetween(1, count);
            String prefix = "lottery." + rank.toLowerCase() + "." + selected;
            String helmet = GuardRecruitmentMissionPatch.getLocalizedString(prefix + ".helmet");
            String bodyarmor = GuardRecruitmentMissionPatch.getLocalizedString(prefix + ".bodyarmor");
            String boots = GuardRecruitmentMissionPatch.getLocalizedString(prefix + ".boots");
            String weapon = GuardRecruitmentMissionPatch.getLocalizedString(prefix + ".weapon");
            if (helmet != null && bodyarmor != null && boots != null && weapon != null) {
                return Arrays.asList(new InventoryItem(helmet), new InventoryItem(bodyarmor), new InventoryItem(boots), new InventoryItem(weapon));
            }
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u62bd\u5956\u88c5\u5907\u5931\u8d25: " + e.getMessage());
        }
        return null;
    }

    public static String getLocalizedString(String key) {
        try {
            return Localization.translate((String)"lotterypools", (String)key);
        }
        catch (Exception e) {
            return null;
        }
    }
}

