/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.List;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class GuardRecruitmentExpedition
extends SettlerExpedition {
    public GuardRecruitmentExpedition() {
        this.initDisplayName();
        this.setCategory("recruitment");
    }

    public void initDisplayName() {
        this.displayName = new LocalMessage("expedition", "guardrecruit");
    }

    public GameMessage getUnavailableMessage() {
        return new LocalMessage("expedition", "guardrecruitunavailable");
    }

    public boolean isAvailable(ServerSettlementData settlement) {
        return this.getSuccessChance(settlement) > 0.0f;
    }

    public float getSuccessChance(ServerSettlementData settlement) {
        if (settlement == null) {
            return 0.0f;
        }
        int completedTiers = settlement.getQuestTiersCompleted();
        float baseChance = 0.5f + (float)completedTiers * 0.1f;
        return Math.min(baseChance, 0.9f);
    }

    public int getBaseCost(ServerSettlementData settlement) {
        return 500;
    }

    public List<InventoryItem> getRewardItems(ServerSettlementData settlement, HumanMob mob) {
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        rewards.add(new InventoryItem("ironsword", 1));
        if (GameRandom.globalRandom.getChance(0.4f)) {
            int coinAmount = GameRandom.globalRandom.getIntBetween(50, 100);
            rewards.add(new InventoryItem("coin", coinAmount));
        }
        return rewards;
    }

    public List<InventoryItem> getItemIcons() {
        ArrayList<InventoryItem> icons = new ArrayList<InventoryItem>();
        icons.add(new InventoryItem("ironhelmet"));
        return icons;
    }

    public int getTicksToComplete() {
        return GameRandom.globalRandom.getIntBetween(10000, 16000);
    }
}

