/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.util.ArrayList;
import java.util.List;
import necesse.engine.expeditions.SettlerExpedition;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.inventory.InventoryItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;

public class CowboyRecruitmentExpedition
extends SettlerExpedition {
    public CowboyRecruitmentExpedition() {
        this.initDisplayName();
        this.setCategory("recruitment");
    }

    public void initDisplayName() {
        this.displayName = new LocalMessage("expedition", "cowboyrecruit");
    }

    public GameMessage getUnavailableMessage() {
        return new LocalMessage("expedition", "cowboyrecruitunavailable");
    }

    public boolean isAvailable(ServerSettlementData settlement) {
        return this.getSuccessChance(settlement) > 0.0f;
    }

    public float getSuccessChance(ServerSettlementData settlement) {
        if (settlement == null) {
            return 0.0f;
        }
        if (CowboyRecruitmentExpedition.questProgressSuccessChance((ServerSettlementData)settlement, (String)"swampguardian") <= 0.0f) {
            return 0.0f;
        }
        int completedTiers = settlement.getQuestTiersCompleted();
        float baseChance = 0.5f + (float)completedTiers * 0.07f;
        return Math.min(baseChance, 0.8f);
    }

    public int getBaseCost(ServerSettlementData settlement) {
        return 1500;
    }

    public List<InventoryItem> getRewardItems(ServerSettlementData settlement, HumanMob mob) {
        ArrayList<InventoryItem> rewards = new ArrayList<InventoryItem>();
        rewards.add(new InventoryItem("coin", 100));
        rewards.add(new InventoryItem("sixshooter", 1));
        return rewards;
    }

    public List<InventoryItem> getItemIcons() {
        ArrayList<InventoryItem> icons = new ArrayList<InventoryItem>();
        icons.add(new InventoryItem("gunslingerhat"));
        return icons;
    }

    public int getTicksToComplete() {
        return GameRandom.globalRandom.getIntBetween(10000, 16000);
    }
}

