/*
 * Decompiled with CFR 0.152.
 */
package tpamod.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import tpamod.data.WarpConfig;

public class WarpListener {
    private WarpConfig config = new WarpConfig();
    private Cache<String, Long> warpCooldowns;

    public WarpListener() {
        this.rebuildCache();
    }

    private void rebuildCache() {
        this.warpCooldowns = CacheBuilder.newBuilder().expireAfterWrite(this.config.getCooldownSeconds(), TimeUnit.SECONDS).build();
    }

    public boolean isOnCooldown(String playerName) {
        return this.warpCooldowns.getIfPresent(playerName) != null;
    }

    public long getRemainingCooldown(long playerAuth) {
        String playerKey = String.valueOf(playerAuth);
        Long lastWarpTime = this.warpCooldowns.getIfPresent(playerKey);
        if (lastWarpTime == null) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastWarpTime;
        long remaining = (long)(this.config.getCooldownSeconds() * 1000) - elapsed;
        return Math.max(0L, remaining);
    }

    public void setCooldown(long playerAuth, int cooldownSeconds) {
        String playerKey = String.valueOf(playerAuth);
        this.warpCooldowns.put(playerKey, System.currentTimeMillis());
    }

    public int getCooldownSeconds() {
        return this.config.getCooldownSeconds();
    }

    public void setCooldownSeconds(int seconds) {
        this.config.setCooldownSeconds(seconds);
        this.rebuildCache();
    }
}

