/*
 * Decompiled with CFR 0.152.
 */
package tpamod.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.concurrent.TimeUnit;
import necesse.engine.GameEventListener;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import tpamod.events.TPARequestEvent;
import tpamod.events.TPAResponseEvent;

public class TPAListener {
    private TPARequestListener requestListener = new TPARequestListener(this);
    private TPAResponseListener responseListener = new TPAResponseListener(this);
    private int cooldownSeconds = 30;
    private Cache<String, TPARequestEvent> requests;

    public TPAListener() {
        this.loadConfig();
        this.rebuildCache();
    }

    private void rebuildCache() {
        this.requests = CacheBuilder.newBuilder().expireAfterWrite(this.cooldownSeconds, TimeUnit.SECONDS).build();
    }

    public void setCooldownSeconds(int seconds) {
        this.cooldownSeconds = seconds;
        this.rebuildCache();
        this.saveConfig();
    }

    public int getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    private void saveConfig() {
        try {
            SaveData saveData = new SaveData("TPAConfig");
            saveData.addInt("cooldownSeconds", this.cooldownSeconds);
            File configFile = new File("config/tpamod/tpaconfig.dat");
            configFile.getParentFile().mkdirs();
            saveData.saveScript(configFile);
        }
        catch (Exception e) {
            System.out.println("EzWarp: Failed to save config: " + e.getMessage());
        }
    }

    private void loadConfig() {
        try {
            LoadData loadData;
            int savedCooldown;
            File configFile = new File("config/tpamod/tpaconfig.dat");
            if (configFile.exists() && (savedCooldown = (loadData = new LoadData(configFile)).getInt("cooldownSeconds", 30)) >= 1 && savedCooldown <= 3600) {
                this.cooldownSeconds = savedCooldown;
                System.out.println("EzWarp: Loaded cooldown time: " + savedCooldown + " seconds");
            }
        }
        catch (Exception e) {
            System.out.println("EzWarp: Using default cooldown time (30 seconds)");
        }
    }

    private void onRequest(TPARequestEvent request) {
        TPARequestEvent existingRequest = this.findRequestByTarget(request.target.getName());
        if (existingRequest != null) {
            request.preventDefault();
            request.logs.addClient(request.target.getName() + " already has a pending teleport request, please try again later", request.source);
            return;
        }
        String cacheKey = this.getCacheKey(request.source.getName(), request.target.getName());
        if (this.requests.getIfPresent(cacheKey) == null) {
            this.requests.put(cacheKey, request);
            return;
        }
        request.preventDefault();
    }

    private String getCacheKey(String sourceName, String targetName) {
        return sourceName + "->" + targetName;
    }

    private void onResponse(TPAResponseEvent response) {
        if (response.sourcePlayer != null) {
            String cacheKey = this.getCacheKey(response.sourcePlayer.getName(), response.teleportTarget.getName());
            TPARequestEvent request = this.requests.getIfPresent(cacheKey);
            if (request == null) {
                response.preventDefault();
                return;
            }
            if (response.accepted) {
                request.execute();
            } else {
                request.reject();
            }
            this.requests.invalidate(cacheKey);
        } else {
            boolean foundRequest = false;
            TPARequestEvent request = this.findRequestByTarget(response.teleportTarget.getName());
            while (request != null) {
                foundRequest = true;
                if (response.accepted) {
                    request.execute();
                } else {
                    request.reject();
                }
                String cacheKey = this.getCacheKey(request.source.getName(), request.target.getName());
                this.requests.invalidate(cacheKey);
                request = this.findRequestByTarget(response.teleportTarget.getName());
            }
            if (!foundRequest) {
                response.preventDefault();
            }
        }
    }

    private TPARequestEvent findRequestByTarget(String targetName) {
        for (String key : this.requests.asMap().keySet()) {
            if (!key.endsWith("->" + targetName)) continue;
            return this.requests.getIfPresent(key);
        }
        return null;
    }

    public GameEventListener<TPARequestEvent> getRequestListener() {
        return this.requestListener;
    }

    public GameEventListener<TPAResponseEvent> getResponseListener() {
        return this.responseListener;
    }

    private class TPARequestListener
    extends GameEventListener<TPARequestEvent> {
        private final TPAListener listener;

        public TPARequestListener(TPAListener listener) {
            this.listener = listener;
        }

        public void onEvent(TPARequestEvent var1) {
            this.listener.onRequest(var1);
        }
    }

    private class TPAResponseListener
    extends GameEventListener<TPAResponseEvent> {
        private final TPAListener listener;

        public TPAResponseListener(TPAListener listener) {
            this.listener = listener;
        }

        public void onEvent(TPAResponseEvent var1) {
            this.listener.onResponse(var1);
        }
    }
}

