/*
 * Decompiled with CFR 0.152.
 */
package tpamod.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import necesse.engine.network.server.ServerClient;
import tpamod.data.RTPConfig;
import tpamod.data.RTPLimitConfig;
import tpamod.util.PermissionUtil;

public class RTPListener {
    private RTPConfig config = new RTPConfig();
    private RTPLimitConfig limitConfig = new RTPLimitConfig();
    private Cache<String, Long> rtpCooldowns;

    public RTPListener() {
        this.rebuildCache();
    }

    private void rebuildCache() {
        this.rtpCooldowns = CacheBuilder.newBuilder().expireAfterWrite(this.config.getCooldownSeconds(), TimeUnit.SECONDS).build();
    }

    public boolean isOnCooldown(String playerName) {
        return this.rtpCooldowns.getIfPresent(playerName) != null;
    }

    public long getRemainingCooldown(long playerAuth) {
        String playerKey = String.valueOf(playerAuth);
        Long lastRTPTime = this.rtpCooldowns.getIfPresent(playerKey);
        if (lastRTPTime == null) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastRTPTime;
        long remaining = (long)(this.config.getCooldownSeconds() * 1000) - elapsed;
        return Math.max(0L, remaining);
    }

    public void setCooldown(long playerAuth, int cooldownSeconds) {
        String playerKey = String.valueOf(playerAuth);
        this.rtpCooldowns.put(playerKey, System.currentTimeMillis());
    }

    public int getCooldownSeconds() {
        return this.config.getCooldownSeconds();
    }

    public void setCooldownSeconds(int seconds) {
        this.config.setCooldownSeconds(seconds);
        this.rebuildCache();
    }

    public int getLimitRange() {
        return this.limitConfig.getLimitRange();
    }

    public void setLimitRange(int range) {
        this.limitConfig.setLimitRange(range);
    }

    public boolean isCooldownExempt(ServerClient serverClient) {
        return PermissionUtil.isAdminOrOwner(serverClient);
    }
}

