/*
 * Decompiled with CFR 0.152.
 */
package tpamod.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.PlayerMob;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import tpamod.data.BackData;

public class BackListener {
    private final BackData backData;
    private final Cache<String, Long> cooldownCache;

    public BackListener(BackData backData) {
        this.backData = backData;
        this.cooldownCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    }

    public void recordTeleportPosition(ServerClient serverClient) {
        if (serverClient != null && serverClient.playerMob != null) {
            String playerAuth = String.valueOf(serverClient.authentication);
            PlayerMob playerMob = serverClient.playerMob;
            String levelIdentifier = playerMob.getLevel().getIdentifier().toString();
            int levelType = this.getLevelTypeFromIdentifier(levelIdentifier);
            int x = (int)playerMob.x;
            int y = (int)playerMob.y;
            String biomeIdentifier = this.getCurrentBiomeIdentifier(playerMob.getLevel(), playerMob.x, playerMob.y);
            this.backData.recordTeleportPosition(playerAuth, levelType, x, y, biomeIdentifier);
            System.out.println("Back System: Recorded teleport position for " + serverClient.getName() + " in biome: " + biomeIdentifier);
        }
    }

    public void recordDeathPosition(ServerClient serverClient) {
        if (serverClient != null && serverClient.playerMob != null) {
            String playerAuth = String.valueOf(serverClient.authentication);
            PlayerMob playerMob = serverClient.playerMob;
            String levelIdentifier = playerMob.getLevel().getIdentifier().toString();
            int levelType = this.getLevelTypeFromIdentifier(levelIdentifier);
            int x = (int)playerMob.x;
            int y = (int)playerMob.y;
            String biomeIdentifier = this.getCurrentBiomeIdentifier(playerMob.getLevel(), playerMob.x, playerMob.y);
            this.backData.recordDeathPosition(playerAuth, levelType, x, y, biomeIdentifier);
            System.out.println("Back System: Recorded death position for " + serverClient.getName() + " in biome: " + biomeIdentifier);
        }
    }

    public void setCooldown(String playerAuth, int cooldownSeconds) {
        long cooldownEndTime = System.currentTimeMillis() + (long)cooldownSeconds * 1000L;
        this.cooldownCache.put(playerAuth, cooldownEndTime);
    }

    public long getRemainingCooldown(String playerAuth) {
        Long cooldownEndTime = this.cooldownCache.getIfPresent(playerAuth);
        if (cooldownEndTime != null) {
            long remaining = cooldownEndTime - System.currentTimeMillis();
            return Math.max(0L, remaining);
        }
        return 0L;
    }

    public void setCooldownSeconds(int seconds) {
        System.out.println("Back System: Global cooldown time updated to " + seconds + " seconds");
    }

    private int getLevelTypeFromIdentifier(String levelIdentifier) {
        try {
            return Math.abs(levelIdentifier.hashCode() % 1000);
        }
        catch (Exception e) {
            System.out.println("Back System: Failed to get level type from identifier: " + levelIdentifier);
            return 0;
        }
    }

    private String getCurrentBiomeIdentifier(Level level, float x, float y) {
        try {
            int tileX = (int)(x / 32.0f);
            int tileY = (int)(y / 32.0f);
            Biome biome = level.getBiome(tileX, tileY);
            if (biome != null) {
                return biome.getStringID();
            }
        }
        catch (Exception e) {
            System.out.println("Back System: Failed to get biome identifier: " + e.getMessage());
        }
        return "unknown";
    }
}

