/*
 * Decompiled with CFR 0.152.
 */
package tpamod.events;

import necesse.engine.commands.CommandLog;
import necesse.engine.events.PreventableGameEvent;
import necesse.engine.network.server.ServerClient;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import tpamod.data.BackData;

public class TPARequestEvent
extends PreventableGameEvent {
    public final ServerClient target;
    public final ServerClient source;
    public final CommandLog logs;
    private final BackData backData;

    public TPARequestEvent(ServerClient source, ServerClient target, CommandLog logs, BackData backData) {
        this.source = source;
        this.target = target;
        this.logs = logs;
        this.backData = backData;
    }

    public void execute() {
        if (this.source != null && this.target != null && this.target.playerMob != null) {
            if (this.source.playerMob != null) {
                float currentX = this.source.playerMob.getX();
                float currentY = this.source.playerMob.getY();
                String levelIdentifier = this.source.playerMob.getLevel().getIdentifier().toString();
                int currentLevelType = this.getLevelTypeFromIdentifier(levelIdentifier);
                String currentBiomeIdentifier = this.getCurrentBiomeIdentifier(this.source.playerMob.getLevel(), currentX, currentY);
                this.backData.recordTeleportPosition(String.valueOf(this.source.authentication), currentLevelType, (int)currentX, (int)currentY, currentBiomeIdentifier);
            }
            this.source.playerMob.setPos((float)this.target.playerMob.getX(), (float)this.target.playerMob.getY(), true);
            this.logs.addClient("Teleported to " + this.target.getName(), this.source);
        }
    }

    public void expire() {
        this.logs.addClient("Teleport request to " + this.target.getName() + " has expired", this.source);
        this.logs.addClient("Teleport request from " + this.source.getName() + " has expired", this.target);
    }

    public void reject() {
        this.logs.addClient("Teleport request to " + this.target.getName() + " has been rejected", this.source);
        this.logs.addClient("Teleport request from " + this.source.getName() + " has been rejected", this.target);
    }

    private int getLevelTypeFromIdentifier(String levelIdentifier) {
        try {
            return Math.abs(levelIdentifier.hashCode() % 1000);
        }
        catch (Exception e) {
            System.out.println("TPA System: Failed to get level type from identifier: " + levelIdentifier);
            return 0;
        }
    }

    private String getCurrentBiomeIdentifier(Level level, float x, float y) {
        try {
            int tileX = (int)(x / 32.0f);
            int tileY = (int)(y / 32.0f);
            Biome biome = level.getBiome(tileX, tileY);
            if (biome != null) {
                return biome.getStringID();
            }
        }
        catch (Exception e) {
            System.out.println("TPA System: Failed to get biome identifier: " + e.getMessage());
        }
        return "unknown";
    }
}

